<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TopoCurveType StructType
 * @subpackage Structs
 */
class TopoCurveType extends AbstractStructBase
{
    /**
     * The directedEdge
     * @var \StructType\DirectedEdgePropertyType
     */
    public $directedEdge;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for TopoCurveType
     * @uses TopoCurveType::setDirectedEdge()
     * @uses TopoCurveType::setAggregationType()
     * @param \StructType\DirectedEdgePropertyType $directedEdge
     * @param string $aggregationType
     */
    public function __construct(\StructType\DirectedEdgePropertyType $directedEdge = null, $aggregationType = null)
    {
        $this
            ->setDirectedEdge($directedEdge)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get directedEdge value
     * @return \StructType\DirectedEdgePropertyType|null
     */
    public function getDirectedEdge()
    {
        return $this->directedEdge;
    }
    /**
     * Set directedEdge value
     * @param \StructType\DirectedEdgePropertyType $directedEdge
     * @return \StructType\TopoCurveType
     */
    public function setDirectedEdge(\StructType\DirectedEdgePropertyType $directedEdge = null)
    {
        $this->directedEdge = $directedEdge;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\TopoCurveType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
