<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TopoComplexType StructType
 * @subpackage Structs
 */
class TopoComplexType extends AbstractStructBase
{
    /**
     * The maximalComplex
     * @var \StructType\TopoComplexPropertyType
     */
    public $maximalComplex;
    /**
     * The superComplex
     * @var \StructType\TopoComplexPropertyType
     */
    public $superComplex;
    /**
     * The subComplex
     * @var \StructType\TopoComplexPropertyType
     */
    public $subComplex;
    /**
     * The topoPrimitiveMember
     * @var \StructType\TopoPrimitiveMemberType
     */
    public $topoPrimitiveMember;
    /**
     * The topoPrimitiveMembers
     * @var \StructType\TopoPrimitiveArrayAssociationType
     */
    public $topoPrimitiveMembers;
    /**
     * The isMaximal
     * @var bool
     */
    public $isMaximal;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for TopoComplexType
     * @uses TopoComplexType::setMaximalComplex()
     * @uses TopoComplexType::setSuperComplex()
     * @uses TopoComplexType::setSubComplex()
     * @uses TopoComplexType::setTopoPrimitiveMember()
     * @uses TopoComplexType::setTopoPrimitiveMembers()
     * @uses TopoComplexType::setIsMaximal()
     * @uses TopoComplexType::setAggregationType()
     * @param \StructType\TopoComplexPropertyType $maximalComplex
     * @param \StructType\TopoComplexPropertyType $superComplex
     * @param \StructType\TopoComplexPropertyType $subComplex
     * @param \StructType\TopoPrimitiveMemberType $topoPrimitiveMember
     * @param \StructType\TopoPrimitiveArrayAssociationType $topoPrimitiveMembers
     * @param bool $isMaximal
     * @param string $aggregationType
     */
    public function __construct(\StructType\TopoComplexPropertyType $maximalComplex = null, \StructType\TopoComplexPropertyType $superComplex = null, \StructType\TopoComplexPropertyType $subComplex = null, \StructType\TopoPrimitiveMemberType $topoPrimitiveMember = null, \StructType\TopoPrimitiveArrayAssociationType $topoPrimitiveMembers = null, $isMaximal = null, $aggregationType = null)
    {
        $this
            ->setMaximalComplex($maximalComplex)
            ->setSuperComplex($superComplex)
            ->setSubComplex($subComplex)
            ->setTopoPrimitiveMember($topoPrimitiveMember)
            ->setTopoPrimitiveMembers($topoPrimitiveMembers)
            ->setIsMaximal($isMaximal)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get maximalComplex value
     * @return \StructType\TopoComplexPropertyType|null
     */
    public function getMaximalComplex()
    {
        return $this->maximalComplex;
    }
    /**
     * Set maximalComplex value
     * @param \StructType\TopoComplexPropertyType $maximalComplex
     * @return \StructType\TopoComplexType
     */
    public function setMaximalComplex(\StructType\TopoComplexPropertyType $maximalComplex = null)
    {
        $this->maximalComplex = $maximalComplex;
        return $this;
    }
    /**
     * Get superComplex value
     * @return \StructType\TopoComplexPropertyType|null
     */
    public function getSuperComplex()
    {
        return $this->superComplex;
    }
    /**
     * Set superComplex value
     * @param \StructType\TopoComplexPropertyType $superComplex
     * @return \StructType\TopoComplexType
     */
    public function setSuperComplex(\StructType\TopoComplexPropertyType $superComplex = null)
    {
        $this->superComplex = $superComplex;
        return $this;
    }
    /**
     * Get subComplex value
     * @return \StructType\TopoComplexPropertyType|null
     */
    public function getSubComplex()
    {
        return $this->subComplex;
    }
    /**
     * Set subComplex value
     * @param \StructType\TopoComplexPropertyType $subComplex
     * @return \StructType\TopoComplexType
     */
    public function setSubComplex(\StructType\TopoComplexPropertyType $subComplex = null)
    {
        $this->subComplex = $subComplex;
        return $this;
    }
    /**
     * Get topoPrimitiveMember value
     * @return \StructType\TopoPrimitiveMemberType|null
     */
    public function getTopoPrimitiveMember()
    {
        return $this->topoPrimitiveMember;
    }
    /**
     * Set topoPrimitiveMember value
     * @param \StructType\TopoPrimitiveMemberType $topoPrimitiveMember
     * @return \StructType\TopoComplexType
     */
    public function setTopoPrimitiveMember(\StructType\TopoPrimitiveMemberType $topoPrimitiveMember = null)
    {
        $this->topoPrimitiveMember = $topoPrimitiveMember;
        return $this;
    }
    /**
     * Get topoPrimitiveMembers value
     * @return \StructType\TopoPrimitiveArrayAssociationType|null
     */
    public function getTopoPrimitiveMembers()
    {
        return $this->topoPrimitiveMembers;
    }
    /**
     * Set topoPrimitiveMembers value
     * @param \StructType\TopoPrimitiveArrayAssociationType $topoPrimitiveMembers
     * @return \StructType\TopoComplexType
     */
    public function setTopoPrimitiveMembers(\StructType\TopoPrimitiveArrayAssociationType $topoPrimitiveMembers = null)
    {
        $this->topoPrimitiveMembers = $topoPrimitiveMembers;
        return $this;
    }
    /**
     * Get isMaximal value
     * @return bool|null
     */
    public function getIsMaximal()
    {
        return $this->isMaximal;
    }
    /**
     * Set isMaximal value
     * @param bool $isMaximal
     * @return \StructType\TopoComplexType
     */
    public function setIsMaximal($isMaximal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMaximal) && !is_bool($isMaximal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMaximal, true), gettype($isMaximal)), __LINE__);
        }
        $this->isMaximal = $isMaximal;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\TopoComplexType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
