<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeEdgeType StructType
 * @subpackage Structs
 */
class TimeEdgeType extends AbstractStructBase
{
    /**
     * The start
     * @var \StructType\TimeNodePropertyType
     */
    public $start;
    /**
     * The end
     * @var \StructType\TimeNodePropertyType
     */
    public $end;
    /**
     * The extent
     * @var \StructType\TimePeriodPropertyType
     */
    public $extent;
    /**
     * Constructor method for TimeEdgeType
     * @uses TimeEdgeType::setStart()
     * @uses TimeEdgeType::setEnd()
     * @uses TimeEdgeType::setExtent()
     * @param \StructType\TimeNodePropertyType $start
     * @param \StructType\TimeNodePropertyType $end
     * @param \StructType\TimePeriodPropertyType $extent
     */
    public function __construct(\StructType\TimeNodePropertyType $start = null, \StructType\TimeNodePropertyType $end = null, \StructType\TimePeriodPropertyType $extent = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setExtent($extent);
    }
    /**
     * Get start value
     * @return \StructType\TimeNodePropertyType|null
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param \StructType\TimeNodePropertyType $start
     * @return \StructType\TimeEdgeType
     */
    public function setStart(\StructType\TimeNodePropertyType $start = null)
    {
        $this->start = $start;
        return $this;
    }
    /**
     * Get end value
     * @return \StructType\TimeNodePropertyType|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param \StructType\TimeNodePropertyType $end
     * @return \StructType\TimeEdgeType
     */
    public function setEnd(\StructType\TimeNodePropertyType $end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get extent value
     * @return \StructType\TimePeriodPropertyType|null
     */
    public function getExtent()
    {
        return $this->extent;
    }
    /**
     * Set extent value
     * @param \StructType\TimePeriodPropertyType $extent
     * @return \StructType\TimeEdgeType
     */
    public function setExtent(\StructType\TimePeriodPropertyType $extent = null)
    {
        $this->extent = $extent;
        return $this;
    }
}
