<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuchprofilKontaktperson StructType
 * Meta information extracted from the WSDL
 * - documentation: Suchprofil für Kontaktpersonen.
 * @subpackage Structs
 */
class SuchprofilKontaktperson extends Suchprofil
{
    /**
     * The organisationseinheitID
     * Meta information extracted from the WSDL
     * - documentation: IDs von Organisationseinheiten, denen die Mitarbeiter zugeordnet sein sollen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $organisationseinheitID;
    /**
     * The standortGebietID
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Gebieten in Adressen (Standortsuche nach Mitarbeitern). Hier werden neben den konkreten Anschriften der Mitarbeiter auch die Anschriften der Organisationseinheiten, welche die Mitarbeiter zugeordnet sind, betrachtet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $standortGebietID;
    /**
     * The zustaendigkeitLeistungID
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Leistungen, für welche der Mitarbeiter zuständig sein soll. In Kombination mit zustaendigkeitGebietID. Hier müssen insbesondere Mitarbeiter "eingesammelt werden, welche Organisationseinheiten mit dieser Zuständigkeit
     * zugeordnet sind.Weiterhin muss die konkrete Zuständigkeit der Kontaktperson betrachtet werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $zustaendigkeitLeistungID;
    /**
     * The zustaendigkeitGebietID
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Gebieten, für welche der Mitarbeiter zuständig sein soll. In Kombination mit zustaendigkeitLeistungID. Hier muss insbesondere die Zuständigkeit der Organisationseinheit, welcher die Person zugeordnet ist, betrachtet
     * werden. Weiterhin die konkrete Zuständigkeit der Kontaktperson.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $zustaendigkeitGebietID;
    /**
     * The kennzeichenNurBasisinformation
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichen, ob nur Basisinformationen zurückgegeben werden soll. In NachrichtenAntworten wird dann anstatt des eigentlichen Objekts das BasisinformationObjekt zurückgegeben. Bei Kontaktpersonen sollte dies "Vorname Nachname" sein.
     * - default: false
     * @var bool
     */
    public $kennzeichenNurBasisinformation;
    /**
     * Constructor method for SuchprofilKontaktperson
     * @uses SuchprofilKontaktperson::setOrganisationseinheitID()
     * @uses SuchprofilKontaktperson::setStandortGebietID()
     * @uses SuchprofilKontaktperson::setZustaendigkeitLeistungID()
     * @uses SuchprofilKontaktperson::setZustaendigkeitGebietID()
     * @uses SuchprofilKontaktperson::setKennzeichenNurBasisinformation()
     * @param \StructType\Identifikator[] $organisationseinheitID
     * @param \StructType\Identifikator[] $standortGebietID
     * @param \StructType\Identifikator[] $zustaendigkeitLeistungID
     * @param \StructType\Identifikator[] $zustaendigkeitGebietID
     * @param bool $kennzeichenNurBasisinformation
     */
    public function __construct(array $organisationseinheitID = array(), array $standortGebietID = array(), array $zustaendigkeitLeistungID = array(), array $zustaendigkeitGebietID = array(), $kennzeichenNurBasisinformation = false)
    {
        $this
            ->setOrganisationseinheitID($organisationseinheitID)
            ->setStandortGebietID($standortGebietID)
            ->setZustaendigkeitLeistungID($zustaendigkeitLeistungID)
            ->setZustaendigkeitGebietID($zustaendigkeitGebietID)
            ->setKennzeichenNurBasisinformation($kennzeichenNurBasisinformation);
    }
    /**
     * Get organisationseinheitID value
     * @return \StructType\Identifikator[]|null
     */
    public function getOrganisationseinheitID()
    {
        return $this->organisationseinheitID;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganisationseinheitID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganisationseinheitID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganisationseinheitIDForArrayConstraintsFromSetOrganisationseinheitID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilKontaktpersonOrganisationseinheitIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilKontaktpersonOrganisationseinheitIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilKontaktpersonOrganisationseinheitIDItem) ? get_class($suchprofilKontaktpersonOrganisationseinheitIDItem) : sprintf('%s(%s)', gettype($suchprofilKontaktpersonOrganisationseinheitIDItem), var_export($suchprofilKontaktpersonOrganisationseinheitIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The organisationseinheitID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set organisationseinheitID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $organisationseinheitID
     * @return \StructType\SuchprofilKontaktperson
     */
    public function setOrganisationseinheitID(array $organisationseinheitID = array())
    {
        // validation for constraint: array
        if ('' !== ($organisationseinheitIDArrayErrorMessage = self::validateOrganisationseinheitIDForArrayConstraintsFromSetOrganisationseinheitID($organisationseinheitID))) {
            throw new \InvalidArgumentException($organisationseinheitIDArrayErrorMessage, __LINE__);
        }
        $this->organisationseinheitID = $organisationseinheitID;
        return $this;
    }
    /**
     * Add item to organisationseinheitID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilKontaktperson
     */
    public function addToOrganisationseinheitID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The organisationseinheitID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->organisationseinheitID[] = $item;
        return $this;
    }
    /**
     * Get standortGebietID value
     * @return \StructType\Identifikator[]|null
     */
    public function getStandortGebietID()
    {
        return $this->standortGebietID;
    }
    /**
     * This method is responsible for validating the values passed to the setStandortGebietID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStandortGebietID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStandortGebietIDForArrayConstraintsFromSetStandortGebietID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilKontaktpersonStandortGebietIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilKontaktpersonStandortGebietIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilKontaktpersonStandortGebietIDItem) ? get_class($suchprofilKontaktpersonStandortGebietIDItem) : sprintf('%s(%s)', gettype($suchprofilKontaktpersonStandortGebietIDItem), var_export($suchprofilKontaktpersonStandortGebietIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The standortGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set standortGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $standortGebietID
     * @return \StructType\SuchprofilKontaktperson
     */
    public function setStandortGebietID(array $standortGebietID = array())
    {
        // validation for constraint: array
        if ('' !== ($standortGebietIDArrayErrorMessage = self::validateStandortGebietIDForArrayConstraintsFromSetStandortGebietID($standortGebietID))) {
            throw new \InvalidArgumentException($standortGebietIDArrayErrorMessage, __LINE__);
        }
        $this->standortGebietID = $standortGebietID;
        return $this;
    }
    /**
     * Add item to standortGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilKontaktperson
     */
    public function addToStandortGebietID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The standortGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->standortGebietID[] = $item;
        return $this;
    }
    /**
     * Get zustaendigkeitLeistungID value
     * @return \StructType\Identifikator[]|null
     */
    public function getZustaendigkeitLeistungID()
    {
        return $this->zustaendigkeitLeistungID;
    }
    /**
     * This method is responsible for validating the values passed to the setZustaendigkeitLeistungID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZustaendigkeitLeistungID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZustaendigkeitLeistungIDForArrayConstraintsFromSetZustaendigkeitLeistungID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilKontaktpersonZustaendigkeitLeistungIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilKontaktpersonZustaendigkeitLeistungIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilKontaktpersonZustaendigkeitLeistungIDItem) ? get_class($suchprofilKontaktpersonZustaendigkeitLeistungIDItem) : sprintf('%s(%s)', gettype($suchprofilKontaktpersonZustaendigkeitLeistungIDItem), var_export($suchprofilKontaktpersonZustaendigkeitLeistungIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zustaendigkeitLeistungID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zustaendigkeitLeistungID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $zustaendigkeitLeistungID
     * @return \StructType\SuchprofilKontaktperson
     */
    public function setZustaendigkeitLeistungID(array $zustaendigkeitLeistungID = array())
    {
        // validation for constraint: array
        if ('' !== ($zustaendigkeitLeistungIDArrayErrorMessage = self::validateZustaendigkeitLeistungIDForArrayConstraintsFromSetZustaendigkeitLeistungID($zustaendigkeitLeistungID))) {
            throw new \InvalidArgumentException($zustaendigkeitLeistungIDArrayErrorMessage, __LINE__);
        }
        $this->zustaendigkeitLeistungID = $zustaendigkeitLeistungID;
        return $this;
    }
    /**
     * Add item to zustaendigkeitLeistungID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilKontaktperson
     */
    public function addToZustaendigkeitLeistungID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The zustaendigkeitLeistungID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zustaendigkeitLeistungID[] = $item;
        return $this;
    }
    /**
     * Get zustaendigkeitGebietID value
     * @return \StructType\Identifikator[]|null
     */
    public function getZustaendigkeitGebietID()
    {
        return $this->zustaendigkeitGebietID;
    }
    /**
     * This method is responsible for validating the values passed to the setZustaendigkeitGebietID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZustaendigkeitGebietID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZustaendigkeitGebietIDForArrayConstraintsFromSetZustaendigkeitGebietID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilKontaktpersonZustaendigkeitGebietIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilKontaktpersonZustaendigkeitGebietIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilKontaktpersonZustaendigkeitGebietIDItem) ? get_class($suchprofilKontaktpersonZustaendigkeitGebietIDItem) : sprintf('%s(%s)', gettype($suchprofilKontaktpersonZustaendigkeitGebietIDItem), var_export($suchprofilKontaktpersonZustaendigkeitGebietIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zustaendigkeitGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zustaendigkeitGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $zustaendigkeitGebietID
     * @return \StructType\SuchprofilKontaktperson
     */
    public function setZustaendigkeitGebietID(array $zustaendigkeitGebietID = array())
    {
        // validation for constraint: array
        if ('' !== ($zustaendigkeitGebietIDArrayErrorMessage = self::validateZustaendigkeitGebietIDForArrayConstraintsFromSetZustaendigkeitGebietID($zustaendigkeitGebietID))) {
            throw new \InvalidArgumentException($zustaendigkeitGebietIDArrayErrorMessage, __LINE__);
        }
        $this->zustaendigkeitGebietID = $zustaendigkeitGebietID;
        return $this;
    }
    /**
     * Add item to zustaendigkeitGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilKontaktperson
     */
    public function addToZustaendigkeitGebietID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The zustaendigkeitGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zustaendigkeitGebietID[] = $item;
        return $this;
    }
    /**
     * Get kennzeichenNurBasisinformation value
     * @return bool|null
     */
    public function getKennzeichenNurBasisinformation()
    {
        return $this->kennzeichenNurBasisinformation;
    }
    /**
     * Set kennzeichenNurBasisinformation value
     * @param bool $kennzeichenNurBasisinformation
     * @return \StructType\SuchprofilKontaktperson
     */
    public function setKennzeichenNurBasisinformation($kennzeichenNurBasisinformation = false)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenNurBasisinformation) && !is_bool($kennzeichenNurBasisinformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenNurBasisinformation, true), gettype($kennzeichenNurBasisinformation)), __LINE__);
        }
        $this->kennzeichenNurBasisinformation = $kennzeichenNurBasisinformation;
        return $this;
    }
}
