<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuchprofilFormular StructType
 * Meta information extracted from the WSDL
 * - documentation: Suchprofil für Formulare.
 * @subpackage Structs
 */
class SuchprofilFormular extends Suchprofil
{
    /**
     * The leistungID
     * Meta information extracted from the WSDL
     * - documentation: IDs von Leistungen, für welche das Formular relevant sein soll. Die einzelnen IDs werden "ODER" verknüpft.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $leistungID;
    /**
     * The organisationseinheitID
     * Meta information extracted from the WSDL
     * - documentation: Zur Rückgabe von Formularen von bestimmten Organisationseinheiten. Die einzelnen IDs werden "ODER" verknüpft.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $organisationseinheitID;
    /**
     * The gebietID
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Gebieten, für welche das Formular relevant ist.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $gebietID;
    /**
     * The kennzeichenNurBasisinformation
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichen, ob nur Basisinformationen zurückgegeben werden soll. In NachrichtenAntworten wird dann anstatt des eigentlichen Objekts das BasisinformationObjekt zurückgegeben.
     * - default: false
     * @var bool
     */
    public $kennzeichenNurBasisinformation;
    /**
     * Constructor method for SuchprofilFormular
     * @uses SuchprofilFormular::setLeistungID()
     * @uses SuchprofilFormular::setOrganisationseinheitID()
     * @uses SuchprofilFormular::setGebietID()
     * @uses SuchprofilFormular::setKennzeichenNurBasisinformation()
     * @param \StructType\Identifikator[] $leistungID
     * @param \StructType\Identifikator[] $organisationseinheitID
     * @param \StructType\Identifikator[] $gebietID
     * @param bool $kennzeichenNurBasisinformation
     */
    public function __construct(array $leistungID = array(), array $organisationseinheitID = array(), array $gebietID = array(), $kennzeichenNurBasisinformation = false)
    {
        $this
            ->setLeistungID($leistungID)
            ->setOrganisationseinheitID($organisationseinheitID)
            ->setGebietID($gebietID)
            ->setKennzeichenNurBasisinformation($kennzeichenNurBasisinformation);
    }
    /**
     * Get leistungID value
     * @return \StructType\Identifikator[]|null
     */
    public function getLeistungID()
    {
        return $this->leistungID;
    }
    /**
     * This method is responsible for validating the values passed to the setLeistungID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistungID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeistungIDForArrayConstraintsFromSetLeistungID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilFormularLeistungIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilFormularLeistungIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilFormularLeistungIDItem) ? get_class($suchprofilFormularLeistungIDItem) : sprintf('%s(%s)', gettype($suchprofilFormularLeistungIDItem), var_export($suchprofilFormularLeistungIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The leistungID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set leistungID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $leistungID
     * @return \StructType\SuchprofilFormular
     */
    public function setLeistungID(array $leistungID = array())
    {
        // validation for constraint: array
        if ('' !== ($leistungIDArrayErrorMessage = self::validateLeistungIDForArrayConstraintsFromSetLeistungID($leistungID))) {
            throw new \InvalidArgumentException($leistungIDArrayErrorMessage, __LINE__);
        }
        $this->leistungID = $leistungID;
        return $this;
    }
    /**
     * Add item to leistungID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilFormular
     */
    public function addToLeistungID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The leistungID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->leistungID[] = $item;
        return $this;
    }
    /**
     * Get organisationseinheitID value
     * @return \StructType\Identifikator[]|null
     */
    public function getOrganisationseinheitID()
    {
        return $this->organisationseinheitID;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganisationseinheitID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganisationseinheitID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganisationseinheitIDForArrayConstraintsFromSetOrganisationseinheitID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilFormularOrganisationseinheitIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilFormularOrganisationseinheitIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilFormularOrganisationseinheitIDItem) ? get_class($suchprofilFormularOrganisationseinheitIDItem) : sprintf('%s(%s)', gettype($suchprofilFormularOrganisationseinheitIDItem), var_export($suchprofilFormularOrganisationseinheitIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The organisationseinheitID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set organisationseinheitID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $organisationseinheitID
     * @return \StructType\SuchprofilFormular
     */
    public function setOrganisationseinheitID(array $organisationseinheitID = array())
    {
        // validation for constraint: array
        if ('' !== ($organisationseinheitIDArrayErrorMessage = self::validateOrganisationseinheitIDForArrayConstraintsFromSetOrganisationseinheitID($organisationseinheitID))) {
            throw new \InvalidArgumentException($organisationseinheitIDArrayErrorMessage, __LINE__);
        }
        $this->organisationseinheitID = $organisationseinheitID;
        return $this;
    }
    /**
     * Add item to organisationseinheitID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilFormular
     */
    public function addToOrganisationseinheitID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The organisationseinheitID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->organisationseinheitID[] = $item;
        return $this;
    }
    /**
     * Get gebietID value
     * @return \StructType\Identifikator[]|null
     */
    public function getGebietID()
    {
        return $this->gebietID;
    }
    /**
     * This method is responsible for validating the values passed to the setGebietID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGebietID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGebietIDForArrayConstraintsFromSetGebietID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilFormularGebietIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilFormularGebietIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilFormularGebietIDItem) ? get_class($suchprofilFormularGebietIDItem) : sprintf('%s(%s)', gettype($suchprofilFormularGebietIDItem), var_export($suchprofilFormularGebietIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $gebietID
     * @return \StructType\SuchprofilFormular
     */
    public function setGebietID(array $gebietID = array())
    {
        // validation for constraint: array
        if ('' !== ($gebietIDArrayErrorMessage = self::validateGebietIDForArrayConstraintsFromSetGebietID($gebietID))) {
            throw new \InvalidArgumentException($gebietIDArrayErrorMessage, __LINE__);
        }
        $this->gebietID = $gebietID;
        return $this;
    }
    /**
     * Add item to gebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilFormular
     */
    public function addToGebietID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The gebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gebietID[] = $item;
        return $this;
    }
    /**
     * Get kennzeichenNurBasisinformation value
     * @return bool|null
     */
    public function getKennzeichenNurBasisinformation()
    {
        return $this->kennzeichenNurBasisinformation;
    }
    /**
     * Set kennzeichenNurBasisinformation value
     * @param bool $kennzeichenNurBasisinformation
     * @return \StructType\SuchprofilFormular
     */
    public function setKennzeichenNurBasisinformation($kennzeichenNurBasisinformation = false)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenNurBasisinformation) && !is_bool($kennzeichenNurBasisinformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenNurBasisinformation, true), gettype($kennzeichenNurBasisinformation)), __LINE__);
        }
        $this->kennzeichenNurBasisinformation = $kennzeichenNurBasisinformation;
        return $this;
    }
}
