<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuchprofilDatei StructType
 * Meta information extracted from the WSDL
 * - documentation: Suchprofil für Dateien.
 * @subpackage Structs
 */
class SuchprofilDatei extends AbstractStructBase
{
    /**
     * The dateiID
     * Meta information extracted from the WSDL
     * - documentation: Eine oder mehrere IDs der Dateien, welche angefragt werden.
     * - maxOccurs: unbounded
     * @var \StructType\Identifikator[]
     */
    public $dateiID;
    /**
     * Constructor method for SuchprofilDatei
     * @uses SuchprofilDatei::setDateiID()
     * @param \StructType\Identifikator[] $dateiID
     */
    public function __construct(array $dateiID = array())
    {
        $this
            ->setDateiID($dateiID);
    }
    /**
     * Get dateiID value
     * @return \StructType\Identifikator[]|null
     */
    public function getDateiID()
    {
        return $this->dateiID;
    }
    /**
     * This method is responsible for validating the values passed to the setDateiID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDateiID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDateiIDForArrayConstraintsFromSetDateiID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $suchprofilDateiDateiIDItem) {
            // validation for constraint: itemType
            if (!$suchprofilDateiDateiIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($suchprofilDateiDateiIDItem) ? get_class($suchprofilDateiDateiIDItem) : sprintf('%s(%s)', gettype($suchprofilDateiDateiIDItem), var_export($suchprofilDateiDateiIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dateiID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dateiID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $dateiID
     * @return \StructType\SuchprofilDatei
     */
    public function setDateiID(array $dateiID = array())
    {
        // validation for constraint: array
        if ('' !== ($dateiIDArrayErrorMessage = self::validateDateiIDForArrayConstraintsFromSetDateiID($dateiID))) {
            throw new \InvalidArgumentException($dateiIDArrayErrorMessage, __LINE__);
        }
        $this->dateiID = $dateiID;
        return $this;
    }
    /**
     * Add item to dateiID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\SuchprofilDatei
     */
    public function addToDateiID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The dateiID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dateiID[] = $item;
        return $this;
    }
}
