<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sprachversion StructType
 * Meta information extracted from the WSDL
 * - documentation: Sprachversion enthält Versionsinformationen, welche sich auf eine konkrete Sprach(übersetzung) eines Objekts beziehen.
 * @subpackage Structs
 */
class Sprachversion extends Sprache
{
    /**
     * The erstelltDatumZeit
     * Meta information extracted from the WSDL
     * - documentation: Datum und Uhrzeit der Erstellung der Sprachversion. Muss nur angegeben werden, wenn für diese Sprachversion diese Information auch separat zur übergeordneten Versionsinformation vorliegt.
     * - minOccurs: 0
     * @var string
     */
    public $erstelltDatumZeit;
    /**
     * The erstelltDurch
     * Meta information extracted from the WSDL
     * - documentation: Angabe, durch wen die Sprachversion erstellt wurde. Muss nur angegeben werden, wenn für diese Sprachversion diese Information auch separat zur übergeordneten Versionsinformation vorliegt.
     * - minOccurs: 0
     * @var string
     */
    public $erstelltDurch;
    /**
     * The geaendertDatumZeit
     * Meta information extracted from the WSDL
     * - documentation: Datum und Uhrzeit der letzten Änderung der Sprachversion. Muss nur angegeben werden, wenn für diese Sprachversion diese Information auch separat zur übergeordneten Versionsinformation vorliegt.
     * - minOccurs: 0
     * @var string
     */
    public $geaendertDatumZeit;
    /**
     * The geaendertDurch
     * Meta information extracted from the WSDL
     * - documentation: Angabe, von wem die Sprachversion geändert wurde. Muss nur angegeben werden, wenn für diese Sprachversion diese Information auch separat zur übergeordneten Versionsinformation vorliegt.
     * - minOccurs: 0
     * @var string
     */
    public $geaendertDurch;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - documentation: Versionsinformation der Sprachversion. Dies kann z.B. eine Versionsnummer sein. Muss nur angegeben werden, wenn für diese Sprachversion diese Information auch separat zur übergeordneten Versionsinformation vorliegt.
     * - minOccurs: 0
     * @var string
     */
    public $version;
    /**
     * Constructor method for Sprachversion
     * @uses Sprachversion::setErstelltDatumZeit()
     * @uses Sprachversion::setErstelltDurch()
     * @uses Sprachversion::setGeaendertDatumZeit()
     * @uses Sprachversion::setGeaendertDurch()
     * @uses Sprachversion::setVersion()
     * @param string $erstelltDatumZeit
     * @param string $erstelltDurch
     * @param string $geaendertDatumZeit
     * @param string $geaendertDurch
     * @param string $version
     */
    public function __construct($erstelltDatumZeit = null, $erstelltDurch = null, $geaendertDatumZeit = null, $geaendertDurch = null, $version = null)
    {
        $this
            ->setErstelltDatumZeit($erstelltDatumZeit)
            ->setErstelltDurch($erstelltDurch)
            ->setGeaendertDatumZeit($geaendertDatumZeit)
            ->setGeaendertDurch($geaendertDurch)
            ->setVersion($version);
    }
    /**
     * Get erstelltDatumZeit value
     * @return string|null
     */
    public function getErstelltDatumZeit()
    {
        return $this->erstelltDatumZeit;
    }
    /**
     * Set erstelltDatumZeit value
     * @param string $erstelltDatumZeit
     * @return \StructType\Sprachversion
     */
    public function setErstelltDatumZeit($erstelltDatumZeit = null)
    {
        // validation for constraint: string
        if (!is_null($erstelltDatumZeit) && !is_string($erstelltDatumZeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erstelltDatumZeit, true), gettype($erstelltDatumZeit)), __LINE__);
        }
        $this->erstelltDatumZeit = $erstelltDatumZeit;
        return $this;
    }
    /**
     * Get erstelltDurch value
     * @return string|null
     */
    public function getErstelltDurch()
    {
        return $this->erstelltDurch;
    }
    /**
     * Set erstelltDurch value
     * @param string $erstelltDurch
     * @return \StructType\Sprachversion
     */
    public function setErstelltDurch($erstelltDurch = null)
    {
        // validation for constraint: string
        if (!is_null($erstelltDurch) && !is_string($erstelltDurch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erstelltDurch, true), gettype($erstelltDurch)), __LINE__);
        }
        $this->erstelltDurch = $erstelltDurch;
        return $this;
    }
    /**
     * Get geaendertDatumZeit value
     * @return string|null
     */
    public function getGeaendertDatumZeit()
    {
        return $this->geaendertDatumZeit;
    }
    /**
     * Set geaendertDatumZeit value
     * @param string $geaendertDatumZeit
     * @return \StructType\Sprachversion
     */
    public function setGeaendertDatumZeit($geaendertDatumZeit = null)
    {
        // validation for constraint: string
        if (!is_null($geaendertDatumZeit) && !is_string($geaendertDatumZeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geaendertDatumZeit, true), gettype($geaendertDatumZeit)), __LINE__);
        }
        $this->geaendertDatumZeit = $geaendertDatumZeit;
        return $this;
    }
    /**
     * Get geaendertDurch value
     * @return string|null
     */
    public function getGeaendertDurch()
    {
        return $this->geaendertDurch;
    }
    /**
     * Set geaendertDurch value
     * @param string $geaendertDurch
     * @return \StructType\Sprachversion
     */
    public function setGeaendertDurch($geaendertDurch = null)
    {
        // validation for constraint: string
        if (!is_null($geaendertDurch) && !is_string($geaendertDurch)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geaendertDurch, true), gettype($geaendertDurch)), __LINE__);
        }
        $this->geaendertDurch = $geaendertDurch;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\Sprachversion
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
