<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SolidType StructType
 * @subpackage Structs
 */
class SolidType extends AbstractStructBase
{
    /**
     * The exterior
     * @var \StructType\ShellPropertyType
     */
    public $exterior;
    /**
     * The interior
     * @var \StructType\ShellPropertyType
     */
    public $interior;
    /**
     * Constructor method for SolidType
     * @uses SolidType::setExterior()
     * @uses SolidType::setInterior()
     * @param \StructType\ShellPropertyType $exterior
     * @param \StructType\ShellPropertyType $interior
     */
    public function __construct(\StructType\ShellPropertyType $exterior = null, \StructType\ShellPropertyType $interior = null)
    {
        $this
            ->setExterior($exterior)
            ->setInterior($interior);
    }
    /**
     * Get exterior value
     * @return \StructType\ShellPropertyType|null
     */
    public function getExterior()
    {
        return $this->exterior;
    }
    /**
     * Set exterior value
     * @param \StructType\ShellPropertyType $exterior
     * @return \StructType\SolidType
     */
    public function setExterior(\StructType\ShellPropertyType $exterior = null)
    {
        $this->exterior = $exterior;
        return $this;
    }
    /**
     * Get interior value
     * @return \StructType\ShellPropertyType|null
     */
    public function getInterior()
    {
        return $this->interior;
    }
    /**
     * Set interior value
     * @param \StructType\ShellPropertyType $interior
     * @return \StructType\SolidType
     */
    public function setInterior(\StructType\ShellPropertyType $interior = null)
    {
        $this->interior = $interior;
        return $this;
    }
}
