<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SolidArrayPropertyType StructType
 * @subpackage Structs
 */
class SolidArrayPropertyType extends AbstractStructBase
{
    /**
     * The AbstractSolid
     * @var \StructType\AbstractSolidType
     */
    public $AbstractSolid;
    /**
     * The owns
     * @var bool
     */
    public $owns;
    /**
     * Constructor method for SolidArrayPropertyType
     * @uses SolidArrayPropertyType::setAbstractSolid()
     * @uses SolidArrayPropertyType::setOwns()
     * @param \StructType\AbstractSolidType $abstractSolid
     * @param bool $owns
     */
    public function __construct(\StructType\AbstractSolidType $abstractSolid = null, $owns = null)
    {
        $this
            ->setAbstractSolid($abstractSolid)
            ->setOwns($owns);
    }
    /**
     * Get AbstractSolid value
     * @return \StructType\AbstractSolidType|null
     */
    public function getAbstractSolid()
    {
        return $this->AbstractSolid;
    }
    /**
     * Set AbstractSolid value
     * @param \StructType\AbstractSolidType $abstractSolid
     * @return \StructType\SolidArrayPropertyType
     */
    public function setAbstractSolid(\StructType\AbstractSolidType $abstractSolid = null)
    {
        $this->AbstractSolid = $abstractSolid;
        return $this;
    }
    /**
     * Get owns value
     * @return bool|null
     */
    public function getOwns()
    {
        return $this->owns;
    }
    /**
     * Set owns value
     * @param bool $owns
     * @return \StructType\SolidArrayPropertyType
     */
    public function setOwns($owns = null)
    {
        // validation for constraint: boolean
        if (!is_null($owns) && !is_bool($owns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($owns, true), gettype($owns)), __LINE__);
        }
        $this->owns = $owns;
        return $this;
    }
}
