<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ScopedName_PropertyType StructType
 * @subpackage Structs
 */
class ScopedName_PropertyType extends AbstractStructBase
{
    /**
     * The ScopedName
     * @var \StructType\CodeType
     */
    public $ScopedName;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for ScopedName_PropertyType
     * @uses ScopedName_PropertyType::setScopedName()
     * @uses ScopedName_PropertyType::setNilReason()
     * @param \StructType\CodeType $scopedName
     * @param string $nilReason
     */
    public function __construct(\StructType\CodeType $scopedName = null, $nilReason = null)
    {
        $this
            ->setScopedName($scopedName)
            ->setNilReason($nilReason);
    }
    /**
     * Get ScopedName value
     * @return \StructType\CodeType|null
     */
    public function getScopedName()
    {
        return $this->ScopedName;
    }
    /**
     * Set ScopedName value
     * @param \StructType\CodeType $scopedName
     * @return \StructType\ScopedName_PropertyType
     */
    public function setScopedName(\StructType\CodeType $scopedName = null)
    {
        $this->ScopedName = $scopedName;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\ScopedName_PropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
