<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SchreibeObjekt StructType
 * Meta information extracted from the WSDL
 * - documentation: Auswahl der eigentlichen Objektklasse. | Datentyp zur schreibenden Übermittlung von Objekten.
 * @subpackage Structs
 */
class SchreibeObjekt extends AbstractStructBase
{
    /**
     * The kennzeichenNeu
     * Meta information extracted from the WSDL
     * - documentation: Ist das Kennzeichen "true", handelt es sich aus Sicht des sendenden Systems um ein neues Objekt, bei "false" um eine Aktualisierung. Ist das Kennzeichen gar nicht gesetzt, handelt es sich um ein "CreateUpdate".
     * - minOccurs: 0
     * @var bool
     */
    public $kennzeichenNeu;
    /**
     * The leistung
     * @var \StructType\Leistung
     */
    public $leistung;
    /**
     * The spezialisierung
     * @var \StructType\LeistungSpezialisierung
     */
    public $spezialisierung;
    /**
     * The organisationseinheit
     * @var \StructType\Organisationseinheit
     */
    public $organisationseinheit;
    /**
     * The person
     * @var \StructType\KontaktpersonTransferobjekt
     */
    public $person;
    /**
     * The formular
     * @var \StructType\Formular
     */
    public $formular;
    /**
     * The gebiet
     * @var \StructType\Gebiet
     */
    public $gebiet;
    /**
     * The zustaendigkeitTransferObjekt
     * @var \StructType\ZustaendigkeitTransferObjekt
     */
    public $zustaendigkeitTransferObjekt;
    /**
     * The ozgLeistung
     * @var \StructType\OZGLeistung
     */
    public $ozgLeistung;
    /**
     * The onlinedienst
     * @var \StructType\Onlinedienst
     */
    public $onlinedienst;
    /**
     * The leistungskategorie
     * @var \StructType\Leistungskategorie
     */
    public $leistungskategorie;
    /**
     * The organisationseinheitskategorie
     * @var \StructType\Organisationseinheitskategorie
     */
    public $organisationseinheitskategorie;
    /**
     * Constructor method for SchreibeObjekt
     * @uses SchreibeObjekt::setKennzeichenNeu()
     * @uses SchreibeObjekt::setLeistung()
     * @uses SchreibeObjekt::setSpezialisierung()
     * @uses SchreibeObjekt::setOrganisationseinheit()
     * @uses SchreibeObjekt::setPerson()
     * @uses SchreibeObjekt::setFormular()
     * @uses SchreibeObjekt::setGebiet()
     * @uses SchreibeObjekt::setZustaendigkeitTransferObjekt()
     * @uses SchreibeObjekt::setOzgLeistung()
     * @uses SchreibeObjekt::setOnlinedienst()
     * @uses SchreibeObjekt::setLeistungskategorie()
     * @uses SchreibeObjekt::setOrganisationseinheitskategorie()
     * @param bool $kennzeichenNeu
     * @param \StructType\Leistung $leistung
     * @param \StructType\LeistungSpezialisierung $spezialisierung
     * @param \StructType\Organisationseinheit $organisationseinheit
     * @param \StructType\KontaktpersonTransferobjekt $person
     * @param \StructType\Formular $formular
     * @param \StructType\Gebiet $gebiet
     * @param \StructType\ZustaendigkeitTransferObjekt $zustaendigkeitTransferObjekt
     * @param \StructType\OZGLeistung $ozgLeistung
     * @param \StructType\Onlinedienst $onlinedienst
     * @param \StructType\Leistungskategorie $leistungskategorie
     * @param \StructType\Organisationseinheitskategorie $organisationseinheitskategorie
     */
    public function __construct($kennzeichenNeu = null, \StructType\Leistung $leistung = null, \StructType\LeistungSpezialisierung $spezialisierung = null, \StructType\Organisationseinheit $organisationseinheit = null, \StructType\KontaktpersonTransferobjekt $person = null, \StructType\Formular $formular = null, \StructType\Gebiet $gebiet = null, \StructType\ZustaendigkeitTransferObjekt $zustaendigkeitTransferObjekt = null, \StructType\OZGLeistung $ozgLeistung = null, \StructType\Onlinedienst $onlinedienst = null, \StructType\Leistungskategorie $leistungskategorie = null, \StructType\Organisationseinheitskategorie $organisationseinheitskategorie = null)
    {
        $this
            ->setKennzeichenNeu($kennzeichenNeu)
            ->setLeistung($leistung)
            ->setSpezialisierung($spezialisierung)
            ->setOrganisationseinheit($organisationseinheit)
            ->setPerson($person)
            ->setFormular($formular)
            ->setGebiet($gebiet)
            ->setZustaendigkeitTransferObjekt($zustaendigkeitTransferObjekt)
            ->setOzgLeistung($ozgLeistung)
            ->setOnlinedienst($onlinedienst)
            ->setLeistungskategorie($leistungskategorie)
            ->setOrganisationseinheitskategorie($organisationseinheitskategorie);
    }
    /**
     * Get kennzeichenNeu value
     * @return bool|null
     */
    public function getKennzeichenNeu()
    {
        return $this->kennzeichenNeu;
    }
    /**
     * Set kennzeichenNeu value
     * @param bool $kennzeichenNeu
     * @return \StructType\SchreibeObjekt
     */
    public function setKennzeichenNeu($kennzeichenNeu = null)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenNeu) && !is_bool($kennzeichenNeu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenNeu, true), gettype($kennzeichenNeu)), __LINE__);
        }
        $this->kennzeichenNeu = $kennzeichenNeu;
        return $this;
    }
    /**
     * Get leistung value
     * @return \StructType\Leistung|null
     */
    public function getLeistung()
    {
        return $this->leistung;
    }
    /**
     * Set leistung value
     * @param \StructType\Leistung $leistung
     * @return \StructType\SchreibeObjekt
     */
    public function setLeistung(\StructType\Leistung $leistung = null)
    {
        $this->leistung = $leistung;
        return $this;
    }
    /**
     * Get spezialisierung value
     * @return \StructType\LeistungSpezialisierung|null
     */
    public function getSpezialisierung()
    {
        return $this->spezialisierung;
    }
    /**
     * Set spezialisierung value
     * @param \StructType\LeistungSpezialisierung $spezialisierung
     * @return \StructType\SchreibeObjekt
     */
    public function setSpezialisierung(\StructType\LeistungSpezialisierung $spezialisierung = null)
    {
        $this->spezialisierung = $spezialisierung;
        return $this;
    }
    /**
     * Get organisationseinheit value
     * @return \StructType\Organisationseinheit|null
     */
    public function getOrganisationseinheit()
    {
        return $this->organisationseinheit;
    }
    /**
     * Set organisationseinheit value
     * @param \StructType\Organisationseinheit $organisationseinheit
     * @return \StructType\SchreibeObjekt
     */
    public function setOrganisationseinheit(\StructType\Organisationseinheit $organisationseinheit = null)
    {
        $this->organisationseinheit = $organisationseinheit;
        return $this;
    }
    /**
     * Get person value
     * @return \StructType\KontaktpersonTransferobjekt|null
     */
    public function getPerson()
    {
        return $this->person;
    }
    /**
     * Set person value
     * @param \StructType\KontaktpersonTransferobjekt $person
     * @return \StructType\SchreibeObjekt
     */
    public function setPerson(\StructType\KontaktpersonTransferobjekt $person = null)
    {
        $this->person = $person;
        return $this;
    }
    /**
     * Get formular value
     * @return \StructType\Formular|null
     */
    public function getFormular()
    {
        return $this->formular;
    }
    /**
     * Set formular value
     * @param \StructType\Formular $formular
     * @return \StructType\SchreibeObjekt
     */
    public function setFormular(\StructType\Formular $formular = null)
    {
        $this->formular = $formular;
        return $this;
    }
    /**
     * Get gebiet value
     * @return \StructType\Gebiet|null
     */
    public function getGebiet()
    {
        return $this->gebiet;
    }
    /**
     * Set gebiet value
     * @param \StructType\Gebiet $gebiet
     * @return \StructType\SchreibeObjekt
     */
    public function setGebiet(\StructType\Gebiet $gebiet = null)
    {
        $this->gebiet = $gebiet;
        return $this;
    }
    /**
     * Get zustaendigkeitTransferObjekt value
     * @return \StructType\ZustaendigkeitTransferObjekt|null
     */
    public function getZustaendigkeitTransferObjekt()
    {
        return $this->zustaendigkeitTransferObjekt;
    }
    /**
     * Set zustaendigkeitTransferObjekt value
     * @param \StructType\ZustaendigkeitTransferObjekt $zustaendigkeitTransferObjekt
     * @return \StructType\SchreibeObjekt
     */
    public function setZustaendigkeitTransferObjekt(\StructType\ZustaendigkeitTransferObjekt $zustaendigkeitTransferObjekt = null)
    {
        $this->zustaendigkeitTransferObjekt = $zustaendigkeitTransferObjekt;
        return $this;
    }
    /**
     * Get ozgLeistung value
     * @return \StructType\OZGLeistung|null
     */
    public function getOzgLeistung()
    {
        return $this->ozgLeistung;
    }
    /**
     * Set ozgLeistung value
     * @param \StructType\OZGLeistung $ozgLeistung
     * @return \StructType\SchreibeObjekt
     */
    public function setOzgLeistung(\StructType\OZGLeistung $ozgLeistung = null)
    {
        $this->ozgLeistung = $ozgLeistung;
        return $this;
    }
    /**
     * Get onlinedienst value
     * @return \StructType\Onlinedienst|null
     */
    public function getOnlinedienst()
    {
        return $this->onlinedienst;
    }
    /**
     * Set onlinedienst value
     * @param \StructType\Onlinedienst $onlinedienst
     * @return \StructType\SchreibeObjekt
     */
    public function setOnlinedienst(\StructType\Onlinedienst $onlinedienst = null)
    {
        $this->onlinedienst = $onlinedienst;
        return $this;
    }
    /**
     * Get leistungskategorie value
     * @return \StructType\Leistungskategorie|null
     */
    public function getLeistungskategorie()
    {
        return $this->leistungskategorie;
    }
    /**
     * Set leistungskategorie value
     * @param \StructType\Leistungskategorie $leistungskategorie
     * @return \StructType\SchreibeObjekt
     */
    public function setLeistungskategorie(\StructType\Leistungskategorie $leistungskategorie = null)
    {
        $this->leistungskategorie = $leistungskategorie;
        return $this;
    }
    /**
     * Get organisationseinheitskategorie value
     * @return \StructType\Organisationseinheitskategorie|null
     */
    public function getOrganisationseinheitskategorie()
    {
        return $this->organisationseinheitskategorie;
    }
    /**
     * Set organisationseinheitskategorie value
     * @param \StructType\Organisationseinheitskategorie $organisationseinheitskategorie
     * @return \StructType\SchreibeObjekt
     */
    public function setOrganisationseinheitskategorie(\StructType\Organisationseinheitskategorie $organisationseinheitskategorie = null)
    {
        $this->organisationseinheitskategorie = $organisationseinheitskategorie;
        return $this;
    }
}
