<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RectifiedGridType StructType
 * @subpackage Structs
 */
class RectifiedGridType extends AbstractStructBase
{
    /**
     * The origin
     * @var \StructType\PointPropertyType
     */
    public $origin;
    /**
     * The offsetVector
     * @var \StructType\VectorType
     */
    public $offsetVector;
    /**
     * Constructor method for RectifiedGridType
     * @uses RectifiedGridType::setOrigin()
     * @uses RectifiedGridType::setOffsetVector()
     * @param \StructType\PointPropertyType $origin
     * @param \StructType\VectorType $offsetVector
     */
    public function __construct(\StructType\PointPropertyType $origin = null, \StructType\VectorType $offsetVector = null)
    {
        $this
            ->setOrigin($origin)
            ->setOffsetVector($offsetVector);
    }
    /**
     * Get origin value
     * @return \StructType\PointPropertyType|null
     */
    public function getOrigin()
    {
        return $this->origin;
    }
    /**
     * Set origin value
     * @param \StructType\PointPropertyType $origin
     * @return \StructType\RectifiedGridType
     */
    public function setOrigin(\StructType\PointPropertyType $origin = null)
    {
        $this->origin = $origin;
        return $this;
    }
    /**
     * Get offsetVector value
     * @return \StructType\VectorType|null
     */
    public function getOffsetVector()
    {
        return $this->offsetVector;
    }
    /**
     * Set offsetVector value
     * @param \StructType\VectorType $offsetVector
     * @return \StructType\RectifiedGridType
     */
    public function setOffsetVector(\StructType\VectorType $offsetVector = null)
    {
        $this->offsetVector = $offsetVector;
        return $this;
    }
}
