<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RectangleType StructType
 * @subpackage Structs
 */
class RectangleType extends AbstractStructBase
{
    /**
     * The exterior
     * @var \StructType\AbstractRingPropertyType
     */
    public $exterior;
    /**
     * The interpolation
     * @var string
     */
    public $interpolation;
    /**
     * Constructor method for RectangleType
     * @uses RectangleType::setExterior()
     * @uses RectangleType::setInterpolation()
     * @param \StructType\AbstractRingPropertyType $exterior
     * @param string $interpolation
     */
    public function __construct(\StructType\AbstractRingPropertyType $exterior = null, $interpolation = null)
    {
        $this
            ->setExterior($exterior)
            ->setInterpolation($interpolation);
    }
    /**
     * Get exterior value
     * @return \StructType\AbstractRingPropertyType|null
     */
    public function getExterior()
    {
        return $this->exterior;
    }
    /**
     * Set exterior value
     * @param \StructType\AbstractRingPropertyType $exterior
     * @return \StructType\RectangleType
     */
    public function setExterior(\StructType\AbstractRingPropertyType $exterior = null)
    {
        $this->exterior = $exterior;
        return $this;
    }
    /**
     * Get interpolation value
     * @return string|null
     */
    public function getInterpolation()
    {
        return $this->interpolation;
    }
    /**
     * Set interpolation value
     * @param string $interpolation
     * @return \StructType\RectangleType
     */
    public function setInterpolation($interpolation = null)
    {
        // validation for constraint: string
        if (!is_null($interpolation) && !is_string($interpolation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interpolation, true), gettype($interpolation)), __LINE__);
        }
        $this->interpolation = $interpolation;
        return $this;
    }
}
