<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PolygonPatchType StructType
 * @subpackage Structs
 */
class PolygonPatchType extends AbstractStructBase
{
    /**
     * The exterior
     * @var \StructType\AbstractRingPropertyType
     */
    public $exterior;
    /**
     * The interior
     * @var \StructType\AbstractRingPropertyType
     */
    public $interior;
    /**
     * The interpolation
     * @var string
     */
    public $interpolation;
    /**
     * Constructor method for PolygonPatchType
     * @uses PolygonPatchType::setExterior()
     * @uses PolygonPatchType::setInterior()
     * @uses PolygonPatchType::setInterpolation()
     * @param \StructType\AbstractRingPropertyType $exterior
     * @param \StructType\AbstractRingPropertyType $interior
     * @param string $interpolation
     */
    public function __construct(\StructType\AbstractRingPropertyType $exterior = null, \StructType\AbstractRingPropertyType $interior = null, $interpolation = null)
    {
        $this
            ->setExterior($exterior)
            ->setInterior($interior)
            ->setInterpolation($interpolation);
    }
    /**
     * Get exterior value
     * @return \StructType\AbstractRingPropertyType|null
     */
    public function getExterior()
    {
        return $this->exterior;
    }
    /**
     * Set exterior value
     * @param \StructType\AbstractRingPropertyType $exterior
     * @return \StructType\PolygonPatchType
     */
    public function setExterior(\StructType\AbstractRingPropertyType $exterior = null)
    {
        $this->exterior = $exterior;
        return $this;
    }
    /**
     * Get interior value
     * @return \StructType\AbstractRingPropertyType|null
     */
    public function getInterior()
    {
        return $this->interior;
    }
    /**
     * Set interior value
     * @param \StructType\AbstractRingPropertyType $interior
     * @return \StructType\PolygonPatchType
     */
    public function setInterior(\StructType\AbstractRingPropertyType $interior = null)
    {
        $this->interior = $interior;
        return $this;
    }
    /**
     * Get interpolation value
     * @return string|null
     */
    public function getInterpolation()
    {
        return $this->interpolation;
    }
    /**
     * Set interpolation value
     * @param string $interpolation
     * @return \StructType\PolygonPatchType
     */
    public function setInterpolation($interpolation = null)
    {
        // validation for constraint: string
        if (!is_null($interpolation) && !is_string($interpolation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interpolation, true), gettype($interpolation)), __LINE__);
        }
        $this->interpolation = $interpolation;
        return $this;
    }
}
