<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PointType StructType
 * @subpackage Structs
 */
class PointType extends AbstractStructBase
{
    /**
     * The pos
     * @var \StructType\DirectPositionType
     */
    public $pos;
    /**
     * The coordinates
     * @var \StructType\CoordinatesType
     */
    public $coordinates;
    /**
     * Constructor method for PointType
     * @uses PointType::setPos()
     * @uses PointType::setCoordinates()
     * @param \StructType\DirectPositionType $pos
     * @param \StructType\CoordinatesType $coordinates
     */
    public function __construct(\StructType\DirectPositionType $pos = null, \StructType\CoordinatesType $coordinates = null)
    {
        $this
            ->setPos($pos)
            ->setCoordinates($coordinates);
    }
    /**
     * Get pos value
     * @return \StructType\DirectPositionType|null
     */
    public function getPos()
    {
        return $this->pos;
    }
    /**
     * Set pos value
     * @param \StructType\DirectPositionType $pos
     * @return \StructType\PointType
     */
    public function setPos(\StructType\DirectPositionType $pos = null)
    {
        $this->pos = $pos;
        return $this;
    }
    /**
     * Get coordinates value
     * @return \StructType\CoordinatesType|null
     */
    public function getCoordinates()
    {
        return $this->coordinates;
    }
    /**
     * Set coordinates value
     * @param \StructType\CoordinatesType $coordinates
     * @return \StructType\PointType
     */
    public function setCoordinates(\StructType\CoordinatesType $coordinates = null)
    {
        $this->coordinates = $coordinates;
        return $this;
    }
}
