<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParameterValueGroupType StructType
 * @subpackage Structs
 */
class ParameterValueGroupType extends AbstractStructBase
{
    /**
     * The parameterValue
     * @var \StructType\AbstractGeneralParameterValuePropertyType
     */
    public $parameterValue;
    /**
     * The group
     * @var \StructType\OperationParameterGroupPropertyType
     */
    public $group;
    /**
     * Constructor method for ParameterValueGroupType
     * @uses ParameterValueGroupType::setParameterValue()
     * @uses ParameterValueGroupType::setGroup()
     * @param \StructType\AbstractGeneralParameterValuePropertyType $parameterValue
     * @param \StructType\OperationParameterGroupPropertyType $group
     */
    public function __construct(\StructType\AbstractGeneralParameterValuePropertyType $parameterValue = null, \StructType\OperationParameterGroupPropertyType $group = null)
    {
        $this
            ->setParameterValue($parameterValue)
            ->setGroup($group);
    }
    /**
     * Get parameterValue value
     * @return \StructType\AbstractGeneralParameterValuePropertyType|null
     */
    public function getParameterValue()
    {
        return $this->parameterValue;
    }
    /**
     * Set parameterValue value
     * @param \StructType\AbstractGeneralParameterValuePropertyType $parameterValue
     * @return \StructType\ParameterValueGroupType
     */
    public function setParameterValue(\StructType\AbstractGeneralParameterValuePropertyType $parameterValue = null)
    {
        $this->parameterValue = $parameterValue;
        return $this;
    }
    /**
     * Get group value
     * @return \StructType\OperationParameterGroupPropertyType|null
     */
    public function getGroup()
    {
        return $this->group;
    }
    /**
     * Set group value
     * @param \StructType\OperationParameterGroupPropertyType $group
     * @return \StructType\ParameterValueGroupType
     */
    public function setGroup(\StructType\OperationParameterGroupPropertyType $group = null)
    {
        $this->group = $group;
        return $this;
    }
}
