<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrganisationseinheitErweitert StructType
 * Meta information extracted from the WSDL
 * - documentation: OrganisationseinheitErweitert ist eine Ableitung von Organisationseinheit mit zugeordneten Zuständigkeiten, Kontaktpersonen und Formularen.
 * @subpackage Structs
 */
class OrganisationseinheitErweitert extends Organisationseinheit
{
    /**
     * The zustaendigkeit
     * Meta information extracted from the WSDL
     * - documentation: Angabe der Zuständigkeit (sachlich und örtlich)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ZustaendigkeitOrganisationseinheit[]
     */
    public $zustaendigkeit;
    /**
     * The formular
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Formularen der OE
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Formular[]
     */
    public $formular;
    /**
     * The kontaktperson
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Kontaktpersonen der OE
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Kontaktperson[]
     */
    public $kontaktperson;
    /**
     * Constructor method for OrganisationseinheitErweitert
     * @uses OrganisationseinheitErweitert::setZustaendigkeit()
     * @uses OrganisationseinheitErweitert::setFormular()
     * @uses OrganisationseinheitErweitert::setKontaktperson()
     * @param \StructType\ZustaendigkeitOrganisationseinheit[] $zustaendigkeit
     * @param \StructType\Formular[] $formular
     * @param \StructType\Kontaktperson[] $kontaktperson
     */
    public function __construct(array $zustaendigkeit = array(), array $formular = array(), array $kontaktperson = array())
    {
        $this
            ->setZustaendigkeit($zustaendigkeit)
            ->setFormular($formular)
            ->setKontaktperson($kontaktperson);
    }
    /**
     * Get zustaendigkeit value
     * @return \StructType\ZustaendigkeitOrganisationseinheit[]|null
     */
    public function getZustaendigkeit()
    {
        return $this->zustaendigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setZustaendigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZustaendigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZustaendigkeitForArrayConstraintsFromSetZustaendigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitErweitertZustaendigkeitItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitErweitertZustaendigkeitItem instanceof \StructType\ZustaendigkeitOrganisationseinheit) {
                $invalidValues[] = is_object($organisationseinheitErweitertZustaendigkeitItem) ? get_class($organisationseinheitErweitertZustaendigkeitItem) : sprintf('%s(%s)', gettype($organisationseinheitErweitertZustaendigkeitItem), var_export($organisationseinheitErweitertZustaendigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zustaendigkeit property can only contain items of type \StructType\ZustaendigkeitOrganisationseinheit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zustaendigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\ZustaendigkeitOrganisationseinheit[] $zustaendigkeit
     * @return \StructType\OrganisationseinheitErweitert
     */
    public function setZustaendigkeit(array $zustaendigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($zustaendigkeitArrayErrorMessage = self::validateZustaendigkeitForArrayConstraintsFromSetZustaendigkeit($zustaendigkeit))) {
            throw new \InvalidArgumentException($zustaendigkeitArrayErrorMessage, __LINE__);
        }
        $this->zustaendigkeit = $zustaendigkeit;
        return $this;
    }
    /**
     * Add item to zustaendigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\ZustaendigkeitOrganisationseinheit $item
     * @return \StructType\OrganisationseinheitErweitert
     */
    public function addToZustaendigkeit(\StructType\ZustaendigkeitOrganisationseinheit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ZustaendigkeitOrganisationseinheit) {
            throw new \InvalidArgumentException(sprintf('The zustaendigkeit property can only contain items of type \StructType\ZustaendigkeitOrganisationseinheit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zustaendigkeit[] = $item;
        return $this;
    }
    /**
     * Get formular value
     * @return \StructType\Formular[]|null
     */
    public function getFormular()
    {
        return $this->formular;
    }
    /**
     * This method is responsible for validating the values passed to the setFormular method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFormular method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFormularForArrayConstraintsFromSetFormular(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitErweitertFormularItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitErweitertFormularItem instanceof \StructType\Formular) {
                $invalidValues[] = is_object($organisationseinheitErweitertFormularItem) ? get_class($organisationseinheitErweitertFormularItem) : sprintf('%s(%s)', gettype($organisationseinheitErweitertFormularItem), var_export($organisationseinheitErweitertFormularItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The formular property can only contain items of type \StructType\Formular, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set formular value
     * @throws \InvalidArgumentException
     * @param \StructType\Formular[] $formular
     * @return \StructType\OrganisationseinheitErweitert
     */
    public function setFormular(array $formular = array())
    {
        // validation for constraint: array
        if ('' !== ($formularArrayErrorMessage = self::validateFormularForArrayConstraintsFromSetFormular($formular))) {
            throw new \InvalidArgumentException($formularArrayErrorMessage, __LINE__);
        }
        $this->formular = $formular;
        return $this;
    }
    /**
     * Add item to formular value
     * @throws \InvalidArgumentException
     * @param \StructType\Formular $item
     * @return \StructType\OrganisationseinheitErweitert
     */
    public function addToFormular(\StructType\Formular $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Formular) {
            throw new \InvalidArgumentException(sprintf('The formular property can only contain items of type \StructType\Formular, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->formular[] = $item;
        return $this;
    }
    /**
     * Get kontaktperson value
     * @return \StructType\Kontaktperson[]|null
     */
    public function getKontaktperson()
    {
        return $this->kontaktperson;
    }
    /**
     * This method is responsible for validating the values passed to the setKontaktperson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKontaktperson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKontaktpersonForArrayConstraintsFromSetKontaktperson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitErweitertKontaktpersonItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitErweitertKontaktpersonItem instanceof \StructType\Kontaktperson) {
                $invalidValues[] = is_object($organisationseinheitErweitertKontaktpersonItem) ? get_class($organisationseinheitErweitertKontaktpersonItem) : sprintf('%s(%s)', gettype($organisationseinheitErweitertKontaktpersonItem), var_export($organisationseinheitErweitertKontaktpersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kontaktperson property can only contain items of type \StructType\Kontaktperson, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kontaktperson value
     * @throws \InvalidArgumentException
     * @param \StructType\Kontaktperson[] $kontaktperson
     * @return \StructType\OrganisationseinheitErweitert
     */
    public function setKontaktperson(array $kontaktperson = array())
    {
        // validation for constraint: array
        if ('' !== ($kontaktpersonArrayErrorMessage = self::validateKontaktpersonForArrayConstraintsFromSetKontaktperson($kontaktperson))) {
            throw new \InvalidArgumentException($kontaktpersonArrayErrorMessage, __LINE__);
        }
        $this->kontaktperson = $kontaktperson;
        return $this;
    }
    /**
     * Add item to kontaktperson value
     * @throws \InvalidArgumentException
     * @param \StructType\Kontaktperson $item
     * @return \StructType\OrganisationseinheitErweitert
     */
    public function addToKontaktperson(\StructType\Kontaktperson $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Kontaktperson) {
            throw new \InvalidArgumentException(sprintf('The kontaktperson property can only contain items of type \StructType\Kontaktperson, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kontaktperson[] = $item;
        return $this;
    }
}
