<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Organisationseinheit StructType
 * Meta information extracted from the WSDL
 * - documentation: Eine Organisationseinheit bezeichnet Ämter, Institutionen oder Vereine mit Angabe der jeweiligen Kommunikationskanäle, der Anschrift, den Öffnungszeiten und weiteren Informationen.Kann - z.B. im Rahmen einer
 * Zuständigkeitsermittlung - nur eine externe Ressource zur OE-Ermittlung übertragen werden, muss das Kennzeichen "externeOrganisationsermittlung" gesetzt sein.
 * @subpackage Structs
 */
class Organisationseinheit extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Primäre ID.
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The idSekundaer
     * Meta information extracted from the WSDL
     * - documentation: Sekundäre IDs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $idSekundaer;
    /**
     * The externeOrganisationseinheitsermittlung
     * Meta information extracted from the WSDL
     * - documentation: Kann anstatt der realen Organisationseinheit nur ein Verweis (Link) auf eine externe OE-Ermittlung gegeben werden, muss dieses Kennzeichen gesetzt sein (true). In diesem Falle muss auch der Name der OE sowie internetadresse mit den
     * Links zur externen Ermittlung übertragen werden. Default ist "false" für dieses Kennzeichen. D.h. die reale OE wird übermittelt.
     * - default: false
     * @var bool
     */
    public $externeOrganisationseinheitsermittlung;
    /**
     * The uebergeordneteOrganisationseinheitID
     * Meta information extracted from the WSDL
     * - documentation: ID der direkt übergeordneten Organisationseinheit. Über über- und untergeordnete Organisationseinheiten kann die primäre Hierarchie der Organisation aufgespannt werden. Weitere alternative Hierarchien/Netze können über
     * alternativeHierarchie abgebildet werden.
     * - minOccurs: 0
     * @var \StructType\Identifikator
     */
    public $uebergeordneteOrganisationseinheitID;
    /**
     * The untergeordneteOrganisationseinheitID
     * Meta information extracted from the WSDL
     * - documentation: IDs der direkt untergeordneten Organisationseinheiten. Über über- und untergeordnete Organisationseinheiten kann die primäre Hierarchie der Organisation aufgespannt werden. Weitere alternative Hierarchien/Netze können über
     * alternativeHierarchie abgebildet werden. Die Angabe der untergeordneten IDs ist im Sinne des Datenmodell redundant, sollen aber zum effizienteren Abruf der Hierarchie mit angegeben werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $untergeordneteOrganisationseinheitID;
    /**
     * The alternativeHierarchie
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete Organisationseinheiten sind alle Organisationseinheiten die mit der Quellorganisationseinheit in Beziehung stehen. Die zugeordneten Organisationseinheiten werden über deren ID und die Art der Beziehung repräsentiert.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AlternativeOrganisationshierarchie[]
     */
    public $alternativeHierarchie;
    /**
     * The kategorie
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete Kategorie(n), wie zum Beispiel Behördentypen. Das Ordnungssystem kann - muss aber nicht - über die Nachricht zustaendigkeiten.anfrage.organisationseinheitskategorie übermittelt werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Organisationseinheitskategorie[]
     */
    public $kategorie;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Name bzw. Bezeichnung der Organisationseinheit.
     * - maxOccurs: unbounded
     * @var \StructType\NameOrganisation[]
     */
    public $name;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Allgemeine Beschreibung der OE. Soll nicht für Leistungsbeschreibungen, Zuständigkeiten verwendet werden.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibung;
    /**
     * The kurzbeschreibung
     * Meta information extracted from the WSDL
     * - documentation: Kurze Beschreibung der OE.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $kurzbeschreibung;
    /**
     * The infoOeffnungszeitenText
     * Meta information extracted from the WSDL
     * - documentation: Angaben zu Öffnungszeiten in textueller Form. Eine strukturierte Angabe von Öffnungs- und Servicezeiten ist über infoOeffnungszeitenStrukturiert möglich.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $infoOeffnungszeitenText;
    /**
     * The infoOeffnungszeitenStrukturiert
     * Meta information extracted from the WSDL
     * - documentation: Öffnungszeiten werden über Zeitserien abgebildet. Es können mehrere Zeiten für verschiedene Gültigkeitsräume oder Ausprägungen (Besuchszeit, Anmeldezeit) angegeben werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitserien[]
     */
    public $infoOeffnungszeitenStrukturiert;
    /**
     * The infoInternServicecenter
     * Meta information extracted from the WSDL
     * - documentation: Interne Informationen für die Zielgruppe Servicecenter-Mitarbeiter.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $infoInternServicecenter;
    /**
     * The infoSonstige
     * Meta information extracted from the WSDL
     * - documentation: Sonstige Angaben, z.B. für aktuelle Angaben. "Haupteingang derzeit verlegt wegen Bauarbeiten." o.ä.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $infoSonstige;
    /**
     * The anschrift
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete Anschriften, wie z.B. Besuchsanschrift oder Postanschrift. Hat eine Organisationseinheit mehrere Standorte, sollte dies mit weiteren untergeordneten Organisationseinheiten abgebildet werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AnschriftOrganisationseinheit[]
     */
    public $anschrift;
    /**
     * The erreichbarkeit
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete Erreichbarkeitskanäle für Personen, wie z.B. Telefon oder E-Mail.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Erreichbarkeit[]
     */
    public $erreichbarkeit;
    /**
     * The kommunikationssystem
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete Kommunikationskanäle im Kontext "Maschine-zu-Maschine-Kommunikation". Hinter dem Kanal verbirgt sich in der Regel ein System, welches Nachrichten automatisch verarbeitet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Kommunikationssystem[]
     */
    public $kommunikationssystem;
    /**
     * The internetadresse
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete Internetadressen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HyperlinkErweitert[]
     */
    public $internetadresse;
    /**
     * The bankverbindung
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete Bankverbindungen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Bankverbindung[]
     */
    public $bankverbindung;
    /**
     * The glaeubigeridentifikationsnummer
     * Meta information extracted from the WSDL
     * - documentation: Das neue SEPA-Lastschriftverfahren sieht im SEPA-Lastschriftmandat ein verpflichtendes Merkmal zur kontounabhängigen und eindeutigen Kennzeichnung des Lastschriftgläubigers (Creditor Identifier/CI, Gläubiger-Identifikationsnummer
     * oder Gläubiger-ID) vor.
     * - minOccurs: 0
     * @var string
     */
    public $glaeubigeridentifikationsnummer;
    /**
     * The zahlungsweisen
     * Meta information extracted from the WSDL
     * - documentation: Angabe unterstützter Zahlungsweisen in dieser OE
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Code_Zahlungsweise[]
     */
    public $zahlungsweisen;
    /**
     * The zahlungsweisenText
     * Meta information extracted from the WSDL
     * - documentation: Angaben zu erlaubten Zahlungsweisen als Freitext. Es ist die Angabe der Codes zu bevorzugen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $zahlungsweisenText;
    /**
     * The synonym
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete Synonyme, z.B. "Rathaus", "Ordnungsamt"
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $synonym;
    /**
     * The herausgeber
     * Meta information extracted from the WSDL
     * - documentation: Optionale Angabe des Herausgebers der Daten.
     * - minOccurs: 0
     * @var \StructType\Herausgeber
     */
    public $herausgeber;
    /**
     * The versionsinformation
     * Meta information extracted from the WSDL
     * - documentation: Informationen zur Versionierung.
     * - minOccurs: 0
     * @var \StructType\Versionsinformation
     */
    public $versionsinformation;
    /**
     * The sprachversion
     * Meta information extracted from the WSDL
     * - documentation: Angabe aller verfügbaren Sprachversionen des Objekts.
     * - maxOccurs: unbounded
     * @var \StructType\Sprachversion[]
     */
    public $sprachversion;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen das Objekt gültig ist. Zeiträume können nacheinander liegen oder sich überschneiden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * Constructor method for Organisationseinheit
     * @uses Organisationseinheit::setId()
     * @uses Organisationseinheit::setIdSekundaer()
     * @uses Organisationseinheit::setExterneOrganisationseinheitsermittlung()
     * @uses Organisationseinheit::setUebergeordneteOrganisationseinheitID()
     * @uses Organisationseinheit::setUntergeordneteOrganisationseinheitID()
     * @uses Organisationseinheit::setAlternativeHierarchie()
     * @uses Organisationseinheit::setKategorie()
     * @uses Organisationseinheit::setName()
     * @uses Organisationseinheit::setBeschreibung()
     * @uses Organisationseinheit::setKurzbeschreibung()
     * @uses Organisationseinheit::setInfoOeffnungszeitenText()
     * @uses Organisationseinheit::setInfoOeffnungszeitenStrukturiert()
     * @uses Organisationseinheit::setInfoInternServicecenter()
     * @uses Organisationseinheit::setInfoSonstige()
     * @uses Organisationseinheit::setAnschrift()
     * @uses Organisationseinheit::setErreichbarkeit()
     * @uses Organisationseinheit::setKommunikationssystem()
     * @uses Organisationseinheit::setInternetadresse()
     * @uses Organisationseinheit::setBankverbindung()
     * @uses Organisationseinheit::setGlaeubigeridentifikationsnummer()
     * @uses Organisationseinheit::setZahlungsweisen()
     * @uses Organisationseinheit::setZahlungsweisenText()
     * @uses Organisationseinheit::setSynonym()
     * @uses Organisationseinheit::setHerausgeber()
     * @uses Organisationseinheit::setVersionsinformation()
     * @uses Organisationseinheit::setSprachversion()
     * @uses Organisationseinheit::setGueltigkeit()
     * @param \StructType\Identifikator $id
     * @param \StructType\Identifikator[] $idSekundaer
     * @param bool $externeOrganisationseinheitsermittlung
     * @param \StructType\Identifikator $uebergeordneteOrganisationseinheitID
     * @param \StructType\Identifikator[] $untergeordneteOrganisationseinheitID
     * @param \StructType\AlternativeOrganisationshierarchie[] $alternativeHierarchie
     * @param \StructType\Organisationseinheitskategorie[] $kategorie
     * @param \StructType\NameOrganisation[] $name
     * @param \StructType\String_Localized[] $beschreibung
     * @param \StructType\String_Localized[] $kurzbeschreibung
     * @param \StructType\String_Localized[] $infoOeffnungszeitenText
     * @param \StructType\Zeitserien[] $infoOeffnungszeitenStrukturiert
     * @param \StructType\String_Localized[] $infoInternServicecenter
     * @param \StructType\String_Localized[] $infoSonstige
     * @param \StructType\AnschriftOrganisationseinheit[] $anschrift
     * @param \StructType\Erreichbarkeit[] $erreichbarkeit
     * @param \StructType\Kommunikationssystem[] $kommunikationssystem
     * @param \StructType\HyperlinkErweitert[] $internetadresse
     * @param \StructType\Bankverbindung[] $bankverbindung
     * @param string $glaeubigeridentifikationsnummer
     * @param \StructType\Code_Zahlungsweise[] $zahlungsweisen
     * @param \StructType\String_Localized[] $zahlungsweisenText
     * @param \StructType\String_Localized[] $synonym
     * @param \StructType\Herausgeber $herausgeber
     * @param \StructType\Versionsinformation $versionsinformation
     * @param \StructType\Sprachversion[] $sprachversion
     * @param \StructType\Zeitraum[] $gueltigkeit
     */
    public function __construct(\StructType\Identifikator $id = null, array $idSekundaer = array(), $externeOrganisationseinheitsermittlung = false, \StructType\Identifikator $uebergeordneteOrganisationseinheitID = null, array $untergeordneteOrganisationseinheitID = array(), array $alternativeHierarchie = array(), array $kategorie = array(), array $name = array(), array $beschreibung = array(), array $kurzbeschreibung = array(), array $infoOeffnungszeitenText = array(), array $infoOeffnungszeitenStrukturiert = array(), array $infoInternServicecenter = array(), array $infoSonstige = array(), array $anschrift = array(), array $erreichbarkeit = array(), array $kommunikationssystem = array(), array $internetadresse = array(), array $bankverbindung = array(), $glaeubigeridentifikationsnummer = null, array $zahlungsweisen = array(), array $zahlungsweisenText = array(), array $synonym = array(), \StructType\Herausgeber $herausgeber = null, \StructType\Versionsinformation $versionsinformation = null, array $sprachversion = array(), array $gueltigkeit = array())
    {
        $this
            ->setId($id)
            ->setIdSekundaer($idSekundaer)
            ->setExterneOrganisationseinheitsermittlung($externeOrganisationseinheitsermittlung)
            ->setUebergeordneteOrganisationseinheitID($uebergeordneteOrganisationseinheitID)
            ->setUntergeordneteOrganisationseinheitID($untergeordneteOrganisationseinheitID)
            ->setAlternativeHierarchie($alternativeHierarchie)
            ->setKategorie($kategorie)
            ->setName($name)
            ->setBeschreibung($beschreibung)
            ->setKurzbeschreibung($kurzbeschreibung)
            ->setInfoOeffnungszeitenText($infoOeffnungszeitenText)
            ->setInfoOeffnungszeitenStrukturiert($infoOeffnungszeitenStrukturiert)
            ->setInfoInternServicecenter($infoInternServicecenter)
            ->setInfoSonstige($infoSonstige)
            ->setAnschrift($anschrift)
            ->setErreichbarkeit($erreichbarkeit)
            ->setKommunikationssystem($kommunikationssystem)
            ->setInternetadresse($internetadresse)
            ->setBankverbindung($bankverbindung)
            ->setGlaeubigeridentifikationsnummer($glaeubigeridentifikationsnummer)
            ->setZahlungsweisen($zahlungsweisen)
            ->setZahlungsweisenText($zahlungsweisenText)
            ->setSynonym($synonym)
            ->setHerausgeber($herausgeber)
            ->setVersionsinformation($versionsinformation)
            ->setSprachversion($sprachversion)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\Organisationseinheit
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get idSekundaer value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdSekundaer()
    {
        return $this->idSekundaer;
    }
    /**
     * This method is responsible for validating the values passed to the setIdSekundaer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdSekundaer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdSekundaerForArrayConstraintsFromSetIdSekundaer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitIdSekundaerItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitIdSekundaerItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($organisationseinheitIdSekundaerItem) ? get_class($organisationseinheitIdSekundaerItem) : sprintf('%s(%s)', gettype($organisationseinheitIdSekundaerItem), var_export($organisationseinheitIdSekundaerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idSekundaer
     * @return \StructType\Organisationseinheit
     */
    public function setIdSekundaer(array $idSekundaer = array())
    {
        // validation for constraint: array
        if ('' !== ($idSekundaerArrayErrorMessage = self::validateIdSekundaerForArrayConstraintsFromSetIdSekundaer($idSekundaer))) {
            throw new \InvalidArgumentException($idSekundaerArrayErrorMessage, __LINE__);
        }
        $this->idSekundaer = $idSekundaer;
        return $this;
    }
    /**
     * Add item to idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Organisationseinheit
     */
    public function addToIdSekundaer(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idSekundaer[] = $item;
        return $this;
    }
    /**
     * Get externeOrganisationseinheitsermittlung value
     * @return bool|null
     */
    public function getExterneOrganisationseinheitsermittlung()
    {
        return $this->externeOrganisationseinheitsermittlung;
    }
    /**
     * Set externeOrganisationseinheitsermittlung value
     * @param bool $externeOrganisationseinheitsermittlung
     * @return \StructType\Organisationseinheit
     */
    public function setExterneOrganisationseinheitsermittlung($externeOrganisationseinheitsermittlung = false)
    {
        // validation for constraint: boolean
        if (!is_null($externeOrganisationseinheitsermittlung) && !is_bool($externeOrganisationseinheitsermittlung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($externeOrganisationseinheitsermittlung, true), gettype($externeOrganisationseinheitsermittlung)), __LINE__);
        }
        $this->externeOrganisationseinheitsermittlung = $externeOrganisationseinheitsermittlung;
        return $this;
    }
    /**
     * Get uebergeordneteOrganisationseinheitID value
     * @return \StructType\Identifikator|null
     */
    public function getUebergeordneteOrganisationseinheitID()
    {
        return $this->uebergeordneteOrganisationseinheitID;
    }
    /**
     * Set uebergeordneteOrganisationseinheitID value
     * @param \StructType\Identifikator $uebergeordneteOrganisationseinheitID
     * @return \StructType\Organisationseinheit
     */
    public function setUebergeordneteOrganisationseinheitID(\StructType\Identifikator $uebergeordneteOrganisationseinheitID = null)
    {
        $this->uebergeordneteOrganisationseinheitID = $uebergeordneteOrganisationseinheitID;
        return $this;
    }
    /**
     * Get untergeordneteOrganisationseinheitID value
     * @return \StructType\Identifikator[]|null
     */
    public function getUntergeordneteOrganisationseinheitID()
    {
        return $this->untergeordneteOrganisationseinheitID;
    }
    /**
     * This method is responsible for validating the values passed to the setUntergeordneteOrganisationseinheitID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setUntergeordneteOrganisationseinheitID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateUntergeordneteOrganisationseinheitIDForArrayConstraintsFromSetUntergeordneteOrganisationseinheitID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitUntergeordneteOrganisationseinheitIDItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitUntergeordneteOrganisationseinheitIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($organisationseinheitUntergeordneteOrganisationseinheitIDItem) ? get_class($organisationseinheitUntergeordneteOrganisationseinheitIDItem) : sprintf('%s(%s)', gettype($organisationseinheitUntergeordneteOrganisationseinheitIDItem), var_export($organisationseinheitUntergeordneteOrganisationseinheitIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The untergeordneteOrganisationseinheitID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set untergeordneteOrganisationseinheitID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $untergeordneteOrganisationseinheitID
     * @return \StructType\Organisationseinheit
     */
    public function setUntergeordneteOrganisationseinheitID(array $untergeordneteOrganisationseinheitID = array())
    {
        // validation for constraint: array
        if ('' !== ($untergeordneteOrganisationseinheitIDArrayErrorMessage = self::validateUntergeordneteOrganisationseinheitIDForArrayConstraintsFromSetUntergeordneteOrganisationseinheitID($untergeordneteOrganisationseinheitID))) {
            throw new \InvalidArgumentException($untergeordneteOrganisationseinheitIDArrayErrorMessage, __LINE__);
        }
        $this->untergeordneteOrganisationseinheitID = $untergeordneteOrganisationseinheitID;
        return $this;
    }
    /**
     * Add item to untergeordneteOrganisationseinheitID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Organisationseinheit
     */
    public function addToUntergeordneteOrganisationseinheitID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The untergeordneteOrganisationseinheitID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->untergeordneteOrganisationseinheitID[] = $item;
        return $this;
    }
    /**
     * Get alternativeHierarchie value
     * @return \StructType\AlternativeOrganisationshierarchie[]|null
     */
    public function getAlternativeHierarchie()
    {
        return $this->alternativeHierarchie;
    }
    /**
     * This method is responsible for validating the values passed to the setAlternativeHierarchie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAlternativeHierarchie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAlternativeHierarchieForArrayConstraintsFromSetAlternativeHierarchie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitAlternativeHierarchieItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitAlternativeHierarchieItem instanceof \StructType\AlternativeOrganisationshierarchie) {
                $invalidValues[] = is_object($organisationseinheitAlternativeHierarchieItem) ? get_class($organisationseinheitAlternativeHierarchieItem) : sprintf('%s(%s)', gettype($organisationseinheitAlternativeHierarchieItem), var_export($organisationseinheitAlternativeHierarchieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The alternativeHierarchie property can only contain items of type \StructType\AlternativeOrganisationshierarchie, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set alternativeHierarchie value
     * @throws \InvalidArgumentException
     * @param \StructType\AlternativeOrganisationshierarchie[] $alternativeHierarchie
     * @return \StructType\Organisationseinheit
     */
    public function setAlternativeHierarchie(array $alternativeHierarchie = array())
    {
        // validation for constraint: array
        if ('' !== ($alternativeHierarchieArrayErrorMessage = self::validateAlternativeHierarchieForArrayConstraintsFromSetAlternativeHierarchie($alternativeHierarchie))) {
            throw new \InvalidArgumentException($alternativeHierarchieArrayErrorMessage, __LINE__);
        }
        $this->alternativeHierarchie = $alternativeHierarchie;
        return $this;
    }
    /**
     * Add item to alternativeHierarchie value
     * @throws \InvalidArgumentException
     * @param \StructType\AlternativeOrganisationshierarchie $item
     * @return \StructType\Organisationseinheit
     */
    public function addToAlternativeHierarchie(\StructType\AlternativeOrganisationshierarchie $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AlternativeOrganisationshierarchie) {
            throw new \InvalidArgumentException(sprintf('The alternativeHierarchie property can only contain items of type \StructType\AlternativeOrganisationshierarchie, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->alternativeHierarchie[] = $item;
        return $this;
    }
    /**
     * Get kategorie value
     * @return \StructType\Organisationseinheitskategorie[]|null
     */
    public function getKategorie()
    {
        return $this->kategorie;
    }
    /**
     * This method is responsible for validating the values passed to the setKategorie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKategorie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKategorieForArrayConstraintsFromSetKategorie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitKategorieItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitKategorieItem instanceof \StructType\Organisationseinheitskategorie) {
                $invalidValues[] = is_object($organisationseinheitKategorieItem) ? get_class($organisationseinheitKategorieItem) : sprintf('%s(%s)', gettype($organisationseinheitKategorieItem), var_export($organisationseinheitKategorieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kategorie property can only contain items of type \StructType\Organisationseinheitskategorie, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kategorie value
     * @throws \InvalidArgumentException
     * @param \StructType\Organisationseinheitskategorie[] $kategorie
     * @return \StructType\Organisationseinheit
     */
    public function setKategorie(array $kategorie = array())
    {
        // validation for constraint: array
        if ('' !== ($kategorieArrayErrorMessage = self::validateKategorieForArrayConstraintsFromSetKategorie($kategorie))) {
            throw new \InvalidArgumentException($kategorieArrayErrorMessage, __LINE__);
        }
        $this->kategorie = $kategorie;
        return $this;
    }
    /**
     * Add item to kategorie value
     * @throws \InvalidArgumentException
     * @param \StructType\Organisationseinheitskategorie $item
     * @return \StructType\Organisationseinheit
     */
    public function addToKategorie(\StructType\Organisationseinheitskategorie $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Organisationseinheitskategorie) {
            throw new \InvalidArgumentException(sprintf('The kategorie property can only contain items of type \StructType\Organisationseinheitskategorie, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kategorie[] = $item;
        return $this;
    }
    /**
     * Get name value
     * @return \StructType\NameOrganisation[]|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * This method is responsible for validating the values passed to the setName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNameForArrayConstraintsFromSetName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitNameItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitNameItem instanceof \StructType\NameOrganisation) {
                $invalidValues[] = is_object($organisationseinheitNameItem) ? get_class($organisationseinheitNameItem) : sprintf('%s(%s)', gettype($organisationseinheitNameItem), var_export($organisationseinheitNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The name property can only contain items of type \StructType\NameOrganisation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set name value
     * @throws \InvalidArgumentException
     * @param \StructType\NameOrganisation[] $name
     * @return \StructType\Organisationseinheit
     */
    public function setName(array $name = array())
    {
        // validation for constraint: array
        if ('' !== ($nameArrayErrorMessage = self::validateNameForArrayConstraintsFromSetName($name))) {
            throw new \InvalidArgumentException($nameArrayErrorMessage, __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Add item to name value
     * @throws \InvalidArgumentException
     * @param \StructType\NameOrganisation $item
     * @return \StructType\Organisationseinheit
     */
    public function addToName(\StructType\NameOrganisation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NameOrganisation) {
            throw new \InvalidArgumentException(sprintf('The name property can only contain items of type \StructType\NameOrganisation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->name[] = $item;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitBeschreibungItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitBeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($organisationseinheitBeschreibungItem) ? get_class($organisationseinheitBeschreibungItem) : sprintf('%s(%s)', gettype($organisationseinheitBeschreibungItem), var_export($organisationseinheitBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibung
     * @return \StructType\Organisationseinheit
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Organisationseinheit
     */
    public function addToBeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
    /**
     * Get kurzbeschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getKurzbeschreibung()
    {
        return $this->kurzbeschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setKurzbeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKurzbeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKurzbeschreibungForArrayConstraintsFromSetKurzbeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitKurzbeschreibungItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitKurzbeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($organisationseinheitKurzbeschreibungItem) ? get_class($organisationseinheitKurzbeschreibungItem) : sprintf('%s(%s)', gettype($organisationseinheitKurzbeschreibungItem), var_export($organisationseinheitKurzbeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kurzbeschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kurzbeschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $kurzbeschreibung
     * @return \StructType\Organisationseinheit
     */
    public function setKurzbeschreibung(array $kurzbeschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($kurzbeschreibungArrayErrorMessage = self::validateKurzbeschreibungForArrayConstraintsFromSetKurzbeschreibung($kurzbeschreibung))) {
            throw new \InvalidArgumentException($kurzbeschreibungArrayErrorMessage, __LINE__);
        }
        $this->kurzbeschreibung = $kurzbeschreibung;
        return $this;
    }
    /**
     * Add item to kurzbeschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Organisationseinheit
     */
    public function addToKurzbeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The kurzbeschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kurzbeschreibung[] = $item;
        return $this;
    }
    /**
     * Get infoOeffnungszeitenText value
     * @return \StructType\String_Localized[]|null
     */
    public function getInfoOeffnungszeitenText()
    {
        return $this->infoOeffnungszeitenText;
    }
    /**
     * This method is responsible for validating the values passed to the setInfoOeffnungszeitenText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInfoOeffnungszeitenText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInfoOeffnungszeitenTextForArrayConstraintsFromSetInfoOeffnungszeitenText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitInfoOeffnungszeitenTextItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitInfoOeffnungszeitenTextItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($organisationseinheitInfoOeffnungszeitenTextItem) ? get_class($organisationseinheitInfoOeffnungszeitenTextItem) : sprintf('%s(%s)', gettype($organisationseinheitInfoOeffnungszeitenTextItem), var_export($organisationseinheitInfoOeffnungszeitenTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The infoOeffnungszeitenText property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set infoOeffnungszeitenText value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $infoOeffnungszeitenText
     * @return \StructType\Organisationseinheit
     */
    public function setInfoOeffnungszeitenText(array $infoOeffnungszeitenText = array())
    {
        // validation for constraint: array
        if ('' !== ($infoOeffnungszeitenTextArrayErrorMessage = self::validateInfoOeffnungszeitenTextForArrayConstraintsFromSetInfoOeffnungszeitenText($infoOeffnungszeitenText))) {
            throw new \InvalidArgumentException($infoOeffnungszeitenTextArrayErrorMessage, __LINE__);
        }
        $this->infoOeffnungszeitenText = $infoOeffnungszeitenText;
        return $this;
    }
    /**
     * Add item to infoOeffnungszeitenText value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Organisationseinheit
     */
    public function addToInfoOeffnungszeitenText(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The infoOeffnungszeitenText property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->infoOeffnungszeitenText[] = $item;
        return $this;
    }
    /**
     * Get infoOeffnungszeitenStrukturiert value
     * @return \StructType\Zeitserien[]|null
     */
    public function getInfoOeffnungszeitenStrukturiert()
    {
        return $this->infoOeffnungszeitenStrukturiert;
    }
    /**
     * This method is responsible for validating the values passed to the setInfoOeffnungszeitenStrukturiert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInfoOeffnungszeitenStrukturiert method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInfoOeffnungszeitenStrukturiertForArrayConstraintsFromSetInfoOeffnungszeitenStrukturiert(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitInfoOeffnungszeitenStrukturiertItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitInfoOeffnungszeitenStrukturiertItem instanceof \StructType\Zeitserien) {
                $invalidValues[] = is_object($organisationseinheitInfoOeffnungszeitenStrukturiertItem) ? get_class($organisationseinheitInfoOeffnungszeitenStrukturiertItem) : sprintf('%s(%s)', gettype($organisationseinheitInfoOeffnungszeitenStrukturiertItem), var_export($organisationseinheitInfoOeffnungszeitenStrukturiertItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The infoOeffnungszeitenStrukturiert property can only contain items of type \StructType\Zeitserien, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set infoOeffnungszeitenStrukturiert value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitserien[] $infoOeffnungszeitenStrukturiert
     * @return \StructType\Organisationseinheit
     */
    public function setInfoOeffnungszeitenStrukturiert(array $infoOeffnungszeitenStrukturiert = array())
    {
        // validation for constraint: array
        if ('' !== ($infoOeffnungszeitenStrukturiertArrayErrorMessage = self::validateInfoOeffnungszeitenStrukturiertForArrayConstraintsFromSetInfoOeffnungszeitenStrukturiert($infoOeffnungszeitenStrukturiert))) {
            throw new \InvalidArgumentException($infoOeffnungszeitenStrukturiertArrayErrorMessage, __LINE__);
        }
        $this->infoOeffnungszeitenStrukturiert = $infoOeffnungszeitenStrukturiert;
        return $this;
    }
    /**
     * Add item to infoOeffnungszeitenStrukturiert value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitserien $item
     * @return \StructType\Organisationseinheit
     */
    public function addToInfoOeffnungszeitenStrukturiert(\StructType\Zeitserien $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitserien) {
            throw new \InvalidArgumentException(sprintf('The infoOeffnungszeitenStrukturiert property can only contain items of type \StructType\Zeitserien, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->infoOeffnungszeitenStrukturiert[] = $item;
        return $this;
    }
    /**
     * Get infoInternServicecenter value
     * @return \StructType\String_Localized[]|null
     */
    public function getInfoInternServicecenter()
    {
        return $this->infoInternServicecenter;
    }
    /**
     * This method is responsible for validating the values passed to the setInfoInternServicecenter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInfoInternServicecenter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInfoInternServicecenterForArrayConstraintsFromSetInfoInternServicecenter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitInfoInternServicecenterItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitInfoInternServicecenterItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($organisationseinheitInfoInternServicecenterItem) ? get_class($organisationseinheitInfoInternServicecenterItem) : sprintf('%s(%s)', gettype($organisationseinheitInfoInternServicecenterItem), var_export($organisationseinheitInfoInternServicecenterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The infoInternServicecenter property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set infoInternServicecenter value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $infoInternServicecenter
     * @return \StructType\Organisationseinheit
     */
    public function setInfoInternServicecenter(array $infoInternServicecenter = array())
    {
        // validation for constraint: array
        if ('' !== ($infoInternServicecenterArrayErrorMessage = self::validateInfoInternServicecenterForArrayConstraintsFromSetInfoInternServicecenter($infoInternServicecenter))) {
            throw new \InvalidArgumentException($infoInternServicecenterArrayErrorMessage, __LINE__);
        }
        $this->infoInternServicecenter = $infoInternServicecenter;
        return $this;
    }
    /**
     * Add item to infoInternServicecenter value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Organisationseinheit
     */
    public function addToInfoInternServicecenter(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The infoInternServicecenter property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->infoInternServicecenter[] = $item;
        return $this;
    }
    /**
     * Get infoSonstige value
     * @return \StructType\String_Localized[]|null
     */
    public function getInfoSonstige()
    {
        return $this->infoSonstige;
    }
    /**
     * This method is responsible for validating the values passed to the setInfoSonstige method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInfoSonstige method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInfoSonstigeForArrayConstraintsFromSetInfoSonstige(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitInfoSonstigeItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitInfoSonstigeItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($organisationseinheitInfoSonstigeItem) ? get_class($organisationseinheitInfoSonstigeItem) : sprintf('%s(%s)', gettype($organisationseinheitInfoSonstigeItem), var_export($organisationseinheitInfoSonstigeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The infoSonstige property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set infoSonstige value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $infoSonstige
     * @return \StructType\Organisationseinheit
     */
    public function setInfoSonstige(array $infoSonstige = array())
    {
        // validation for constraint: array
        if ('' !== ($infoSonstigeArrayErrorMessage = self::validateInfoSonstigeForArrayConstraintsFromSetInfoSonstige($infoSonstige))) {
            throw new \InvalidArgumentException($infoSonstigeArrayErrorMessage, __LINE__);
        }
        $this->infoSonstige = $infoSonstige;
        return $this;
    }
    /**
     * Add item to infoSonstige value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Organisationseinheit
     */
    public function addToInfoSonstige(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The infoSonstige property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->infoSonstige[] = $item;
        return $this;
    }
    /**
     * Get anschrift value
     * @return \StructType\AnschriftOrganisationseinheit[]|null
     */
    public function getAnschrift()
    {
        return $this->anschrift;
    }
    /**
     * This method is responsible for validating the values passed to the setAnschrift method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnschrift method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnschriftForArrayConstraintsFromSetAnschrift(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitAnschriftItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitAnschriftItem instanceof \StructType\AnschriftOrganisationseinheit) {
                $invalidValues[] = is_object($organisationseinheitAnschriftItem) ? get_class($organisationseinheitAnschriftItem) : sprintf('%s(%s)', gettype($organisationseinheitAnschriftItem), var_export($organisationseinheitAnschriftItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The anschrift property can only contain items of type \StructType\AnschriftOrganisationseinheit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set anschrift value
     * @throws \InvalidArgumentException
     * @param \StructType\AnschriftOrganisationseinheit[] $anschrift
     * @return \StructType\Organisationseinheit
     */
    public function setAnschrift(array $anschrift = array())
    {
        // validation for constraint: array
        if ('' !== ($anschriftArrayErrorMessage = self::validateAnschriftForArrayConstraintsFromSetAnschrift($anschrift))) {
            throw new \InvalidArgumentException($anschriftArrayErrorMessage, __LINE__);
        }
        $this->anschrift = $anschrift;
        return $this;
    }
    /**
     * Add item to anschrift value
     * @throws \InvalidArgumentException
     * @param \StructType\AnschriftOrganisationseinheit $item
     * @return \StructType\Organisationseinheit
     */
    public function addToAnschrift(\StructType\AnschriftOrganisationseinheit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnschriftOrganisationseinheit) {
            throw new \InvalidArgumentException(sprintf('The anschrift property can only contain items of type \StructType\AnschriftOrganisationseinheit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->anschrift[] = $item;
        return $this;
    }
    /**
     * Get erreichbarkeit value
     * @return \StructType\Erreichbarkeit[]|null
     */
    public function getErreichbarkeit()
    {
        return $this->erreichbarkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setErreichbarkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErreichbarkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErreichbarkeitForArrayConstraintsFromSetErreichbarkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitErreichbarkeitItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitErreichbarkeitItem instanceof \StructType\Erreichbarkeit) {
                $invalidValues[] = is_object($organisationseinheitErreichbarkeitItem) ? get_class($organisationseinheitErreichbarkeitItem) : sprintf('%s(%s)', gettype($organisationseinheitErreichbarkeitItem), var_export($organisationseinheitErreichbarkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The erreichbarkeit property can only contain items of type \StructType\Erreichbarkeit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set erreichbarkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Erreichbarkeit[] $erreichbarkeit
     * @return \StructType\Organisationseinheit
     */
    public function setErreichbarkeit(array $erreichbarkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($erreichbarkeitArrayErrorMessage = self::validateErreichbarkeitForArrayConstraintsFromSetErreichbarkeit($erreichbarkeit))) {
            throw new \InvalidArgumentException($erreichbarkeitArrayErrorMessage, __LINE__);
        }
        $this->erreichbarkeit = $erreichbarkeit;
        return $this;
    }
    /**
     * Add item to erreichbarkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Erreichbarkeit $item
     * @return \StructType\Organisationseinheit
     */
    public function addToErreichbarkeit(\StructType\Erreichbarkeit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Erreichbarkeit) {
            throw new \InvalidArgumentException(sprintf('The erreichbarkeit property can only contain items of type \StructType\Erreichbarkeit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->erreichbarkeit[] = $item;
        return $this;
    }
    /**
     * Get kommunikationssystem value
     * @return \StructType\Kommunikationssystem[]|null
     */
    public function getKommunikationssystem()
    {
        return $this->kommunikationssystem;
    }
    /**
     * This method is responsible for validating the values passed to the setKommunikationssystem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKommunikationssystem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKommunikationssystemForArrayConstraintsFromSetKommunikationssystem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitKommunikationssystemItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitKommunikationssystemItem instanceof \StructType\Kommunikationssystem) {
                $invalidValues[] = is_object($organisationseinheitKommunikationssystemItem) ? get_class($organisationseinheitKommunikationssystemItem) : sprintf('%s(%s)', gettype($organisationseinheitKommunikationssystemItem), var_export($organisationseinheitKommunikationssystemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kommunikationssystem property can only contain items of type \StructType\Kommunikationssystem, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kommunikationssystem value
     * @throws \InvalidArgumentException
     * @param \StructType\Kommunikationssystem[] $kommunikationssystem
     * @return \StructType\Organisationseinheit
     */
    public function setKommunikationssystem(array $kommunikationssystem = array())
    {
        // validation for constraint: array
        if ('' !== ($kommunikationssystemArrayErrorMessage = self::validateKommunikationssystemForArrayConstraintsFromSetKommunikationssystem($kommunikationssystem))) {
            throw new \InvalidArgumentException($kommunikationssystemArrayErrorMessage, __LINE__);
        }
        $this->kommunikationssystem = $kommunikationssystem;
        return $this;
    }
    /**
     * Add item to kommunikationssystem value
     * @throws \InvalidArgumentException
     * @param \StructType\Kommunikationssystem $item
     * @return \StructType\Organisationseinheit
     */
    public function addToKommunikationssystem(\StructType\Kommunikationssystem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Kommunikationssystem) {
            throw new \InvalidArgumentException(sprintf('The kommunikationssystem property can only contain items of type \StructType\Kommunikationssystem, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kommunikationssystem[] = $item;
        return $this;
    }
    /**
     * Get internetadresse value
     * @return \StructType\HyperlinkErweitert[]|null
     */
    public function getInternetadresse()
    {
        return $this->internetadresse;
    }
    /**
     * This method is responsible for validating the values passed to the setInternetadresse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternetadresse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternetadresseForArrayConstraintsFromSetInternetadresse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitInternetadresseItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitInternetadresseItem instanceof \StructType\HyperlinkErweitert) {
                $invalidValues[] = is_object($organisationseinheitInternetadresseItem) ? get_class($organisationseinheitInternetadresseItem) : sprintf('%s(%s)', gettype($organisationseinheitInternetadresseItem), var_export($organisationseinheitInternetadresseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internetadresse property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internetadresse value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert[] $internetadresse
     * @return \StructType\Organisationseinheit
     */
    public function setInternetadresse(array $internetadresse = array())
    {
        // validation for constraint: array
        if ('' !== ($internetadresseArrayErrorMessage = self::validateInternetadresseForArrayConstraintsFromSetInternetadresse($internetadresse))) {
            throw new \InvalidArgumentException($internetadresseArrayErrorMessage, __LINE__);
        }
        $this->internetadresse = $internetadresse;
        return $this;
    }
    /**
     * Add item to internetadresse value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert $item
     * @return \StructType\Organisationseinheit
     */
    public function addToInternetadresse(\StructType\HyperlinkErweitert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HyperlinkErweitert) {
            throw new \InvalidArgumentException(sprintf('The internetadresse property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internetadresse[] = $item;
        return $this;
    }
    /**
     * Get bankverbindung value
     * @return \StructType\Bankverbindung[]|null
     */
    public function getBankverbindung()
    {
        return $this->bankverbindung;
    }
    /**
     * This method is responsible for validating the values passed to the setBankverbindung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankverbindung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBankverbindungForArrayConstraintsFromSetBankverbindung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitBankverbindungItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitBankverbindungItem instanceof \StructType\Bankverbindung) {
                $invalidValues[] = is_object($organisationseinheitBankverbindungItem) ? get_class($organisationseinheitBankverbindungItem) : sprintf('%s(%s)', gettype($organisationseinheitBankverbindungItem), var_export($organisationseinheitBankverbindungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The bankverbindung property can only contain items of type \StructType\Bankverbindung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set bankverbindung value
     * @throws \InvalidArgumentException
     * @param \StructType\Bankverbindung[] $bankverbindung
     * @return \StructType\Organisationseinheit
     */
    public function setBankverbindung(array $bankverbindung = array())
    {
        // validation for constraint: array
        if ('' !== ($bankverbindungArrayErrorMessage = self::validateBankverbindungForArrayConstraintsFromSetBankverbindung($bankverbindung))) {
            throw new \InvalidArgumentException($bankverbindungArrayErrorMessage, __LINE__);
        }
        $this->bankverbindung = $bankverbindung;
        return $this;
    }
    /**
     * Add item to bankverbindung value
     * @throws \InvalidArgumentException
     * @param \StructType\Bankverbindung $item
     * @return \StructType\Organisationseinheit
     */
    public function addToBankverbindung(\StructType\Bankverbindung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Bankverbindung) {
            throw new \InvalidArgumentException(sprintf('The bankverbindung property can only contain items of type \StructType\Bankverbindung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->bankverbindung[] = $item;
        return $this;
    }
    /**
     * Get glaeubigeridentifikationsnummer value
     * @return string|null
     */
    public function getGlaeubigeridentifikationsnummer()
    {
        return $this->glaeubigeridentifikationsnummer;
    }
    /**
     * Set glaeubigeridentifikationsnummer value
     * @param string $glaeubigeridentifikationsnummer
     * @return \StructType\Organisationseinheit
     */
    public function setGlaeubigeridentifikationsnummer($glaeubigeridentifikationsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($glaeubigeridentifikationsnummer) && !is_string($glaeubigeridentifikationsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($glaeubigeridentifikationsnummer, true), gettype($glaeubigeridentifikationsnummer)), __LINE__);
        }
        $this->glaeubigeridentifikationsnummer = $glaeubigeridentifikationsnummer;
        return $this;
    }
    /**
     * Get zahlungsweisen value
     * @return \StructType\Code_Zahlungsweise[]|null
     */
    public function getZahlungsweisen()
    {
        return $this->zahlungsweisen;
    }
    /**
     * This method is responsible for validating the values passed to the setZahlungsweisen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZahlungsweisen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZahlungsweisenForArrayConstraintsFromSetZahlungsweisen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitZahlungsweisenItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitZahlungsweisenItem instanceof \StructType\Code_Zahlungsweise) {
                $invalidValues[] = is_object($organisationseinheitZahlungsweisenItem) ? get_class($organisationseinheitZahlungsweisenItem) : sprintf('%s(%s)', gettype($organisationseinheitZahlungsweisenItem), var_export($organisationseinheitZahlungsweisenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zahlungsweisen property can only contain items of type \StructType\Code_Zahlungsweise, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zahlungsweisen value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Zahlungsweise[] $zahlungsweisen
     * @return \StructType\Organisationseinheit
     */
    public function setZahlungsweisen(array $zahlungsweisen = array())
    {
        // validation for constraint: array
        if ('' !== ($zahlungsweisenArrayErrorMessage = self::validateZahlungsweisenForArrayConstraintsFromSetZahlungsweisen($zahlungsweisen))) {
            throw new \InvalidArgumentException($zahlungsweisenArrayErrorMessage, __LINE__);
        }
        $this->zahlungsweisen = $zahlungsweisen;
        return $this;
    }
    /**
     * Add item to zahlungsweisen value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Zahlungsweise $item
     * @return \StructType\Organisationseinheit
     */
    public function addToZahlungsweisen(\StructType\Code_Zahlungsweise $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Code_Zahlungsweise) {
            throw new \InvalidArgumentException(sprintf('The zahlungsweisen property can only contain items of type \StructType\Code_Zahlungsweise, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zahlungsweisen[] = $item;
        return $this;
    }
    /**
     * Get zahlungsweisenText value
     * @return \StructType\String_Localized[]|null
     */
    public function getZahlungsweisenText()
    {
        return $this->zahlungsweisenText;
    }
    /**
     * This method is responsible for validating the values passed to the setZahlungsweisenText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZahlungsweisenText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZahlungsweisenTextForArrayConstraintsFromSetZahlungsweisenText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitZahlungsweisenTextItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitZahlungsweisenTextItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($organisationseinheitZahlungsweisenTextItem) ? get_class($organisationseinheitZahlungsweisenTextItem) : sprintf('%s(%s)', gettype($organisationseinheitZahlungsweisenTextItem), var_export($organisationseinheitZahlungsweisenTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zahlungsweisenText property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zahlungsweisenText value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $zahlungsweisenText
     * @return \StructType\Organisationseinheit
     */
    public function setZahlungsweisenText(array $zahlungsweisenText = array())
    {
        // validation for constraint: array
        if ('' !== ($zahlungsweisenTextArrayErrorMessage = self::validateZahlungsweisenTextForArrayConstraintsFromSetZahlungsweisenText($zahlungsweisenText))) {
            throw new \InvalidArgumentException($zahlungsweisenTextArrayErrorMessage, __LINE__);
        }
        $this->zahlungsweisenText = $zahlungsweisenText;
        return $this;
    }
    /**
     * Add item to zahlungsweisenText value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Organisationseinheit
     */
    public function addToZahlungsweisenText(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The zahlungsweisenText property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zahlungsweisenText[] = $item;
        return $this;
    }
    /**
     * Get synonym value
     * @return \StructType\String_Localized[]|null
     */
    public function getSynonym()
    {
        return $this->synonym;
    }
    /**
     * This method is responsible for validating the values passed to the setSynonym method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSynonym method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSynonymForArrayConstraintsFromSetSynonym(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitSynonymItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitSynonymItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($organisationseinheitSynonymItem) ? get_class($organisationseinheitSynonymItem) : sprintf('%s(%s)', gettype($organisationseinheitSynonymItem), var_export($organisationseinheitSynonymItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The synonym property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set synonym value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $synonym
     * @return \StructType\Organisationseinheit
     */
    public function setSynonym(array $synonym = array())
    {
        // validation for constraint: array
        if ('' !== ($synonymArrayErrorMessage = self::validateSynonymForArrayConstraintsFromSetSynonym($synonym))) {
            throw new \InvalidArgumentException($synonymArrayErrorMessage, __LINE__);
        }
        $this->synonym = $synonym;
        return $this;
    }
    /**
     * Add item to synonym value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Organisationseinheit
     */
    public function addToSynonym(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The synonym property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->synonym[] = $item;
        return $this;
    }
    /**
     * Get herausgeber value
     * @return \StructType\Herausgeber|null
     */
    public function getHerausgeber()
    {
        return $this->herausgeber;
    }
    /**
     * Set herausgeber value
     * @param \StructType\Herausgeber $herausgeber
     * @return \StructType\Organisationseinheit
     */
    public function setHerausgeber(\StructType\Herausgeber $herausgeber = null)
    {
        $this->herausgeber = $herausgeber;
        return $this;
    }
    /**
     * Get versionsinformation value
     * @return \StructType\Versionsinformation|null
     */
    public function getVersionsinformation()
    {
        return $this->versionsinformation;
    }
    /**
     * Set versionsinformation value
     * @param \StructType\Versionsinformation $versionsinformation
     * @return \StructType\Organisationseinheit
     */
    public function setVersionsinformation(\StructType\Versionsinformation $versionsinformation = null)
    {
        $this->versionsinformation = $versionsinformation;
        return $this;
    }
    /**
     * Get sprachversion value
     * @return \StructType\Sprachversion[]|null
     */
    public function getSprachversion()
    {
        return $this->sprachversion;
    }
    /**
     * This method is responsible for validating the values passed to the setSprachversion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSprachversion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSprachversionForArrayConstraintsFromSetSprachversion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitSprachversionItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitSprachversionItem instanceof \StructType\Sprachversion) {
                $invalidValues[] = is_object($organisationseinheitSprachversionItem) ? get_class($organisationseinheitSprachversionItem) : sprintf('%s(%s)', gettype($organisationseinheitSprachversionItem), var_export($organisationseinheitSprachversionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sprachversion property can only contain items of type \StructType\Sprachversion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sprachversion value
     * @throws \InvalidArgumentException
     * @param \StructType\Sprachversion[] $sprachversion
     * @return \StructType\Organisationseinheit
     */
    public function setSprachversion(array $sprachversion = array())
    {
        // validation for constraint: array
        if ('' !== ($sprachversionArrayErrorMessage = self::validateSprachversionForArrayConstraintsFromSetSprachversion($sprachversion))) {
            throw new \InvalidArgumentException($sprachversionArrayErrorMessage, __LINE__);
        }
        $this->sprachversion = $sprachversion;
        return $this;
    }
    /**
     * Add item to sprachversion value
     * @throws \InvalidArgumentException
     * @param \StructType\Sprachversion $item
     * @return \StructType\Organisationseinheit
     */
    public function addToSprachversion(\StructType\Sprachversion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Sprachversion) {
            throw new \InvalidArgumentException(sprintf('The sprachversion property can only contain items of type \StructType\Sprachversion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sprachversion[] = $item;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $organisationseinheitGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$organisationseinheitGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($organisationseinheitGueltigkeitItem) ? get_class($organisationseinheitGueltigkeitItem) : sprintf('%s(%s)', gettype($organisationseinheitGueltigkeitItem), var_export($organisationseinheitGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\Organisationseinheit
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Organisationseinheit
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
}
