<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperationMethodType StructType
 * @subpackage Structs
 */
class OperationMethodType extends AbstractStructBase
{
    /**
     * The formulaCitation
     * @var \StructType\FormulaCitation
     */
    public $formulaCitation;
    /**
     * The formula
     * @var \StructType\CodeType
     */
    public $formula;
    /**
     * The sourceDimensions
     * @var int
     */
    public $sourceDimensions;
    /**
     * The targetDimensions
     * @var int
     */
    public $targetDimensions;
    /**
     * The parameter
     * @var \StructType\AbstractGeneralOperationParameterPropertyType
     */
    public $parameter;
    /**
     * Constructor method for OperationMethodType
     * @uses OperationMethodType::setFormulaCitation()
     * @uses OperationMethodType::setFormula()
     * @uses OperationMethodType::setSourceDimensions()
     * @uses OperationMethodType::setTargetDimensions()
     * @uses OperationMethodType::setParameter()
     * @param \StructType\FormulaCitation $formulaCitation
     * @param \StructType\CodeType $formula
     * @param int $sourceDimensions
     * @param int $targetDimensions
     * @param \StructType\AbstractGeneralOperationParameterPropertyType $parameter
     */
    public function __construct(\StructType\FormulaCitation $formulaCitation = null, \StructType\CodeType $formula = null, $sourceDimensions = null, $targetDimensions = null, \StructType\AbstractGeneralOperationParameterPropertyType $parameter = null)
    {
        $this
            ->setFormulaCitation($formulaCitation)
            ->setFormula($formula)
            ->setSourceDimensions($sourceDimensions)
            ->setTargetDimensions($targetDimensions)
            ->setParameter($parameter);
    }
    /**
     * Get formulaCitation value
     * @return \StructType\FormulaCitation|null
     */
    public function getFormulaCitation()
    {
        return $this->formulaCitation;
    }
    /**
     * Set formulaCitation value
     * @param \StructType\FormulaCitation $formulaCitation
     * @return \StructType\OperationMethodType
     */
    public function setFormulaCitation(\StructType\FormulaCitation $formulaCitation = null)
    {
        $this->formulaCitation = $formulaCitation;
        return $this;
    }
    /**
     * Get formula value
     * @return \StructType\CodeType|null
     */
    public function getFormula()
    {
        return $this->formula;
    }
    /**
     * Set formula value
     * @param \StructType\CodeType $formula
     * @return \StructType\OperationMethodType
     */
    public function setFormula(\StructType\CodeType $formula = null)
    {
        $this->formula = $formula;
        return $this;
    }
    /**
     * Get sourceDimensions value
     * @return int|null
     */
    public function getSourceDimensions()
    {
        return $this->sourceDimensions;
    }
    /**
     * Set sourceDimensions value
     * @param int $sourceDimensions
     * @return \StructType\OperationMethodType
     */
    public function setSourceDimensions($sourceDimensions = null)
    {
        // validation for constraint: int
        if (!is_null($sourceDimensions) && !(is_int($sourceDimensions) || ctype_digit($sourceDimensions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sourceDimensions, true), gettype($sourceDimensions)), __LINE__);
        }
        $this->sourceDimensions = $sourceDimensions;
        return $this;
    }
    /**
     * Get targetDimensions value
     * @return int|null
     */
    public function getTargetDimensions()
    {
        return $this->targetDimensions;
    }
    /**
     * Set targetDimensions value
     * @param int $targetDimensions
     * @return \StructType\OperationMethodType
     */
    public function setTargetDimensions($targetDimensions = null)
    {
        // validation for constraint: int
        if (!is_null($targetDimensions) && !(is_int($targetDimensions) || ctype_digit($targetDimensions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($targetDimensions, true), gettype($targetDimensions)), __LINE__);
        }
        $this->targetDimensions = $targetDimensions;
        return $this;
    }
    /**
     * Get parameter value
     * @return \StructType\AbstractGeneralOperationParameterPropertyType|null
     */
    public function getParameter()
    {
        return $this->parameter;
    }
    /**
     * Set parameter value
     * @param \StructType\AbstractGeneralOperationParameterPropertyType $parameter
     * @return \StructType\OperationMethodType
     */
    public function setParameter(\StructType\AbstractGeneralOperationParameterPropertyType $parameter = null)
    {
        $this->parameter = $parameter;
        return $this;
    }
}
