<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OnlinedienstDynamischerParameter StructType
 * Meta information extracted from the WSDL
 * - documentation: Parameternamen und -typen zum Anhängen an den Link des Onlinedienstes. Die Parameter-Werte sollen dann je nach Kontext beim Rendern der Links dynamisch eingefügt werden.
 * @subpackage Structs
 */
class OnlinedienstDynamischerParameter extends AbstractStructBase
{
    /**
     * The typ
     * Meta information extracted from the WSDL
     * - documentation: Typ des Parameters, z.B. "Leistung".
     * @var \StructType\Code_OnlinedienstDynamischerParameterTyp
     */
    public $typ;
    /**
     * The parameterName
     * Meta information extracted from the WSDL
     * - documentation: URL-Parametername
     * @var string
     */
    public $parameterName;
    /**
     * Constructor method for OnlinedienstDynamischerParameter
     * @uses OnlinedienstDynamischerParameter::setTyp()
     * @uses OnlinedienstDynamischerParameter::setParameterName()
     * @param \StructType\Code_OnlinedienstDynamischerParameterTyp $typ
     * @param string $parameterName
     */
    public function __construct(\StructType\Code_OnlinedienstDynamischerParameterTyp $typ = null, $parameterName = null)
    {
        $this
            ->setTyp($typ)
            ->setParameterName($parameterName);
    }
    /**
     * Get typ value
     * @return \StructType\Code_OnlinedienstDynamischerParameterTyp|null
     */
    public function getTyp()
    {
        return $this->typ;
    }
    /**
     * Set typ value
     * @param \StructType\Code_OnlinedienstDynamischerParameterTyp $typ
     * @return \StructType\OnlinedienstDynamischerParameter
     */
    public function setTyp(\StructType\Code_OnlinedienstDynamischerParameterTyp $typ = null)
    {
        $this->typ = $typ;
        return $this;
    }
    /**
     * Get parameterName value
     * @return string|null
     */
    public function getParameterName()
    {
        return $this->parameterName;
    }
    /**
     * Set parameterName value
     * @param string $parameterName
     * @return \StructType\OnlinedienstDynamischerParameter
     */
    public function setParameterName($parameterName = null)
    {
        // validation for constraint: string
        if (!is_null($parameterName) && !is_string($parameterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parameterName, true), gettype($parameterName)), __LINE__);
        }
        $this->parameterName = $parameterName;
        return $this;
    }
}
