<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OZGZuordnungLeiKaLeistung StructType
 * Meta information extracted from the WSDL
 * - documentation: Datentyp zur Zuordnung von LeiKa-Leistungen zu OZG-Leistungen.
 * @subpackage Structs
 */
class OZGZuordnungLeiKaLeistung extends AbstractStructBase
{
    /**
     * The leikaId
     * Meta information extracted from the WSDL
     * - documentation: ID der LeiKa-Leistung.
     * @var \StructType\Identifikator
     */
    public $leikaId;
    /**
     * The leikaSchluessel
     * Meta information extracted from the WSDL
     * - documentation: LeiKa-Schlüssel (sprechend) der LeiKa-Leistung.
     * @var \StructType\Code_LeiKaLeistung
     */
    public $leikaSchluessel;
    /**
     * The kennzeichenOZGRelevant
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichen, ob die Leistung OZG-relevant ist.
     * @var bool
     */
    public $kennzeichenOZGRelevant;
    /**
     * Constructor method for OZGZuordnungLeiKaLeistung
     * @uses OZGZuordnungLeiKaLeistung::setLeikaId()
     * @uses OZGZuordnungLeiKaLeistung::setLeikaSchluessel()
     * @uses OZGZuordnungLeiKaLeistung::setKennzeichenOZGRelevant()
     * @param \StructType\Identifikator $leikaId
     * @param \StructType\Code_LeiKaLeistung $leikaSchluessel
     * @param bool $kennzeichenOZGRelevant
     */
    public function __construct(\StructType\Identifikator $leikaId = null, \StructType\Code_LeiKaLeistung $leikaSchluessel = null, $kennzeichenOZGRelevant = null)
    {
        $this
            ->setLeikaId($leikaId)
            ->setLeikaSchluessel($leikaSchluessel)
            ->setKennzeichenOZGRelevant($kennzeichenOZGRelevant);
    }
    /**
     * Get leikaId value
     * @return \StructType\Identifikator|null
     */
    public function getLeikaId()
    {
        return $this->leikaId;
    }
    /**
     * Set leikaId value
     * @param \StructType\Identifikator $leikaId
     * @return \StructType\OZGZuordnungLeiKaLeistung
     */
    public function setLeikaId(\StructType\Identifikator $leikaId = null)
    {
        $this->leikaId = $leikaId;
        return $this;
    }
    /**
     * Get leikaSchluessel value
     * @return \StructType\Code_LeiKaLeistung|null
     */
    public function getLeikaSchluessel()
    {
        return $this->leikaSchluessel;
    }
    /**
     * Set leikaSchluessel value
     * @param \StructType\Code_LeiKaLeistung $leikaSchluessel
     * @return \StructType\OZGZuordnungLeiKaLeistung
     */
    public function setLeikaSchluessel(\StructType\Code_LeiKaLeistung $leikaSchluessel = null)
    {
        $this->leikaSchluessel = $leikaSchluessel;
        return $this;
    }
    /**
     * Get kennzeichenOZGRelevant value
     * @return bool|null
     */
    public function getKennzeichenOZGRelevant()
    {
        return $this->kennzeichenOZGRelevant;
    }
    /**
     * Set kennzeichenOZGRelevant value
     * @param bool $kennzeichenOZGRelevant
     * @return \StructType\OZGZuordnungLeiKaLeistung
     */
    public function setKennzeichenOZGRelevant($kennzeichenOZGRelevant = null)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenOZGRelevant) && !is_bool($kennzeichenOZGRelevant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenOZGRelevant, true), gettype($kennzeichenOZGRelevant)), __LINE__);
        }
        $this->kennzeichenOZGRelevant = $kennzeichenOZGRelevant;
        return $this;
    }
}
