<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OZGLeistung StructType
 * Meta information extracted from the WSDL
 * - documentation: Datentyp zur Abbildung des OZG-Katalogs. Dieser besteht aus OZG-Leistungen, welche in Themenfelder und Lagen einsortiert sind. Jeder OZG-Leistung sind Leistungen aus dem FIM-Baustein Leistung (LeiKa) zugeordnet.
 * @subpackage Structs
 */
class OZGLeistung extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: ID der OZG-Leistung als Code.
     * @var \StructType\Code_OZGLeistung
     */
    public $id;
    /**
     * The themenfeld
     * Meta information extracted from the WSDL
     * - documentation: Code des OZG-Themenfelds.
     * @var \StructType\Code_OZGThemenfeld
     */
    public $themenfeld;
    /**
     * The lage
     * Meta information extracted from the WSDL
     * - documentation: code der OZG-Geschäfts- oder Lebenslage.
     * @var \StructType\Code_OZGLage
     */
    public $lage;
    /**
     * The zielgruppe
     * Meta information extracted from the WSDL
     * - documentation: Zielgruppe der Leistung.
     * @var \StructType\Code_Leistungsadressat
     */
    public $zielgruppe;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Textuelle Beschreibung der Leistung.
     * - minOccurs: 0
     * @var string
     */
    public $beschreibung;
    /**
     * The versionsinformation
     * Meta information extracted from the WSDL
     * - documentation: Informationen zur Versionierung.
     * - minOccurs: 0
     * @var \StructType\Versionsinformation
     */
    public $versionsinformation;
    /**
     * The leikaLeistung
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete LeiKa-Leistungen zur OZG-Leistung.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OZGZuordnungLeiKaLeistung[]
     */
    public $leikaLeistung;
    /**
     * Constructor method for OZGLeistung
     * @uses OZGLeistung::setId()
     * @uses OZGLeistung::setThemenfeld()
     * @uses OZGLeistung::setLage()
     * @uses OZGLeistung::setZielgruppe()
     * @uses OZGLeistung::setBeschreibung()
     * @uses OZGLeistung::setVersionsinformation()
     * @uses OZGLeistung::setLeikaLeistung()
     * @param \StructType\Code_OZGLeistung $id
     * @param \StructType\Code_OZGThemenfeld $themenfeld
     * @param \StructType\Code_OZGLage $lage
     * @param \StructType\Code_Leistungsadressat $zielgruppe
     * @param string $beschreibung
     * @param \StructType\Versionsinformation $versionsinformation
     * @param \StructType\OZGZuordnungLeiKaLeistung[] $leikaLeistung
     */
    public function __construct(\StructType\Code_OZGLeistung $id = null, \StructType\Code_OZGThemenfeld $themenfeld = null, \StructType\Code_OZGLage $lage = null, \StructType\Code_Leistungsadressat $zielgruppe = null, $beschreibung = null, \StructType\Versionsinformation $versionsinformation = null, array $leikaLeistung = array())
    {
        $this
            ->setId($id)
            ->setThemenfeld($themenfeld)
            ->setLage($lage)
            ->setZielgruppe($zielgruppe)
            ->setBeschreibung($beschreibung)
            ->setVersionsinformation($versionsinformation)
            ->setLeikaLeistung($leikaLeistung);
    }
    /**
     * Get id value
     * @return \StructType\Code_OZGLeistung|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Code_OZGLeistung $id
     * @return \StructType\OZGLeistung
     */
    public function setId(\StructType\Code_OZGLeistung $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get themenfeld value
     * @return \StructType\Code_OZGThemenfeld|null
     */
    public function getThemenfeld()
    {
        return $this->themenfeld;
    }
    /**
     * Set themenfeld value
     * @param \StructType\Code_OZGThemenfeld $themenfeld
     * @return \StructType\OZGLeistung
     */
    public function setThemenfeld(\StructType\Code_OZGThemenfeld $themenfeld = null)
    {
        $this->themenfeld = $themenfeld;
        return $this;
    }
    /**
     * Get lage value
     * @return \StructType\Code_OZGLage|null
     */
    public function getLage()
    {
        return $this->lage;
    }
    /**
     * Set lage value
     * @param \StructType\Code_OZGLage $lage
     * @return \StructType\OZGLeistung
     */
    public function setLage(\StructType\Code_OZGLage $lage = null)
    {
        $this->lage = $lage;
        return $this;
    }
    /**
     * Get zielgruppe value
     * @return \StructType\Code_Leistungsadressat|null
     */
    public function getZielgruppe()
    {
        return $this->zielgruppe;
    }
    /**
     * Set zielgruppe value
     * @param \StructType\Code_Leistungsadressat $zielgruppe
     * @return \StructType\OZGLeistung
     */
    public function setZielgruppe(\StructType\Code_Leistungsadressat $zielgruppe = null)
    {
        $this->zielgruppe = $zielgruppe;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return string|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * Set beschreibung value
     * @param string $beschreibung
     * @return \StructType\OZGLeistung
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Get versionsinformation value
     * @return \StructType\Versionsinformation|null
     */
    public function getVersionsinformation()
    {
        return $this->versionsinformation;
    }
    /**
     * Set versionsinformation value
     * @param \StructType\Versionsinformation $versionsinformation
     * @return \StructType\OZGLeistung
     */
    public function setVersionsinformation(\StructType\Versionsinformation $versionsinformation = null)
    {
        $this->versionsinformation = $versionsinformation;
        return $this;
    }
    /**
     * Get leikaLeistung value
     * @return \StructType\OZGZuordnungLeiKaLeistung[]|null
     */
    public function getLeikaLeistung()
    {
        return $this->leikaLeistung;
    }
    /**
     * This method is responsible for validating the values passed to the setLeikaLeistung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeikaLeistung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeikaLeistungForArrayConstraintsFromSetLeikaLeistung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $oZGLeistungLeikaLeistungItem) {
            // validation for constraint: itemType
            if (!$oZGLeistungLeikaLeistungItem instanceof \StructType\OZGZuordnungLeiKaLeistung) {
                $invalidValues[] = is_object($oZGLeistungLeikaLeistungItem) ? get_class($oZGLeistungLeikaLeistungItem) : sprintf('%s(%s)', gettype($oZGLeistungLeikaLeistungItem), var_export($oZGLeistungLeikaLeistungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The leikaLeistung property can only contain items of type \StructType\OZGZuordnungLeiKaLeistung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set leikaLeistung value
     * @throws \InvalidArgumentException
     * @param \StructType\OZGZuordnungLeiKaLeistung[] $leikaLeistung
     * @return \StructType\OZGLeistung
     */
    public function setLeikaLeistung(array $leikaLeistung = array())
    {
        // validation for constraint: array
        if ('' !== ($leikaLeistungArrayErrorMessage = self::validateLeikaLeistungForArrayConstraintsFromSetLeikaLeistung($leikaLeistung))) {
            throw new \InvalidArgumentException($leikaLeistungArrayErrorMessage, __LINE__);
        }
        $this->leikaLeistung = $leikaLeistung;
        return $this;
    }
    /**
     * Add item to leikaLeistung value
     * @throws \InvalidArgumentException
     * @param \StructType\OZGZuordnungLeiKaLeistung $item
     * @return \StructType\OZGLeistung
     */
    public function addToLeikaLeistung(\StructType\OZGZuordnungLeiKaLeistung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OZGZuordnungLeiKaLeistung) {
            throw new \InvalidArgumentException(sprintf('The leikaLeistung property can only contain items of type \StructType\OZGZuordnungLeiKaLeistung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->leikaLeistung[] = $item;
        return $this;
    }
}
