<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NodeType StructType
 * @subpackage Structs
 */
class NodeType extends AbstractStructBase
{
    /**
     * The container
     * @var \StructType\FaceOrTopoSolidPropertyType
     */
    public $container;
    /**
     * The directedEdge
     * @var \StructType\DirectedEdgePropertyType
     */
    public $directedEdge;
    /**
     * The pointProperty
     * @var \StructType\PointPropertyType
     */
    public $pointProperty;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for NodeType
     * @uses NodeType::setContainer()
     * @uses NodeType::setDirectedEdge()
     * @uses NodeType::setPointProperty()
     * @uses NodeType::setAggregationType()
     * @param \StructType\FaceOrTopoSolidPropertyType $container
     * @param \StructType\DirectedEdgePropertyType $directedEdge
     * @param \StructType\PointPropertyType $pointProperty
     * @param string $aggregationType
     */
    public function __construct(\StructType\FaceOrTopoSolidPropertyType $container = null, \StructType\DirectedEdgePropertyType $directedEdge = null, \StructType\PointPropertyType $pointProperty = null, $aggregationType = null)
    {
        $this
            ->setContainer($container)
            ->setDirectedEdge($directedEdge)
            ->setPointProperty($pointProperty)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get container value
     * @return \StructType\FaceOrTopoSolidPropertyType|null
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @param \StructType\FaceOrTopoSolidPropertyType $container
     * @return \StructType\NodeType
     */
    public function setContainer(\StructType\FaceOrTopoSolidPropertyType $container = null)
    {
        $this->container = $container;
        return $this;
    }
    /**
     * Get directedEdge value
     * @return \StructType\DirectedEdgePropertyType|null
     */
    public function getDirectedEdge()
    {
        return $this->directedEdge;
    }
    /**
     * Set directedEdge value
     * @param \StructType\DirectedEdgePropertyType $directedEdge
     * @return \StructType\NodeType
     */
    public function setDirectedEdge(\StructType\DirectedEdgePropertyType $directedEdge = null)
    {
        $this->directedEdge = $directedEdge;
        return $this;
    }
    /**
     * Get pointProperty value
     * @return \StructType\PointPropertyType|null
     */
    public function getPointProperty()
    {
        return $this->pointProperty;
    }
    /**
     * Set pointProperty value
     * @param \StructType\PointPropertyType $pointProperty
     * @return \StructType\NodeType
     */
    public function setPointProperty(\StructType\PointPropertyType $pointProperty = null)
    {
        $this->pointProperty = $pointProperty;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\NodeType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
