<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NachrichtAntwort StructType
 * Meta information extracted from the WSDL
 * - documentation: Abstrakter Datentyp für Antworten. Dient als Container.
 * @subpackage Structs
 */
abstract class NachrichtAntwort extends AbstractStructBase
{
    /**
     * The antwortnummer
     * Meta information extracted from the WSDL
     * - documentation: Kennung der Antwort. Wird vom antwortenden System vergeben.
     * - minOccurs: 0
     * @var string
     */
    public $antwortnummer;
    /**
     * The antwortrueckgabecode
     * Meta information extracted from the WSDL
     * - documentation: Rückgabecode der Antwortnachricht
     * @var \StructType\Code_NachrichtAntwortCode
     */
    public $antwortrueckgabecode;
    /**
     * The antwortrueckgabezusatz
     * Meta information extracted from the WSDL
     * - documentation: Textuelle Zusatzinformationen zum Rückgabecode der Antwort.
     * - minOccurs: 0
     * @var string
     */
    public $antwortrueckgabezusatz;
    /**
     * Constructor method for NachrichtAntwort
     * @uses NachrichtAntwort::setAntwortnummer()
     * @uses NachrichtAntwort::setAntwortrueckgabecode()
     * @uses NachrichtAntwort::setAntwortrueckgabezusatz()
     * @param string $antwortnummer
     * @param \StructType\Code_NachrichtAntwortCode $antwortrueckgabecode
     * @param string $antwortrueckgabezusatz
     */
    public function __construct($antwortnummer = null, \StructType\Code_NachrichtAntwortCode $antwortrueckgabecode = null, $antwortrueckgabezusatz = null)
    {
        $this
            ->setAntwortnummer($antwortnummer)
            ->setAntwortrueckgabecode($antwortrueckgabecode)
            ->setAntwortrueckgabezusatz($antwortrueckgabezusatz);
    }
    /**
     * Get antwortnummer value
     * @return string|null
     */
    public function getAntwortnummer()
    {
        return $this->antwortnummer;
    }
    /**
     * Set antwortnummer value
     * @param string $antwortnummer
     * @return \StructType\NachrichtAntwort
     */
    public function setAntwortnummer($antwortnummer = null)
    {
        // validation for constraint: string
        if (!is_null($antwortnummer) && !is_string($antwortnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($antwortnummer, true), gettype($antwortnummer)), __LINE__);
        }
        $this->antwortnummer = $antwortnummer;
        return $this;
    }
    /**
     * Get antwortrueckgabecode value
     * @return \StructType\Code_NachrichtAntwortCode|null
     */
    public function getAntwortrueckgabecode()
    {
        return $this->antwortrueckgabecode;
    }
    /**
     * Set antwortrueckgabecode value
     * @param \StructType\Code_NachrichtAntwortCode $antwortrueckgabecode
     * @return \StructType\NachrichtAntwort
     */
    public function setAntwortrueckgabecode(\StructType\Code_NachrichtAntwortCode $antwortrueckgabecode = null)
    {
        $this->antwortrueckgabecode = $antwortrueckgabecode;
        return $this;
    }
    /**
     * Get antwortrueckgabezusatz value
     * @return string|null
     */
    public function getAntwortrueckgabezusatz()
    {
        return $this->antwortrueckgabezusatz;
    }
    /**
     * Set antwortrueckgabezusatz value
     * @param string $antwortrueckgabezusatz
     * @return \StructType\NachrichtAntwort
     */
    public function setAntwortrueckgabezusatz($antwortrueckgabezusatz = null)
    {
        // validation for constraint: string
        if (!is_null($antwortrueckgabezusatz) && !is_string($antwortrueckgabezusatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($antwortrueckgabezusatz, true), gettype($antwortrueckgabezusatz)), __LINE__);
        }
        $this->antwortrueckgabezusatz = $antwortrueckgabezusatz;
        return $this;
    }
}
