<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NachrichtAnfrage StructType
 * Meta information extracted from the WSDL
 * - documentation: Abstrakter Datentyp für Anfragen. Dient als Container.
 * @subpackage Structs
 */
abstract class NachrichtAnfrage extends AbstractStructBase
{
    /**
     * The anfragenummer
     * Meta information extracted from the WSDL
     * - documentation: Kennung für die Anfrage. Dient insbesondere zur Zuordnung der Antwort zur entsprechenden Anfrage.
     * - minOccurs: 0
     * @var string
     */
    public $anfragenummer;
    /**
     * The zusatzinformation
     * Meta information extracted from the WSDL
     * - documentation: Textuelle Zusatzinformationen zur Anfrage. Kann z.B. Parameter enthalten, die durch SLAs geregelt werden.
     * - minOccurs: 0
     * @var string
     */
    public $zusatzinformation;
    /**
     * Constructor method for NachrichtAnfrage
     * @uses NachrichtAnfrage::setAnfragenummer()
     * @uses NachrichtAnfrage::setZusatzinformation()
     * @param string $anfragenummer
     * @param string $zusatzinformation
     */
    public function __construct($anfragenummer = null, $zusatzinformation = null)
    {
        $this
            ->setAnfragenummer($anfragenummer)
            ->setZusatzinformation($zusatzinformation);
    }
    /**
     * Get anfragenummer value
     * @return string|null
     */
    public function getAnfragenummer()
    {
        return $this->anfragenummer;
    }
    /**
     * Set anfragenummer value
     * @param string $anfragenummer
     * @return \StructType\NachrichtAnfrage
     */
    public function setAnfragenummer($anfragenummer = null)
    {
        // validation for constraint: string
        if (!is_null($anfragenummer) && !is_string($anfragenummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anfragenummer, true), gettype($anfragenummer)), __LINE__);
        }
        $this->anfragenummer = $anfragenummer;
        return $this;
    }
    /**
     * Get zusatzinformation value
     * @return string|null
     */
    public function getZusatzinformation()
    {
        return $this->zusatzinformation;
    }
    /**
     * Set zusatzinformation value
     * @param string $zusatzinformation
     * @return \StructType\NachrichtAnfrage
     */
    public function setZusatzinformation($zusatzinformation = null)
    {
        // validation for constraint: string
        if (!is_null($zusatzinformation) && !is_string($zusatzinformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zusatzinformation, true), gettype($zusatzinformation)), __LINE__);
        }
        $this->zusatzinformation = $zusatzinformation;
        return $this;
    }
}
