<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MultiCurveType StructType
 * @subpackage Structs
 */
class MultiCurveType extends AbstractStructBase
{
    /**
     * The curveMember
     * @var \StructType\CurvePropertyType
     */
    public $curveMember;
    /**
     * The curveMembers
     * @var \StructType\CurveArrayPropertyType
     */
    public $curveMembers;
    /**
     * Constructor method for MultiCurveType
     * @uses MultiCurveType::setCurveMember()
     * @uses MultiCurveType::setCurveMembers()
     * @param \StructType\CurvePropertyType $curveMember
     * @param \StructType\CurveArrayPropertyType $curveMembers
     */
    public function __construct(\StructType\CurvePropertyType $curveMember = null, \StructType\CurveArrayPropertyType $curveMembers = null)
    {
        $this
            ->setCurveMember($curveMember)
            ->setCurveMembers($curveMembers);
    }
    /**
     * Get curveMember value
     * @return \StructType\CurvePropertyType|null
     */
    public function getCurveMember()
    {
        return $this->curveMember;
    }
    /**
     * Set curveMember value
     * @param \StructType\CurvePropertyType $curveMember
     * @return \StructType\MultiCurveType
     */
    public function setCurveMember(\StructType\CurvePropertyType $curveMember = null)
    {
        $this->curveMember = $curveMember;
        return $this;
    }
    /**
     * Get curveMembers value
     * @return \StructType\CurveArrayPropertyType|null
     */
    public function getCurveMembers()
    {
        return $this->curveMembers;
    }
    /**
     * Set curveMembers value
     * @param \StructType\CurveArrayPropertyType $curveMembers
     * @return \StructType\MultiCurveType
     */
    public function setCurveMembers(\StructType\CurveArrayPropertyType $curveMembers = null)
    {
        $this->curveMembers = $curveMembers;
        return $this;
    }
}
