<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MovingObjectStatusType StructType
 * @subpackage Structs
 */
class MovingObjectStatusType extends AbstractStructBase
{
    /**
     * The position
     * @var \StructType\GeometryPropertyType
     */
    public $position;
    /**
     * The pos
     * @var \StructType\DirectPositionType
     */
    public $pos;
    /**
     * The locationName
     * @var \StructType\CodeType
     */
    public $locationName;
    /**
     * The locationReference
     * @var \StructType\ReferenceType
     */
    public $locationReference;
    /**
     * The location
     * @var \StructType\LocationPropertyType
     */
    public $location;
    /**
     * The speed
     * @var \StructType\MeasureType
     */
    public $speed;
    /**
     * The bearing
     * @var \StructType\DirectionPropertyType
     */
    public $bearing;
    /**
     * The acceleration
     * @var \StructType\MeasureType
     */
    public $acceleration;
    /**
     * The elevation
     * @var \StructType\MeasureType
     */
    public $elevation;
    /**
     * The status
     * @var \StructType\StringOrRefType
     */
    public $status;
    /**
     * The statusReference
     * @var \StructType\ReferenceType
     */
    public $statusReference;
    /**
     * Constructor method for MovingObjectStatusType
     * @uses MovingObjectStatusType::setPosition()
     * @uses MovingObjectStatusType::setPos()
     * @uses MovingObjectStatusType::setLocationName()
     * @uses MovingObjectStatusType::setLocationReference()
     * @uses MovingObjectStatusType::setLocation()
     * @uses MovingObjectStatusType::setSpeed()
     * @uses MovingObjectStatusType::setBearing()
     * @uses MovingObjectStatusType::setAcceleration()
     * @uses MovingObjectStatusType::setElevation()
     * @uses MovingObjectStatusType::setStatus()
     * @uses MovingObjectStatusType::setStatusReference()
     * @param \StructType\GeometryPropertyType $position
     * @param \StructType\DirectPositionType $pos
     * @param \StructType\CodeType $locationName
     * @param \StructType\ReferenceType $locationReference
     * @param \StructType\LocationPropertyType $location
     * @param \StructType\MeasureType $speed
     * @param \StructType\DirectionPropertyType $bearing
     * @param \StructType\MeasureType $acceleration
     * @param \StructType\MeasureType $elevation
     * @param \StructType\StringOrRefType $status
     * @param \StructType\ReferenceType $statusReference
     */
    public function __construct(\StructType\GeometryPropertyType $position = null, \StructType\DirectPositionType $pos = null, \StructType\CodeType $locationName = null, \StructType\ReferenceType $locationReference = null, \StructType\LocationPropertyType $location = null, \StructType\MeasureType $speed = null, \StructType\DirectionPropertyType $bearing = null, \StructType\MeasureType $acceleration = null, \StructType\MeasureType $elevation = null, \StructType\StringOrRefType $status = null, \StructType\ReferenceType $statusReference = null)
    {
        $this
            ->setPosition($position)
            ->setPos($pos)
            ->setLocationName($locationName)
            ->setLocationReference($locationReference)
            ->setLocation($location)
            ->setSpeed($speed)
            ->setBearing($bearing)
            ->setAcceleration($acceleration)
            ->setElevation($elevation)
            ->setStatus($status)
            ->setStatusReference($statusReference);
    }
    /**
     * Get position value
     * @return \StructType\GeometryPropertyType|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * Set position value
     * @param \StructType\GeometryPropertyType $position
     * @return \StructType\MovingObjectStatusType
     */
    public function setPosition(\StructType\GeometryPropertyType $position = null)
    {
        $this->position = $position;
        return $this;
    }
    /**
     * Get pos value
     * @return \StructType\DirectPositionType|null
     */
    public function getPos()
    {
        return $this->pos;
    }
    /**
     * Set pos value
     * @param \StructType\DirectPositionType $pos
     * @return \StructType\MovingObjectStatusType
     */
    public function setPos(\StructType\DirectPositionType $pos = null)
    {
        $this->pos = $pos;
        return $this;
    }
    /**
     * Get locationName value
     * @return \StructType\CodeType|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set locationName value
     * @param \StructType\CodeType $locationName
     * @return \StructType\MovingObjectStatusType
     */
    public function setLocationName(\StructType\CodeType $locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get locationReference value
     * @return \StructType\ReferenceType|null
     */
    public function getLocationReference()
    {
        return $this->locationReference;
    }
    /**
     * Set locationReference value
     * @param \StructType\ReferenceType $locationReference
     * @return \StructType\MovingObjectStatusType
     */
    public function setLocationReference(\StructType\ReferenceType $locationReference = null)
    {
        $this->locationReference = $locationReference;
        return $this;
    }
    /**
     * Get location value
     * @return \StructType\LocationPropertyType|null
     */
    public function getLocation()
    {
        return $this->location;
    }
    /**
     * Set location value
     * @param \StructType\LocationPropertyType $location
     * @return \StructType\MovingObjectStatusType
     */
    public function setLocation(\StructType\LocationPropertyType $location = null)
    {
        $this->location = $location;
        return $this;
    }
    /**
     * Get speed value
     * @return \StructType\MeasureType|null
     */
    public function getSpeed()
    {
        return $this->speed;
    }
    /**
     * Set speed value
     * @param \StructType\MeasureType $speed
     * @return \StructType\MovingObjectStatusType
     */
    public function setSpeed(\StructType\MeasureType $speed = null)
    {
        $this->speed = $speed;
        return $this;
    }
    /**
     * Get bearing value
     * @return \StructType\DirectionPropertyType|null
     */
    public function getBearing()
    {
        return $this->bearing;
    }
    /**
     * Set bearing value
     * @param \StructType\DirectionPropertyType $bearing
     * @return \StructType\MovingObjectStatusType
     */
    public function setBearing(\StructType\DirectionPropertyType $bearing = null)
    {
        $this->bearing = $bearing;
        return $this;
    }
    /**
     * Get acceleration value
     * @return \StructType\MeasureType|null
     */
    public function getAcceleration()
    {
        return $this->acceleration;
    }
    /**
     * Set acceleration value
     * @param \StructType\MeasureType $acceleration
     * @return \StructType\MovingObjectStatusType
     */
    public function setAcceleration(\StructType\MeasureType $acceleration = null)
    {
        $this->acceleration = $acceleration;
        return $this;
    }
    /**
     * Get elevation value
     * @return \StructType\MeasureType|null
     */
    public function getElevation()
    {
        return $this->elevation;
    }
    /**
     * Set elevation value
     * @param \StructType\MeasureType $elevation
     * @return \StructType\MovingObjectStatusType
     */
    public function setElevation(\StructType\MeasureType $elevation = null)
    {
        $this->elevation = $elevation;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\StringOrRefType|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\StringOrRefType $status
     * @return \StructType\MovingObjectStatusType
     */
    public function setStatus(\StructType\StringOrRefType $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Get statusReference value
     * @return \StructType\ReferenceType|null
     */
    public function getStatusReference()
    {
        return $this->statusReference;
    }
    /**
     * Set statusReference value
     * @param \StructType\ReferenceType $statusReference
     * @return \StructType\MovingObjectStatusType
     */
    public function setStatusReference(\StructType\ReferenceType $statusReference = null)
    {
        $this->statusReference = $statusReference;
        return $this;
    }
}
