<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MD_ImageDescription_Type StructType
 * @subpackage Structs
 */
class MD_ImageDescription_Type extends AbstractStructBase
{
    /**
     * The illuminationElevationAngle
     * @var \StructType\Real_PropertyType
     */
    public $illuminationElevationAngle;
    /**
     * The illuminationAzimuthAngle
     * @var \StructType\Real_PropertyType
     */
    public $illuminationAzimuthAngle;
    /**
     * The imagingCondition
     * @var \StructType\MD_ImagingConditionCode_PropertyType
     */
    public $imagingCondition;
    /**
     * The imageQualityCode
     * @var \StructType\MD_Identifier_PropertyType
     */
    public $imageQualityCode;
    /**
     * The cloudCoverPercentage
     * @var \StructType\Real_PropertyType
     */
    public $cloudCoverPercentage;
    /**
     * The processingLevelCode
     * @var \StructType\MD_Identifier_PropertyType
     */
    public $processingLevelCode;
    /**
     * The compressionGenerationQuantity
     * @var \StructType\Integer_PropertyType
     */
    public $compressionGenerationQuantity;
    /**
     * The triangulationIndicator
     * @var \StructType\Boolean_PropertyType
     */
    public $triangulationIndicator;
    /**
     * The radiometricCalibrationDataAvailability
     * @var \StructType\Boolean_PropertyType
     */
    public $radiometricCalibrationDataAvailability;
    /**
     * The cameraCalibrationInformationAvailability
     * @var \StructType\Boolean_PropertyType
     */
    public $cameraCalibrationInformationAvailability;
    /**
     * The filmDistortionInformationAvailability
     * @var \StructType\Boolean_PropertyType
     */
    public $filmDistortionInformationAvailability;
    /**
     * The lensDistortionInformationAvailability
     * @var \StructType\Boolean_PropertyType
     */
    public $lensDistortionInformationAvailability;
    /**
     * Constructor method for MD_ImageDescription_Type
     * @uses MD_ImageDescription_Type::setIlluminationElevationAngle()
     * @uses MD_ImageDescription_Type::setIlluminationAzimuthAngle()
     * @uses MD_ImageDescription_Type::setImagingCondition()
     * @uses MD_ImageDescription_Type::setImageQualityCode()
     * @uses MD_ImageDescription_Type::setCloudCoverPercentage()
     * @uses MD_ImageDescription_Type::setProcessingLevelCode()
     * @uses MD_ImageDescription_Type::setCompressionGenerationQuantity()
     * @uses MD_ImageDescription_Type::setTriangulationIndicator()
     * @uses MD_ImageDescription_Type::setRadiometricCalibrationDataAvailability()
     * @uses MD_ImageDescription_Type::setCameraCalibrationInformationAvailability()
     * @uses MD_ImageDescription_Type::setFilmDistortionInformationAvailability()
     * @uses MD_ImageDescription_Type::setLensDistortionInformationAvailability()
     * @param \StructType\Real_PropertyType $illuminationElevationAngle
     * @param \StructType\Real_PropertyType $illuminationAzimuthAngle
     * @param \StructType\MD_ImagingConditionCode_PropertyType $imagingCondition
     * @param \StructType\MD_Identifier_PropertyType $imageQualityCode
     * @param \StructType\Real_PropertyType $cloudCoverPercentage
     * @param \StructType\MD_Identifier_PropertyType $processingLevelCode
     * @param \StructType\Integer_PropertyType $compressionGenerationQuantity
     * @param \StructType\Boolean_PropertyType $triangulationIndicator
     * @param \StructType\Boolean_PropertyType $radiometricCalibrationDataAvailability
     * @param \StructType\Boolean_PropertyType $cameraCalibrationInformationAvailability
     * @param \StructType\Boolean_PropertyType $filmDistortionInformationAvailability
     * @param \StructType\Boolean_PropertyType $lensDistortionInformationAvailability
     */
    public function __construct(\StructType\Real_PropertyType $illuminationElevationAngle = null, \StructType\Real_PropertyType $illuminationAzimuthAngle = null, \StructType\MD_ImagingConditionCode_PropertyType $imagingCondition = null, \StructType\MD_Identifier_PropertyType $imageQualityCode = null, \StructType\Real_PropertyType $cloudCoverPercentage = null, \StructType\MD_Identifier_PropertyType $processingLevelCode = null, \StructType\Integer_PropertyType $compressionGenerationQuantity = null, \StructType\Boolean_PropertyType $triangulationIndicator = null, \StructType\Boolean_PropertyType $radiometricCalibrationDataAvailability = null, \StructType\Boolean_PropertyType $cameraCalibrationInformationAvailability = null, \StructType\Boolean_PropertyType $filmDistortionInformationAvailability = null, \StructType\Boolean_PropertyType $lensDistortionInformationAvailability = null)
    {
        $this
            ->setIlluminationElevationAngle($illuminationElevationAngle)
            ->setIlluminationAzimuthAngle($illuminationAzimuthAngle)
            ->setImagingCondition($imagingCondition)
            ->setImageQualityCode($imageQualityCode)
            ->setCloudCoverPercentage($cloudCoverPercentage)
            ->setProcessingLevelCode($processingLevelCode)
            ->setCompressionGenerationQuantity($compressionGenerationQuantity)
            ->setTriangulationIndicator($triangulationIndicator)
            ->setRadiometricCalibrationDataAvailability($radiometricCalibrationDataAvailability)
            ->setCameraCalibrationInformationAvailability($cameraCalibrationInformationAvailability)
            ->setFilmDistortionInformationAvailability($filmDistortionInformationAvailability)
            ->setLensDistortionInformationAvailability($lensDistortionInformationAvailability);
    }
    /**
     * Get illuminationElevationAngle value
     * @return \StructType\Real_PropertyType|null
     */
    public function getIlluminationElevationAngle()
    {
        return $this->illuminationElevationAngle;
    }
    /**
     * Set illuminationElevationAngle value
     * @param \StructType\Real_PropertyType $illuminationElevationAngle
     * @return \StructType\MD_ImageDescription_Type
     */
    public function setIlluminationElevationAngle(\StructType\Real_PropertyType $illuminationElevationAngle = null)
    {
        $this->illuminationElevationAngle = $illuminationElevationAngle;
        return $this;
    }
    /**
     * Get illuminationAzimuthAngle value
     * @return \StructType\Real_PropertyType|null
     */
    public function getIlluminationAzimuthAngle()
    {
        return $this->illuminationAzimuthAngle;
    }
    /**
     * Set illuminationAzimuthAngle value
     * @param \StructType\Real_PropertyType $illuminationAzimuthAngle
     * @return \StructType\MD_ImageDescription_Type
     */
    public function setIlluminationAzimuthAngle(\StructType\Real_PropertyType $illuminationAzimuthAngle = null)
    {
        $this->illuminationAzimuthAngle = $illuminationAzimuthAngle;
        return $this;
    }
    /**
     * Get imagingCondition value
     * @return \StructType\MD_ImagingConditionCode_PropertyType|null
     */
    public function getImagingCondition()
    {
        return $this->imagingCondition;
    }
    /**
     * Set imagingCondition value
     * @param \StructType\MD_ImagingConditionCode_PropertyType $imagingCondition
     * @return \StructType\MD_ImageDescription_Type
     */
    public function setImagingCondition(\StructType\MD_ImagingConditionCode_PropertyType $imagingCondition = null)
    {
        $this->imagingCondition = $imagingCondition;
        return $this;
    }
    /**
     * Get imageQualityCode value
     * @return \StructType\MD_Identifier_PropertyType|null
     */
    public function getImageQualityCode()
    {
        return $this->imageQualityCode;
    }
    /**
     * Set imageQualityCode value
     * @param \StructType\MD_Identifier_PropertyType $imageQualityCode
     * @return \StructType\MD_ImageDescription_Type
     */
    public function setImageQualityCode(\StructType\MD_Identifier_PropertyType $imageQualityCode = null)
    {
        $this->imageQualityCode = $imageQualityCode;
        return $this;
    }
    /**
     * Get cloudCoverPercentage value
     * @return \StructType\Real_PropertyType|null
     */
    public function getCloudCoverPercentage()
    {
        return $this->cloudCoverPercentage;
    }
    /**
     * Set cloudCoverPercentage value
     * @param \StructType\Real_PropertyType $cloudCoverPercentage
     * @return \StructType\MD_ImageDescription_Type
     */
    public function setCloudCoverPercentage(\StructType\Real_PropertyType $cloudCoverPercentage = null)
    {
        $this->cloudCoverPercentage = $cloudCoverPercentage;
        return $this;
    }
    /**
     * Get processingLevelCode value
     * @return \StructType\MD_Identifier_PropertyType|null
     */
    public function getProcessingLevelCode()
    {
        return $this->processingLevelCode;
    }
    /**
     * Set processingLevelCode value
     * @param \StructType\MD_Identifier_PropertyType $processingLevelCode
     * @return \StructType\MD_ImageDescription_Type
     */
    public function setProcessingLevelCode(\StructType\MD_Identifier_PropertyType $processingLevelCode = null)
    {
        $this->processingLevelCode = $processingLevelCode;
        return $this;
    }
    /**
     * Get compressionGenerationQuantity value
     * @return \StructType\Integer_PropertyType|null
     */
    public function getCompressionGenerationQuantity()
    {
        return $this->compressionGenerationQuantity;
    }
    /**
     * Set compressionGenerationQuantity value
     * @param \StructType\Integer_PropertyType $compressionGenerationQuantity
     * @return \StructType\MD_ImageDescription_Type
     */
    public function setCompressionGenerationQuantity(\StructType\Integer_PropertyType $compressionGenerationQuantity = null)
    {
        $this->compressionGenerationQuantity = $compressionGenerationQuantity;
        return $this;
    }
    /**
     * Get triangulationIndicator value
     * @return \StructType\Boolean_PropertyType|null
     */
    public function getTriangulationIndicator()
    {
        return $this->triangulationIndicator;
    }
    /**
     * Set triangulationIndicator value
     * @param \StructType\Boolean_PropertyType $triangulationIndicator
     * @return \StructType\MD_ImageDescription_Type
     */
    public function setTriangulationIndicator(\StructType\Boolean_PropertyType $triangulationIndicator = null)
    {
        $this->triangulationIndicator = $triangulationIndicator;
        return $this;
    }
    /**
     * Get radiometricCalibrationDataAvailability value
     * @return \StructType\Boolean_PropertyType|null
     */
    public function getRadiometricCalibrationDataAvailability()
    {
        return $this->radiometricCalibrationDataAvailability;
    }
    /**
     * Set radiometricCalibrationDataAvailability value
     * @param \StructType\Boolean_PropertyType $radiometricCalibrationDataAvailability
     * @return \StructType\MD_ImageDescription_Type
     */
    public function setRadiometricCalibrationDataAvailability(\StructType\Boolean_PropertyType $radiometricCalibrationDataAvailability = null)
    {
        $this->radiometricCalibrationDataAvailability = $radiometricCalibrationDataAvailability;
        return $this;
    }
    /**
     * Get cameraCalibrationInformationAvailability value
     * @return \StructType\Boolean_PropertyType|null
     */
    public function getCameraCalibrationInformationAvailability()
    {
        return $this->cameraCalibrationInformationAvailability;
    }
    /**
     * Set cameraCalibrationInformationAvailability value
     * @param \StructType\Boolean_PropertyType $cameraCalibrationInformationAvailability
     * @return \StructType\MD_ImageDescription_Type
     */
    public function setCameraCalibrationInformationAvailability(\StructType\Boolean_PropertyType $cameraCalibrationInformationAvailability = null)
    {
        $this->cameraCalibrationInformationAvailability = $cameraCalibrationInformationAvailability;
        return $this;
    }
    /**
     * Get filmDistortionInformationAvailability value
     * @return \StructType\Boolean_PropertyType|null
     */
    public function getFilmDistortionInformationAvailability()
    {
        return $this->filmDistortionInformationAvailability;
    }
    /**
     * Set filmDistortionInformationAvailability value
     * @param \StructType\Boolean_PropertyType $filmDistortionInformationAvailability
     * @return \StructType\MD_ImageDescription_Type
     */
    public function setFilmDistortionInformationAvailability(\StructType\Boolean_PropertyType $filmDistortionInformationAvailability = null)
    {
        $this->filmDistortionInformationAvailability = $filmDistortionInformationAvailability;
        return $this;
    }
    /**
     * Get lensDistortionInformationAvailability value
     * @return \StructType\Boolean_PropertyType|null
     */
    public function getLensDistortionInformationAvailability()
    {
        return $this->lensDistortionInformationAvailability;
    }
    /**
     * Set lensDistortionInformationAvailability value
     * @param \StructType\Boolean_PropertyType $lensDistortionInformationAvailability
     * @return \StructType\MD_ImageDescription_Type
     */
    public function setLensDistortionInformationAvailability(\StructType\Boolean_PropertyType $lensDistortionInformationAvailability = null)
    {
        $this->lensDistortionInformationAvailability = $lensDistortionInformationAvailability;
        return $this;
    }
}
