<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MD_Identifier_Type StructType
 * @subpackage Structs
 */
class MD_Identifier_Type extends AbstractStructBase
{
    /**
     * The authority
     * @var \StructType\CI_Citation_PropertyType
     */
    public $authority;
    /**
     * The code
     * @var \StructType\CharacterString_PropertyType
     */
    public $code;
    /**
     * Constructor method for MD_Identifier_Type
     * @uses MD_Identifier_Type::setAuthority()
     * @uses MD_Identifier_Type::setCode()
     * @param \StructType\CI_Citation_PropertyType $authority
     * @param \StructType\CharacterString_PropertyType $code
     */
    public function __construct(\StructType\CI_Citation_PropertyType $authority = null, \StructType\CharacterString_PropertyType $code = null)
    {
        $this
            ->setAuthority($authority)
            ->setCode($code);
    }
    /**
     * Get authority value
     * @return \StructType\CI_Citation_PropertyType|null
     */
    public function getAuthority()
    {
        return $this->authority;
    }
    /**
     * Set authority value
     * @param \StructType\CI_Citation_PropertyType $authority
     * @return \StructType\MD_Identifier_Type
     */
    public function setAuthority(\StructType\CI_Citation_PropertyType $authority = null)
    {
        $this->authority = $authority;
        return $this;
    }
    /**
     * Get code value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param \StructType\CharacterString_PropertyType $code
     * @return \StructType\MD_Identifier_Type
     */
    public function setCode(\StructType\CharacterString_PropertyType $code = null)
    {
        $this->code = $code;
        return $this;
    }
}
