<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for locatorType StructType
 * @subpackage Structs
 */
class LocatorType extends AbstractStructBase
{
    /**
     * The title
     * @var \StructType\TitleEltType
     */
    public $title;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The href
     * @var string
     */
    public $href;
    /**
     * The role
     * @var string
     */
    public $role;
    /**
     * The label
     * @var string
     */
    public $label;
    /**
     * Constructor method for locatorType
     * @uses LocatorType::setTitle()
     * @uses LocatorType::setType()
     * @uses LocatorType::setHref()
     * @uses LocatorType::setRole()
     * @uses LocatorType::setLabel()
     * @param \StructType\TitleEltType $title
     * @param string $type
     * @param string $href
     * @param string $role
     * @param string $label
     */
    public function __construct(\StructType\TitleEltType $title = null, $type = null, $href = null, $role = null, $label = null)
    {
        $this
            ->setTitle($title)
            ->setType($type)
            ->setHref($href)
            ->setRole($role)
            ->setLabel($label);
    }
    /**
     * Get title value
     * @return \StructType\TitleEltType|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param \StructType\TitleEltType $title
     * @return \StructType\LocatorType
     */
    public function setTitle(\StructType\TitleEltType $title = null)
    {
        $this->title = $title;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\LocatorType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get href value
     * @return string|null
     */
    public function getHref()
    {
        return $this->href;
    }
    /**
     * Set href value
     * @param string $href
     * @return \StructType\LocatorType
     */
    public function setHref($href = null)
    {
        // validation for constraint: string
        if (!is_null($href) && !is_string($href)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($href, true), gettype($href)), __LINE__);
        }
        $this->href = $href;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @param string $role
     * @return \StructType\LocatorType
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\LocatorType
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
}
