<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LeistungsverrichtungAuswahl StructType
 * Meta information extracted from the WSDL
 * - documentation: Auswahl der Verrichtung. Entweder die Verrichtungskennung des LeiKa oder eine eigene individuelle Verrichtung.
 * @subpackage Structs
 */
class LeistungsverrichtungAuswahl extends AbstractStructBase
{
    /**
     * The verrichtungLeiKa
     * Meta information extracted from the WSDL
     * - documentation: Code der Verrichtung dieser Leistung.
     * - choice: verrichtungLeiKa | verrichtungIndividuell
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Code_LeiKaVerrichtungskennung
     */
    public $verrichtungLeiKa;
    /**
     * The verrichtungIndividuell
     * Meta information extracted from the WSDL
     * - documentation: Individuelle Verrichtung. Wird durch Leistungskategorien mit entsprechender Leistungskategorieklasse abgebildet.
     * - choice: verrichtungLeiKa | verrichtungIndividuell
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Leistungskategorie
     */
    public $verrichtungIndividuell;
    /**
     * Constructor method for LeistungsverrichtungAuswahl
     * @uses LeistungsverrichtungAuswahl::setVerrichtungLeiKa()
     * @uses LeistungsverrichtungAuswahl::setVerrichtungIndividuell()
     * @param \StructType\Code_LeiKaVerrichtungskennung $verrichtungLeiKa
     * @param \StructType\Leistungskategorie $verrichtungIndividuell
     */
    public function __construct(\StructType\Code_LeiKaVerrichtungskennung $verrichtungLeiKa = null, \StructType\Leistungskategorie $verrichtungIndividuell = null)
    {
        $this
            ->setVerrichtungLeiKa($verrichtungLeiKa)
            ->setVerrichtungIndividuell($verrichtungIndividuell);
    }
    /**
     * Get verrichtungLeiKa value
     * @return \StructType\Code_LeiKaVerrichtungskennung|null
     */
    public function getVerrichtungLeiKa()
    {
        return isset($this->verrichtungLeiKa) ? $this->verrichtungLeiKa : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVerrichtungLeiKa method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerrichtungLeiKa method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVerrichtungLeiKaForChoiceConstraintsFromSetVerrichtungLeiKa($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'verrichtungIndividuell',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property verrichtungLeiKa can\'t be set as the property %s is already set. Only one property must be set among these properties: verrichtungLeiKa, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set verrichtungLeiKa value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Code_LeiKaVerrichtungskennung $verrichtungLeiKa
     * @return \StructType\LeistungsverrichtungAuswahl
     */
    public function setVerrichtungLeiKa(\StructType\Code_LeiKaVerrichtungskennung $verrichtungLeiKa = null)
    {
        // validation for constraint: choice(verrichtungLeiKa, verrichtungIndividuell)
        if ('' !== ($verrichtungLeiKaChoiceErrorMessage = self::validateVerrichtungLeiKaForChoiceConstraintsFromSetVerrichtungLeiKa($verrichtungLeiKa))) {
            throw new \InvalidArgumentException($verrichtungLeiKaChoiceErrorMessage, __LINE__);
        }
        if (is_null($verrichtungLeiKa) || (is_array($verrichtungLeiKa) && empty($verrichtungLeiKa))) {
            unset($this->verrichtungLeiKa);
        } else {
            $this->verrichtungLeiKa = $verrichtungLeiKa;
        }
        return $this;
    }
    /**
     * Get verrichtungIndividuell value
     * @return \StructType\Leistungskategorie|null
     */
    public function getVerrichtungIndividuell()
    {
        return isset($this->verrichtungIndividuell) ? $this->verrichtungIndividuell : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVerrichtungIndividuell method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerrichtungIndividuell method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVerrichtungIndividuellForChoiceConstraintsFromSetVerrichtungIndividuell($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'verrichtungLeiKa',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property verrichtungIndividuell can\'t be set as the property %s is already set. Only one property must be set among these properties: verrichtungIndividuell, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set verrichtungIndividuell value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Leistungskategorie $verrichtungIndividuell
     * @return \StructType\LeistungsverrichtungAuswahl
     */
    public function setVerrichtungIndividuell(\StructType\Leistungskategorie $verrichtungIndividuell = null)
    {
        // validation for constraint: choice(verrichtungLeiKa, verrichtungIndividuell)
        if ('' !== ($verrichtungIndividuellChoiceErrorMessage = self::validateVerrichtungIndividuellForChoiceConstraintsFromSetVerrichtungIndividuell($verrichtungIndividuell))) {
            throw new \InvalidArgumentException($verrichtungIndividuellChoiceErrorMessage, __LINE__);
        }
        if (is_null($verrichtungIndividuell) || (is_array($verrichtungIndividuell) && empty($verrichtungIndividuell))) {
            unset($this->verrichtungIndividuell);
        } else {
            $this->verrichtungIndividuell = $verrichtungIndividuell;
        }
        return $this;
    }
}
