<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Leistung StructType
 * Meta information extracted from the WSDL
 * - documentation: Leistung ist der Datentyp für Verwaltungsdienstleistungen und folgt dem Modell für Leistungen gemäß LeiKa. Die modulare Leistungsstruktur spiegelt sich in den Elementen wieder. Es können somit alle Leistungsmodule nach LeiKa
 * abgebildet werden. Außerdem wird die Struktur der Leistung (Leistungsobjekt, mit Verrichtung, und Verrichtungsdetail) ermöglicht.Neben den Modulen gemäß LeiKa können auch individuelle Module verwendet werden (TextIndividuell oder die
 * relevantFuer-Werte).
 * @subpackage Structs
 */
class Leistung extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Primäre ID. Hier kann insbesondere der LeiKa-Schlüssel angegeben werden.
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The idSekundaer
     * Meta information extracted from the WSDL
     * - documentation: Sekundäre IDs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $idSekundaer;
    /**
     * The struktur
     * Meta information extracted from the WSDL
     * - documentation: Angabe der Struktur der Leistung gemäß LeiKa. Eine Leistung ist entweder Leistungsobjekt (LO), Leistungsobjekt mit Verrichtung (LOV) oder Leistungsobjekt mit Verrichtung und Detail (LOVD).Folgt die Leistung nicht dieser Struktur
     * bzw. ist eine reine Auskunftsleistung, wird dieses Attribut nicht gesetzt.
     * - minOccurs: 0
     * @var \StructType\Leistungsstruktur
     */
    public $struktur;
    /**
     * The referenzLeiKa
     * Meta information extracted from the WSDL
     * - documentation: Referenz auf inhaltlich entsprechende Leistungen aus Leika mittels LeiKa-Schlüssel.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Code_LeiKaLeistung[]
     */
    public $referenzLeiKa;
    /**
     * The modulText
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Modulen, welche nur Text enthalten.Ein Textmodul soll pro Leistung maximal nur einmal pro Typ/Code hinzugefügt werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Textmodul[]
     */
    public $modulText;
    /**
     * The modulTextIndividuell
     * Meta information extracted from the WSDL
     * - documentation: Individuelle Textmodule zusätzlich zu denen des LeiKa.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TextmodulIndividuell[]
     */
    public $modulTextIndividuell;
    /**
     * The modulFrist
     * Meta information extracted from the WSDL
     * - documentation: Angabe des Moduls für Fristen.
     * - minOccurs: 0
     * @var \StructType\Fristmodul
     */
    public $modulFrist;
    /**
     * The modulKosten
     * Meta information extracted from the WSDL
     * - documentation: Angabe des Moduls für Kosten bzw. Gebühren.
     * - minOccurs: 0
     * @var \StructType\Kostenmodul
     */
    public $modulKosten;
    /**
     * The modulBearbeitungsdauer
     * Meta information extracted from the WSDL
     * - documentation: Modul zur Information über die Bearbeitungsdauer.
     * - minOccurs: 0
     * @var \StructType\Bearbeitungsdauermodul
     */
    public $modulBearbeitungsdauer;
    /**
     * The modulBegriffImKontext
     * Meta information extracted from the WSDL
     * - documentation: Modul zum Hinzufügen von Begriffen im Kontext.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BegriffImKontextModul[]
     */
    public $modulBegriffImKontext;
    /**
     * The modulFachlicheFreigabe
     * Meta information extracted from the WSDL
     * - documentation: Modul für Information zur fachlichen Freigabe.
     * - minOccurs: 0
     * @var \StructType\FachlicheFreigabeModul
     */
    public $modulFachlicheFreigabe;
    /**
     * The modulAuskunftshinweis
     * Meta information extracted from the WSDL
     * - documentation: Angaben für Servicecenter-Agenten zur Leistung. Achtung: Diese Angaben dürfen öffentlich nicht dargestellt werden.
     * - minOccurs: 0
     * @var \StructType\Auskunftshinweismodul
     */
    public $modulAuskunftshinweis;
    /**
     * The modulDokument
     * Meta information extracted from the WSDL
     * - documentation: Im Verfahrensablauf der Leistung beizubringende oder hervorgehende Dokumente.
     * - minOccurs: 0
     * @var \StructType\Dokumentmodul
     */
    public $modulDokument;
    /**
     * The modulUrsprungsportal
     * Meta information extracted from the WSDL
     * - documentation: Information zur Ansicht der Leistung im Ursprungsportal bzw. -system.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UrsprungsportalModul[]
     */
    public $modulUrsprungsportal;
    /**
     * The typisierung
     * Meta information extracted from the WSDL
     * - documentation: Angabe der Typsierung einer Leistung nach LeiKa.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Code_LeiKaTypisierung[]
     */
    public $typisierung;
    /**
     * The vertrauensniveau
     * Meta information extracted from the WSDL
     * - documentation: Angabe des Vertrauensniveaus nach eIDAS-Verordnung.
     * - minOccurs: 0
     * @var \StructType\Code_Vertrauensniveau
     */
    public $vertrauensniveau;
    /**
     * The leistungsadressat
     * Meta information extracted from the WSDL
     * - documentation: Angabe des Adressats einer Leistung. Diese Gruppen können die Leistung in Anspruch nehmen. Zum Beispiel Bürger oder Unternehmen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Code_Leistungsadressat[]
     */
    public $leistungsadressat;
    /**
     * The kennzeichenSchriftformerfordernis
     * Meta information extracted from the WSDL
     * - documentation: Gibt an, ob für die Leistung das Schriftformerfordernis gilt. D.h. eine eigenhändige Unterschrift geleistet werden muss.
     * - minOccurs: 0
     * @var bool
     */
    public $kennzeichenSchriftformerfordernis;
    /**
     * The kategorie
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete Kategorien, z.B. KGSt-Produktplan. Das komplette Ordnungssystem kann - muss aber nicht - über die Nachricht leistungen.antwort.leistungskategorie.xxxx übermittelt werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Leistungskategorie[]
     */
    public $kategorie;
    /**
     * The klassifizierung
     * Meta information extracted from the WSDL
     * - documentation: Zuordnung von eigenen/benutzerdefinierten Codes für die Klassifizierung der Leistung. Dies sind Codelisten, welche nicht in XZuFi selbst definiert oder referenziert werden und auch nicht durch Leistungskategorien abgebildet werden.
     * Beispiel: KGSt-Katalog
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Code_KlassifizierungBenutzerdefiniert[]
     */
    public $klassifizierung;
    /**
     * The informationsbereichSDG
     * Meta information extracted from the WSDL
     * - documentation: Zuordnung der SDG Informationsbereiche, die für Bürger und Unternehmen relevant sind, die ihre Binnenmarktrechte ausüben.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Code_SDGInformationsbereich[]
     */
    public $informationsbereichSDG;
    /**
     * The idLeistungImKontext
     * Meta information extracted from the WSDL
     * - documentation: Identifkatoren von Leistungen, welche für diese Leistung relevant sind bzw. im selben Kontext stehen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $idLeistungImKontext;
    /**
     * The idProzess
     * Meta information extracted from the WSDL
     * - documentation: Optionale Zuordnung von Prozessen, in welchem die Leistung Verwendung findet. Prozesse selbst werden nicht in XZuFi abgebildet. Es können die IDs von Prozessen angegeben werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $idProzess;
    /**
     * The herausgeber
     * Meta information extracted from the WSDL
     * - documentation: Optionale Angabe des Herausgebers der Daten.
     * - minOccurs: 0
     * @var \StructType\Herausgeber
     */
    public $herausgeber;
    /**
     * The gueltigkeitGebietID
     * Meta information extracted from the WSDL
     * - documentation: Gibt an, für welche Gebiete der Inhalt der Leistung gültig ist. Für bundesland-weite Versionen einer Leistung die ID des Gebiets des Bundeslandes. Für untergeordnete Gebiete (z.B.Städte) dann die IDs der entsprechenden Gebiete.
     * Es soll vermieden werden, hier kein Gebiet anzugeben. Wenn dies der Fall sein sollte, wird eine globale Gültigkeit in einem zu vereinbarendem Kontext definiert.Wichtig: Es handelt sich hierbei nicht um eine Definition der Zuständigkeit!
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $gueltigkeitGebietID;
    /**
     * The kennzeichenEA
     * Meta information extracted from the WSDL
     * - documentation: Kennzeichen, ob das Verfahren führbar über eine einheitliche Stelle ist.
     * - minOccurs: 0
     * @var bool
     */
    public $kennzeichenEA;
    /**
     * The relevantFuerWirtschaftszweig
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete Wirtschaftszweige, für welche die Leistung Relevanz besitzt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Wirtschaftszweig_Spezifizierbar[]
     */
    public $relevantFuerWirtschaftszweig;
    /**
     * The relevantFuerRechtsform
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete Rechtsformen, für welche die Leistung Relevanz besitzt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Code_Rechtsform[]
     */
    public $relevantFuerRechtsform;
    /**
     * The relevantFuerStaatsangehoerigkeit
     * Meta information extracted from the WSDL
     * - documentation: Zugeordnete Staatsangehörigkeiten, für welche die Leistung Relevanz besitzt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Code_StaatsangehoerigkeitDestatis[]
     */
    public $relevantFuerStaatsangehoerigkeit;
    /**
     * The versionsinformation
     * Meta information extracted from the WSDL
     * - documentation: Informationen zur Versionierung.
     * - minOccurs: 0
     * @var \StructType\Versionsinformation
     */
    public $versionsinformation;
    /**
     * The sprachversion
     * Meta information extracted from the WSDL
     * - documentation: Angabe aller verfügbaren Sprachversionen des Objekts.
     * - maxOccurs: unbounded
     * @var \StructType\Sprachversion[]
     */
    public $sprachversion;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen die Leistung gültig ist. Zeiträume können nacheinander liegen oder sich überschneiden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * Constructor method for Leistung
     * @uses Leistung::setId()
     * @uses Leistung::setIdSekundaer()
     * @uses Leistung::setStruktur()
     * @uses Leistung::setReferenzLeiKa()
     * @uses Leistung::setModulText()
     * @uses Leistung::setModulTextIndividuell()
     * @uses Leistung::setModulFrist()
     * @uses Leistung::setModulKosten()
     * @uses Leistung::setModulBearbeitungsdauer()
     * @uses Leistung::setModulBegriffImKontext()
     * @uses Leistung::setModulFachlicheFreigabe()
     * @uses Leistung::setModulAuskunftshinweis()
     * @uses Leistung::setModulDokument()
     * @uses Leistung::setModulUrsprungsportal()
     * @uses Leistung::setTypisierung()
     * @uses Leistung::setVertrauensniveau()
     * @uses Leistung::setLeistungsadressat()
     * @uses Leistung::setKennzeichenSchriftformerfordernis()
     * @uses Leistung::setKategorie()
     * @uses Leistung::setKlassifizierung()
     * @uses Leistung::setInformationsbereichSDG()
     * @uses Leistung::setIdLeistungImKontext()
     * @uses Leistung::setIdProzess()
     * @uses Leistung::setHerausgeber()
     * @uses Leistung::setGueltigkeitGebietID()
     * @uses Leistung::setKennzeichenEA()
     * @uses Leistung::setRelevantFuerWirtschaftszweig()
     * @uses Leistung::setRelevantFuerRechtsform()
     * @uses Leistung::setRelevantFuerStaatsangehoerigkeit()
     * @uses Leistung::setVersionsinformation()
     * @uses Leistung::setSprachversion()
     * @uses Leistung::setGueltigkeit()
     * @param \StructType\Identifikator $id
     * @param \StructType\Identifikator[] $idSekundaer
     * @param \StructType\Leistungsstruktur $struktur
     * @param \StructType\Code_LeiKaLeistung[] $referenzLeiKa
     * @param \StructType\Textmodul[] $modulText
     * @param \StructType\TextmodulIndividuell[] $modulTextIndividuell
     * @param \StructType\Fristmodul $modulFrist
     * @param \StructType\Kostenmodul $modulKosten
     * @param \StructType\Bearbeitungsdauermodul $modulBearbeitungsdauer
     * @param \StructType\BegriffImKontextModul[] $modulBegriffImKontext
     * @param \StructType\FachlicheFreigabeModul $modulFachlicheFreigabe
     * @param \StructType\Auskunftshinweismodul $modulAuskunftshinweis
     * @param \StructType\Dokumentmodul $modulDokument
     * @param \StructType\UrsprungsportalModul[] $modulUrsprungsportal
     * @param \StructType\Code_LeiKaTypisierung[] $typisierung
     * @param \StructType\Code_Vertrauensniveau $vertrauensniveau
     * @param \StructType\Code_Leistungsadressat[] $leistungsadressat
     * @param bool $kennzeichenSchriftformerfordernis
     * @param \StructType\Leistungskategorie[] $kategorie
     * @param \StructType\Code_KlassifizierungBenutzerdefiniert[] $klassifizierung
     * @param \StructType\Code_SDGInformationsbereich[] $informationsbereichSDG
     * @param \StructType\Identifikator[] $idLeistungImKontext
     * @param \StructType\Identifikator[] $idProzess
     * @param \StructType\Herausgeber $herausgeber
     * @param \StructType\Identifikator[] $gueltigkeitGebietID
     * @param bool $kennzeichenEA
     * @param \StructType\Wirtschaftszweig_Spezifizierbar[] $relevantFuerWirtschaftszweig
     * @param \StructType\Code_Rechtsform[] $relevantFuerRechtsform
     * @param \StructType\Code_StaatsangehoerigkeitDestatis[] $relevantFuerStaatsangehoerigkeit
     * @param \StructType\Versionsinformation $versionsinformation
     * @param \StructType\Sprachversion[] $sprachversion
     * @param \StructType\Zeitraum[] $gueltigkeit
     */
    public function __construct(\StructType\Identifikator $id = null, array $idSekundaer = array(), \StructType\Leistungsstruktur $struktur = null, array $referenzLeiKa = array(), array $modulText = array(), array $modulTextIndividuell = array(), \StructType\Fristmodul $modulFrist = null, \StructType\Kostenmodul $modulKosten = null, \StructType\Bearbeitungsdauermodul $modulBearbeitungsdauer = null, array $modulBegriffImKontext = array(), \StructType\FachlicheFreigabeModul $modulFachlicheFreigabe = null, \StructType\Auskunftshinweismodul $modulAuskunftshinweis = null, \StructType\Dokumentmodul $modulDokument = null, array $modulUrsprungsportal = array(), array $typisierung = array(), \StructType\Code_Vertrauensniveau $vertrauensniveau = null, array $leistungsadressat = array(), $kennzeichenSchriftformerfordernis = null, array $kategorie = array(), array $klassifizierung = array(), array $informationsbereichSDG = array(), array $idLeistungImKontext = array(), array $idProzess = array(), \StructType\Herausgeber $herausgeber = null, array $gueltigkeitGebietID = array(), $kennzeichenEA = null, array $relevantFuerWirtschaftszweig = array(), array $relevantFuerRechtsform = array(), array $relevantFuerStaatsangehoerigkeit = array(), \StructType\Versionsinformation $versionsinformation = null, array $sprachversion = array(), array $gueltigkeit = array())
    {
        $this
            ->setId($id)
            ->setIdSekundaer($idSekundaer)
            ->setStruktur($struktur)
            ->setReferenzLeiKa($referenzLeiKa)
            ->setModulText($modulText)
            ->setModulTextIndividuell($modulTextIndividuell)
            ->setModulFrist($modulFrist)
            ->setModulKosten($modulKosten)
            ->setModulBearbeitungsdauer($modulBearbeitungsdauer)
            ->setModulBegriffImKontext($modulBegriffImKontext)
            ->setModulFachlicheFreigabe($modulFachlicheFreigabe)
            ->setModulAuskunftshinweis($modulAuskunftshinweis)
            ->setModulDokument($modulDokument)
            ->setModulUrsprungsportal($modulUrsprungsportal)
            ->setTypisierung($typisierung)
            ->setVertrauensniveau($vertrauensniveau)
            ->setLeistungsadressat($leistungsadressat)
            ->setKennzeichenSchriftformerfordernis($kennzeichenSchriftformerfordernis)
            ->setKategorie($kategorie)
            ->setKlassifizierung($klassifizierung)
            ->setInformationsbereichSDG($informationsbereichSDG)
            ->setIdLeistungImKontext($idLeistungImKontext)
            ->setIdProzess($idProzess)
            ->setHerausgeber($herausgeber)
            ->setGueltigkeitGebietID($gueltigkeitGebietID)
            ->setKennzeichenEA($kennzeichenEA)
            ->setRelevantFuerWirtschaftszweig($relevantFuerWirtschaftszweig)
            ->setRelevantFuerRechtsform($relevantFuerRechtsform)
            ->setRelevantFuerStaatsangehoerigkeit($relevantFuerStaatsangehoerigkeit)
            ->setVersionsinformation($versionsinformation)
            ->setSprachversion($sprachversion)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\Leistung
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get idSekundaer value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdSekundaer()
    {
        return $this->idSekundaer;
    }
    /**
     * This method is responsible for validating the values passed to the setIdSekundaer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdSekundaer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdSekundaerForArrayConstraintsFromSetIdSekundaer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungIdSekundaerItem) {
            // validation for constraint: itemType
            if (!$leistungIdSekundaerItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($leistungIdSekundaerItem) ? get_class($leistungIdSekundaerItem) : sprintf('%s(%s)', gettype($leistungIdSekundaerItem), var_export($leistungIdSekundaerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idSekundaer
     * @return \StructType\Leistung
     */
    public function setIdSekundaer(array $idSekundaer = array())
    {
        // validation for constraint: array
        if ('' !== ($idSekundaerArrayErrorMessage = self::validateIdSekundaerForArrayConstraintsFromSetIdSekundaer($idSekundaer))) {
            throw new \InvalidArgumentException($idSekundaerArrayErrorMessage, __LINE__);
        }
        $this->idSekundaer = $idSekundaer;
        return $this;
    }
    /**
     * Add item to idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Leistung
     */
    public function addToIdSekundaer(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idSekundaer[] = $item;
        return $this;
    }
    /**
     * Get struktur value
     * @return \StructType\Leistungsstruktur|null
     */
    public function getStruktur()
    {
        return $this->struktur;
    }
    /**
     * Set struktur value
     * @param \StructType\Leistungsstruktur $struktur
     * @return \StructType\Leistung
     */
    public function setStruktur(\StructType\Leistungsstruktur $struktur = null)
    {
        $this->struktur = $struktur;
        return $this;
    }
    /**
     * Get referenzLeiKa value
     * @return \StructType\Code_LeiKaLeistung[]|null
     */
    public function getReferenzLeiKa()
    {
        return $this->referenzLeiKa;
    }
    /**
     * This method is responsible for validating the values passed to the setReferenzLeiKa method
     * This method is willingly generated in order to preserve the one-line inline validation within the setReferenzLeiKa method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateReferenzLeiKaForArrayConstraintsFromSetReferenzLeiKa(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungReferenzLeiKaItem) {
            // validation for constraint: itemType
            if (!$leistungReferenzLeiKaItem instanceof \StructType\Code_LeiKaLeistung) {
                $invalidValues[] = is_object($leistungReferenzLeiKaItem) ? get_class($leistungReferenzLeiKaItem) : sprintf('%s(%s)', gettype($leistungReferenzLeiKaItem), var_export($leistungReferenzLeiKaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The referenzLeiKa property can only contain items of type \StructType\Code_LeiKaLeistung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set referenzLeiKa value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_LeiKaLeistung[] $referenzLeiKa
     * @return \StructType\Leistung
     */
    public function setReferenzLeiKa(array $referenzLeiKa = array())
    {
        // validation for constraint: array
        if ('' !== ($referenzLeiKaArrayErrorMessage = self::validateReferenzLeiKaForArrayConstraintsFromSetReferenzLeiKa($referenzLeiKa))) {
            throw new \InvalidArgumentException($referenzLeiKaArrayErrorMessage, __LINE__);
        }
        $this->referenzLeiKa = $referenzLeiKa;
        return $this;
    }
    /**
     * Add item to referenzLeiKa value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_LeiKaLeistung $item
     * @return \StructType\Leistung
     */
    public function addToReferenzLeiKa(\StructType\Code_LeiKaLeistung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Code_LeiKaLeistung) {
            throw new \InvalidArgumentException(sprintf('The referenzLeiKa property can only contain items of type \StructType\Code_LeiKaLeistung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->referenzLeiKa[] = $item;
        return $this;
    }
    /**
     * Get modulText value
     * @return \StructType\Textmodul[]|null
     */
    public function getModulText()
    {
        return $this->modulText;
    }
    /**
     * This method is responsible for validating the values passed to the setModulText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setModulText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateModulTextForArrayConstraintsFromSetModulText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungModulTextItem) {
            // validation for constraint: itemType
            if (!$leistungModulTextItem instanceof \StructType\Textmodul) {
                $invalidValues[] = is_object($leistungModulTextItem) ? get_class($leistungModulTextItem) : sprintf('%s(%s)', gettype($leistungModulTextItem), var_export($leistungModulTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The modulText property can only contain items of type \StructType\Textmodul, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set modulText value
     * @throws \InvalidArgumentException
     * @param \StructType\Textmodul[] $modulText
     * @return \StructType\Leistung
     */
    public function setModulText(array $modulText = array())
    {
        // validation for constraint: array
        if ('' !== ($modulTextArrayErrorMessage = self::validateModulTextForArrayConstraintsFromSetModulText($modulText))) {
            throw new \InvalidArgumentException($modulTextArrayErrorMessage, __LINE__);
        }
        $this->modulText = $modulText;
        return $this;
    }
    /**
     * Add item to modulText value
     * @throws \InvalidArgumentException
     * @param \StructType\Textmodul $item
     * @return \StructType\Leistung
     */
    public function addToModulText(\StructType\Textmodul $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Textmodul) {
            throw new \InvalidArgumentException(sprintf('The modulText property can only contain items of type \StructType\Textmodul, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->modulText[] = $item;
        return $this;
    }
    /**
     * Get modulTextIndividuell value
     * @return \StructType\TextmodulIndividuell[]|null
     */
    public function getModulTextIndividuell()
    {
        return $this->modulTextIndividuell;
    }
    /**
     * This method is responsible for validating the values passed to the setModulTextIndividuell method
     * This method is willingly generated in order to preserve the one-line inline validation within the setModulTextIndividuell method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateModulTextIndividuellForArrayConstraintsFromSetModulTextIndividuell(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungModulTextIndividuellItem) {
            // validation for constraint: itemType
            if (!$leistungModulTextIndividuellItem instanceof \StructType\TextmodulIndividuell) {
                $invalidValues[] = is_object($leistungModulTextIndividuellItem) ? get_class($leistungModulTextIndividuellItem) : sprintf('%s(%s)', gettype($leistungModulTextIndividuellItem), var_export($leistungModulTextIndividuellItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The modulTextIndividuell property can only contain items of type \StructType\TextmodulIndividuell, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set modulTextIndividuell value
     * @throws \InvalidArgumentException
     * @param \StructType\TextmodulIndividuell[] $modulTextIndividuell
     * @return \StructType\Leistung
     */
    public function setModulTextIndividuell(array $modulTextIndividuell = array())
    {
        // validation for constraint: array
        if ('' !== ($modulTextIndividuellArrayErrorMessage = self::validateModulTextIndividuellForArrayConstraintsFromSetModulTextIndividuell($modulTextIndividuell))) {
            throw new \InvalidArgumentException($modulTextIndividuellArrayErrorMessage, __LINE__);
        }
        $this->modulTextIndividuell = $modulTextIndividuell;
        return $this;
    }
    /**
     * Add item to modulTextIndividuell value
     * @throws \InvalidArgumentException
     * @param \StructType\TextmodulIndividuell $item
     * @return \StructType\Leistung
     */
    public function addToModulTextIndividuell(\StructType\TextmodulIndividuell $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TextmodulIndividuell) {
            throw new \InvalidArgumentException(sprintf('The modulTextIndividuell property can only contain items of type \StructType\TextmodulIndividuell, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->modulTextIndividuell[] = $item;
        return $this;
    }
    /**
     * Get modulFrist value
     * @return \StructType\Fristmodul|null
     */
    public function getModulFrist()
    {
        return $this->modulFrist;
    }
    /**
     * Set modulFrist value
     * @param \StructType\Fristmodul $modulFrist
     * @return \StructType\Leistung
     */
    public function setModulFrist(\StructType\Fristmodul $modulFrist = null)
    {
        $this->modulFrist = $modulFrist;
        return $this;
    }
    /**
     * Get modulKosten value
     * @return \StructType\Kostenmodul|null
     */
    public function getModulKosten()
    {
        return $this->modulKosten;
    }
    /**
     * Set modulKosten value
     * @param \StructType\Kostenmodul $modulKosten
     * @return \StructType\Leistung
     */
    public function setModulKosten(\StructType\Kostenmodul $modulKosten = null)
    {
        $this->modulKosten = $modulKosten;
        return $this;
    }
    /**
     * Get modulBearbeitungsdauer value
     * @return \StructType\Bearbeitungsdauermodul|null
     */
    public function getModulBearbeitungsdauer()
    {
        return $this->modulBearbeitungsdauer;
    }
    /**
     * Set modulBearbeitungsdauer value
     * @param \StructType\Bearbeitungsdauermodul $modulBearbeitungsdauer
     * @return \StructType\Leistung
     */
    public function setModulBearbeitungsdauer(\StructType\Bearbeitungsdauermodul $modulBearbeitungsdauer = null)
    {
        $this->modulBearbeitungsdauer = $modulBearbeitungsdauer;
        return $this;
    }
    /**
     * Get modulBegriffImKontext value
     * @return \StructType\BegriffImKontextModul[]|null
     */
    public function getModulBegriffImKontext()
    {
        return $this->modulBegriffImKontext;
    }
    /**
     * This method is responsible for validating the values passed to the setModulBegriffImKontext method
     * This method is willingly generated in order to preserve the one-line inline validation within the setModulBegriffImKontext method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateModulBegriffImKontextForArrayConstraintsFromSetModulBegriffImKontext(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungModulBegriffImKontextItem) {
            // validation for constraint: itemType
            if (!$leistungModulBegriffImKontextItem instanceof \StructType\BegriffImKontextModul) {
                $invalidValues[] = is_object($leistungModulBegriffImKontextItem) ? get_class($leistungModulBegriffImKontextItem) : sprintf('%s(%s)', gettype($leistungModulBegriffImKontextItem), var_export($leistungModulBegriffImKontextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The modulBegriffImKontext property can only contain items of type \StructType\BegriffImKontextModul, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set modulBegriffImKontext value
     * @throws \InvalidArgumentException
     * @param \StructType\BegriffImKontextModul[] $modulBegriffImKontext
     * @return \StructType\Leistung
     */
    public function setModulBegriffImKontext(array $modulBegriffImKontext = array())
    {
        // validation for constraint: array
        if ('' !== ($modulBegriffImKontextArrayErrorMessage = self::validateModulBegriffImKontextForArrayConstraintsFromSetModulBegriffImKontext($modulBegriffImKontext))) {
            throw new \InvalidArgumentException($modulBegriffImKontextArrayErrorMessage, __LINE__);
        }
        $this->modulBegriffImKontext = $modulBegriffImKontext;
        return $this;
    }
    /**
     * Add item to modulBegriffImKontext value
     * @throws \InvalidArgumentException
     * @param \StructType\BegriffImKontextModul $item
     * @return \StructType\Leistung
     */
    public function addToModulBegriffImKontext(\StructType\BegriffImKontextModul $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BegriffImKontextModul) {
            throw new \InvalidArgumentException(sprintf('The modulBegriffImKontext property can only contain items of type \StructType\BegriffImKontextModul, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->modulBegriffImKontext[] = $item;
        return $this;
    }
    /**
     * Get modulFachlicheFreigabe value
     * @return \StructType\FachlicheFreigabeModul|null
     */
    public function getModulFachlicheFreigabe()
    {
        return $this->modulFachlicheFreigabe;
    }
    /**
     * Set modulFachlicheFreigabe value
     * @param \StructType\FachlicheFreigabeModul $modulFachlicheFreigabe
     * @return \StructType\Leistung
     */
    public function setModulFachlicheFreigabe(\StructType\FachlicheFreigabeModul $modulFachlicheFreigabe = null)
    {
        $this->modulFachlicheFreigabe = $modulFachlicheFreigabe;
        return $this;
    }
    /**
     * Get modulAuskunftshinweis value
     * @return \StructType\Auskunftshinweismodul|null
     */
    public function getModulAuskunftshinweis()
    {
        return $this->modulAuskunftshinweis;
    }
    /**
     * Set modulAuskunftshinweis value
     * @param \StructType\Auskunftshinweismodul $modulAuskunftshinweis
     * @return \StructType\Leistung
     */
    public function setModulAuskunftshinweis(\StructType\Auskunftshinweismodul $modulAuskunftshinweis = null)
    {
        $this->modulAuskunftshinweis = $modulAuskunftshinweis;
        return $this;
    }
    /**
     * Get modulDokument value
     * @return \StructType\Dokumentmodul|null
     */
    public function getModulDokument()
    {
        return $this->modulDokument;
    }
    /**
     * Set modulDokument value
     * @param \StructType\Dokumentmodul $modulDokument
     * @return \StructType\Leistung
     */
    public function setModulDokument(\StructType\Dokumentmodul $modulDokument = null)
    {
        $this->modulDokument = $modulDokument;
        return $this;
    }
    /**
     * Get modulUrsprungsportal value
     * @return \StructType\UrsprungsportalModul[]|null
     */
    public function getModulUrsprungsportal()
    {
        return $this->modulUrsprungsportal;
    }
    /**
     * This method is responsible for validating the values passed to the setModulUrsprungsportal method
     * This method is willingly generated in order to preserve the one-line inline validation within the setModulUrsprungsportal method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateModulUrsprungsportalForArrayConstraintsFromSetModulUrsprungsportal(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungModulUrsprungsportalItem) {
            // validation for constraint: itemType
            if (!$leistungModulUrsprungsportalItem instanceof \StructType\UrsprungsportalModul) {
                $invalidValues[] = is_object($leistungModulUrsprungsportalItem) ? get_class($leistungModulUrsprungsportalItem) : sprintf('%s(%s)', gettype($leistungModulUrsprungsportalItem), var_export($leistungModulUrsprungsportalItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The modulUrsprungsportal property can only contain items of type \StructType\UrsprungsportalModul, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set modulUrsprungsportal value
     * @throws \InvalidArgumentException
     * @param \StructType\UrsprungsportalModul[] $modulUrsprungsportal
     * @return \StructType\Leistung
     */
    public function setModulUrsprungsportal(array $modulUrsprungsportal = array())
    {
        // validation for constraint: array
        if ('' !== ($modulUrsprungsportalArrayErrorMessage = self::validateModulUrsprungsportalForArrayConstraintsFromSetModulUrsprungsportal($modulUrsprungsportal))) {
            throw new \InvalidArgumentException($modulUrsprungsportalArrayErrorMessage, __LINE__);
        }
        $this->modulUrsprungsportal = $modulUrsprungsportal;
        return $this;
    }
    /**
     * Add item to modulUrsprungsportal value
     * @throws \InvalidArgumentException
     * @param \StructType\UrsprungsportalModul $item
     * @return \StructType\Leistung
     */
    public function addToModulUrsprungsportal(\StructType\UrsprungsportalModul $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UrsprungsportalModul) {
            throw new \InvalidArgumentException(sprintf('The modulUrsprungsportal property can only contain items of type \StructType\UrsprungsportalModul, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->modulUrsprungsportal[] = $item;
        return $this;
    }
    /**
     * Get typisierung value
     * @return \StructType\Code_LeiKaTypisierung[]|null
     */
    public function getTypisierung()
    {
        return $this->typisierung;
    }
    /**
     * This method is responsible for validating the values passed to the setTypisierung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypisierung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypisierungForArrayConstraintsFromSetTypisierung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungTypisierungItem) {
            // validation for constraint: itemType
            if (!$leistungTypisierungItem instanceof \StructType\Code_LeiKaTypisierung) {
                $invalidValues[] = is_object($leistungTypisierungItem) ? get_class($leistungTypisierungItem) : sprintf('%s(%s)', gettype($leistungTypisierungItem), var_export($leistungTypisierungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The typisierung property can only contain items of type \StructType\Code_LeiKaTypisierung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set typisierung value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_LeiKaTypisierung[] $typisierung
     * @return \StructType\Leistung
     */
    public function setTypisierung(array $typisierung = array())
    {
        // validation for constraint: array
        if ('' !== ($typisierungArrayErrorMessage = self::validateTypisierungForArrayConstraintsFromSetTypisierung($typisierung))) {
            throw new \InvalidArgumentException($typisierungArrayErrorMessage, __LINE__);
        }
        $this->typisierung = $typisierung;
        return $this;
    }
    /**
     * Add item to typisierung value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_LeiKaTypisierung $item
     * @return \StructType\Leistung
     */
    public function addToTypisierung(\StructType\Code_LeiKaTypisierung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Code_LeiKaTypisierung) {
            throw new \InvalidArgumentException(sprintf('The typisierung property can only contain items of type \StructType\Code_LeiKaTypisierung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->typisierung[] = $item;
        return $this;
    }
    /**
     * Get vertrauensniveau value
     * @return \StructType\Code_Vertrauensniveau|null
     */
    public function getVertrauensniveau()
    {
        return $this->vertrauensniveau;
    }
    /**
     * Set vertrauensniveau value
     * @param \StructType\Code_Vertrauensniveau $vertrauensniveau
     * @return \StructType\Leistung
     */
    public function setVertrauensniveau(\StructType\Code_Vertrauensniveau $vertrauensniveau = null)
    {
        $this->vertrauensniveau = $vertrauensniveau;
        return $this;
    }
    /**
     * Get leistungsadressat value
     * @return \StructType\Code_Leistungsadressat[]|null
     */
    public function getLeistungsadressat()
    {
        return $this->leistungsadressat;
    }
    /**
     * This method is responsible for validating the values passed to the setLeistungsadressat method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLeistungsadressat method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLeistungsadressatForArrayConstraintsFromSetLeistungsadressat(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungLeistungsadressatItem) {
            // validation for constraint: itemType
            if (!$leistungLeistungsadressatItem instanceof \StructType\Code_Leistungsadressat) {
                $invalidValues[] = is_object($leistungLeistungsadressatItem) ? get_class($leistungLeistungsadressatItem) : sprintf('%s(%s)', gettype($leistungLeistungsadressatItem), var_export($leistungLeistungsadressatItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The leistungsadressat property can only contain items of type \StructType\Code_Leistungsadressat, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set leistungsadressat value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Leistungsadressat[] $leistungsadressat
     * @return \StructType\Leistung
     */
    public function setLeistungsadressat(array $leistungsadressat = array())
    {
        // validation for constraint: array
        if ('' !== ($leistungsadressatArrayErrorMessage = self::validateLeistungsadressatForArrayConstraintsFromSetLeistungsadressat($leistungsadressat))) {
            throw new \InvalidArgumentException($leistungsadressatArrayErrorMessage, __LINE__);
        }
        $this->leistungsadressat = $leistungsadressat;
        return $this;
    }
    /**
     * Add item to leistungsadressat value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Leistungsadressat $item
     * @return \StructType\Leistung
     */
    public function addToLeistungsadressat(\StructType\Code_Leistungsadressat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Code_Leistungsadressat) {
            throw new \InvalidArgumentException(sprintf('The leistungsadressat property can only contain items of type \StructType\Code_Leistungsadressat, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->leistungsadressat[] = $item;
        return $this;
    }
    /**
     * Get kennzeichenSchriftformerfordernis value
     * @return bool|null
     */
    public function getKennzeichenSchriftformerfordernis()
    {
        return $this->kennzeichenSchriftformerfordernis;
    }
    /**
     * Set kennzeichenSchriftformerfordernis value
     * @param bool $kennzeichenSchriftformerfordernis
     * @return \StructType\Leistung
     */
    public function setKennzeichenSchriftformerfordernis($kennzeichenSchriftformerfordernis = null)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenSchriftformerfordernis) && !is_bool($kennzeichenSchriftformerfordernis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenSchriftformerfordernis, true), gettype($kennzeichenSchriftformerfordernis)), __LINE__);
        }
        $this->kennzeichenSchriftformerfordernis = $kennzeichenSchriftformerfordernis;
        return $this;
    }
    /**
     * Get kategorie value
     * @return \StructType\Leistungskategorie[]|null
     */
    public function getKategorie()
    {
        return $this->kategorie;
    }
    /**
     * This method is responsible for validating the values passed to the setKategorie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKategorie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKategorieForArrayConstraintsFromSetKategorie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungKategorieItem) {
            // validation for constraint: itemType
            if (!$leistungKategorieItem instanceof \StructType\Leistungskategorie) {
                $invalidValues[] = is_object($leistungKategorieItem) ? get_class($leistungKategorieItem) : sprintf('%s(%s)', gettype($leistungKategorieItem), var_export($leistungKategorieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kategorie property can only contain items of type \StructType\Leistungskategorie, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kategorie value
     * @throws \InvalidArgumentException
     * @param \StructType\Leistungskategorie[] $kategorie
     * @return \StructType\Leistung
     */
    public function setKategorie(array $kategorie = array())
    {
        // validation for constraint: array
        if ('' !== ($kategorieArrayErrorMessage = self::validateKategorieForArrayConstraintsFromSetKategorie($kategorie))) {
            throw new \InvalidArgumentException($kategorieArrayErrorMessage, __LINE__);
        }
        $this->kategorie = $kategorie;
        return $this;
    }
    /**
     * Add item to kategorie value
     * @throws \InvalidArgumentException
     * @param \StructType\Leistungskategorie $item
     * @return \StructType\Leistung
     */
    public function addToKategorie(\StructType\Leistungskategorie $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Leistungskategorie) {
            throw new \InvalidArgumentException(sprintf('The kategorie property can only contain items of type \StructType\Leistungskategorie, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kategorie[] = $item;
        return $this;
    }
    /**
     * Get klassifizierung value
     * @return \StructType\Code_KlassifizierungBenutzerdefiniert[]|null
     */
    public function getKlassifizierung()
    {
        return $this->klassifizierung;
    }
    /**
     * This method is responsible for validating the values passed to the setKlassifizierung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKlassifizierung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKlassifizierungForArrayConstraintsFromSetKlassifizierung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungKlassifizierungItem) {
            // validation for constraint: itemType
            if (!$leistungKlassifizierungItem instanceof \StructType\Code_KlassifizierungBenutzerdefiniert) {
                $invalidValues[] = is_object($leistungKlassifizierungItem) ? get_class($leistungKlassifizierungItem) : sprintf('%s(%s)', gettype($leistungKlassifizierungItem), var_export($leistungKlassifizierungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The klassifizierung property can only contain items of type \StructType\Code_KlassifizierungBenutzerdefiniert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set klassifizierung value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_KlassifizierungBenutzerdefiniert[] $klassifizierung
     * @return \StructType\Leistung
     */
    public function setKlassifizierung(array $klassifizierung = array())
    {
        // validation for constraint: array
        if ('' !== ($klassifizierungArrayErrorMessage = self::validateKlassifizierungForArrayConstraintsFromSetKlassifizierung($klassifizierung))) {
            throw new \InvalidArgumentException($klassifizierungArrayErrorMessage, __LINE__);
        }
        $this->klassifizierung = $klassifizierung;
        return $this;
    }
    /**
     * Add item to klassifizierung value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_KlassifizierungBenutzerdefiniert $item
     * @return \StructType\Leistung
     */
    public function addToKlassifizierung(\StructType\Code_KlassifizierungBenutzerdefiniert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Code_KlassifizierungBenutzerdefiniert) {
            throw new \InvalidArgumentException(sprintf('The klassifizierung property can only contain items of type \StructType\Code_KlassifizierungBenutzerdefiniert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->klassifizierung[] = $item;
        return $this;
    }
    /**
     * Get informationsbereichSDG value
     * @return \StructType\Code_SDGInformationsbereich[]|null
     */
    public function getInformationsbereichSDG()
    {
        return $this->informationsbereichSDG;
    }
    /**
     * This method is responsible for validating the values passed to the setInformationsbereichSDG method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInformationsbereichSDG method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInformationsbereichSDGForArrayConstraintsFromSetInformationsbereichSDG(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungInformationsbereichSDGItem) {
            // validation for constraint: itemType
            if (!$leistungInformationsbereichSDGItem instanceof \StructType\Code_SDGInformationsbereich) {
                $invalidValues[] = is_object($leistungInformationsbereichSDGItem) ? get_class($leistungInformationsbereichSDGItem) : sprintf('%s(%s)', gettype($leistungInformationsbereichSDGItem), var_export($leistungInformationsbereichSDGItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The informationsbereichSDG property can only contain items of type \StructType\Code_SDGInformationsbereich, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set informationsbereichSDG value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_SDGInformationsbereich[] $informationsbereichSDG
     * @return \StructType\Leistung
     */
    public function setInformationsbereichSDG(array $informationsbereichSDG = array())
    {
        // validation for constraint: array
        if ('' !== ($informationsbereichSDGArrayErrorMessage = self::validateInformationsbereichSDGForArrayConstraintsFromSetInformationsbereichSDG($informationsbereichSDG))) {
            throw new \InvalidArgumentException($informationsbereichSDGArrayErrorMessage, __LINE__);
        }
        $this->informationsbereichSDG = $informationsbereichSDG;
        return $this;
    }
    /**
     * Add item to informationsbereichSDG value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_SDGInformationsbereich $item
     * @return \StructType\Leistung
     */
    public function addToInformationsbereichSDG(\StructType\Code_SDGInformationsbereich $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Code_SDGInformationsbereich) {
            throw new \InvalidArgumentException(sprintf('The informationsbereichSDG property can only contain items of type \StructType\Code_SDGInformationsbereich, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->informationsbereichSDG[] = $item;
        return $this;
    }
    /**
     * Get idLeistungImKontext value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdLeistungImKontext()
    {
        return $this->idLeistungImKontext;
    }
    /**
     * This method is responsible for validating the values passed to the setIdLeistungImKontext method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdLeistungImKontext method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdLeistungImKontextForArrayConstraintsFromSetIdLeistungImKontext(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungIdLeistungImKontextItem) {
            // validation for constraint: itemType
            if (!$leistungIdLeistungImKontextItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($leistungIdLeistungImKontextItem) ? get_class($leistungIdLeistungImKontextItem) : sprintf('%s(%s)', gettype($leistungIdLeistungImKontextItem), var_export($leistungIdLeistungImKontextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idLeistungImKontext property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idLeistungImKontext value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idLeistungImKontext
     * @return \StructType\Leistung
     */
    public function setIdLeistungImKontext(array $idLeistungImKontext = array())
    {
        // validation for constraint: array
        if ('' !== ($idLeistungImKontextArrayErrorMessage = self::validateIdLeistungImKontextForArrayConstraintsFromSetIdLeistungImKontext($idLeistungImKontext))) {
            throw new \InvalidArgumentException($idLeistungImKontextArrayErrorMessage, __LINE__);
        }
        $this->idLeistungImKontext = $idLeistungImKontext;
        return $this;
    }
    /**
     * Add item to idLeistungImKontext value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Leistung
     */
    public function addToIdLeistungImKontext(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idLeistungImKontext property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idLeistungImKontext[] = $item;
        return $this;
    }
    /**
     * Get idProzess value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdProzess()
    {
        return $this->idProzess;
    }
    /**
     * This method is responsible for validating the values passed to the setIdProzess method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdProzess method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdProzessForArrayConstraintsFromSetIdProzess(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungIdProzessItem) {
            // validation for constraint: itemType
            if (!$leistungIdProzessItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($leistungIdProzessItem) ? get_class($leistungIdProzessItem) : sprintf('%s(%s)', gettype($leistungIdProzessItem), var_export($leistungIdProzessItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idProzess property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idProzess value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idProzess
     * @return \StructType\Leistung
     */
    public function setIdProzess(array $idProzess = array())
    {
        // validation for constraint: array
        if ('' !== ($idProzessArrayErrorMessage = self::validateIdProzessForArrayConstraintsFromSetIdProzess($idProzess))) {
            throw new \InvalidArgumentException($idProzessArrayErrorMessage, __LINE__);
        }
        $this->idProzess = $idProzess;
        return $this;
    }
    /**
     * Add item to idProzess value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Leistung
     */
    public function addToIdProzess(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idProzess property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idProzess[] = $item;
        return $this;
    }
    /**
     * Get herausgeber value
     * @return \StructType\Herausgeber|null
     */
    public function getHerausgeber()
    {
        return $this->herausgeber;
    }
    /**
     * Set herausgeber value
     * @param \StructType\Herausgeber $herausgeber
     * @return \StructType\Leistung
     */
    public function setHerausgeber(\StructType\Herausgeber $herausgeber = null)
    {
        $this->herausgeber = $herausgeber;
        return $this;
    }
    /**
     * Get gueltigkeitGebietID value
     * @return \StructType\Identifikator[]|null
     */
    public function getGueltigkeitGebietID()
    {
        return $this->gueltigkeitGebietID;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeitGebietID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeitGebietID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitGebietIDForArrayConstraintsFromSetGueltigkeitGebietID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungGueltigkeitGebietIDItem) {
            // validation for constraint: itemType
            if (!$leistungGueltigkeitGebietIDItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($leistungGueltigkeitGebietIDItem) ? get_class($leistungGueltigkeitGebietIDItem) : sprintf('%s(%s)', gettype($leistungGueltigkeitGebietIDItem), var_export($leistungGueltigkeitGebietIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeitGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeitGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $gueltigkeitGebietID
     * @return \StructType\Leistung
     */
    public function setGueltigkeitGebietID(array $gueltigkeitGebietID = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitGebietIDArrayErrorMessage = self::validateGueltigkeitGebietIDForArrayConstraintsFromSetGueltigkeitGebietID($gueltigkeitGebietID))) {
            throw new \InvalidArgumentException($gueltigkeitGebietIDArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeitGebietID = $gueltigkeitGebietID;
        return $this;
    }
    /**
     * Add item to gueltigkeitGebietID value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Leistung
     */
    public function addToGueltigkeitGebietID(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeitGebietID property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeitGebietID[] = $item;
        return $this;
    }
    /**
     * Get kennzeichenEA value
     * @return bool|null
     */
    public function getKennzeichenEA()
    {
        return $this->kennzeichenEA;
    }
    /**
     * Set kennzeichenEA value
     * @param bool $kennzeichenEA
     * @return \StructType\Leistung
     */
    public function setKennzeichenEA($kennzeichenEA = null)
    {
        // validation for constraint: boolean
        if (!is_null($kennzeichenEA) && !is_bool($kennzeichenEA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($kennzeichenEA, true), gettype($kennzeichenEA)), __LINE__);
        }
        $this->kennzeichenEA = $kennzeichenEA;
        return $this;
    }
    /**
     * Get relevantFuerWirtschaftszweig value
     * @return \StructType\Wirtschaftszweig_Spezifizierbar[]|null
     */
    public function getRelevantFuerWirtschaftszweig()
    {
        return $this->relevantFuerWirtschaftszweig;
    }
    /**
     * This method is responsible for validating the values passed to the setRelevantFuerWirtschaftszweig method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelevantFuerWirtschaftszweig method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelevantFuerWirtschaftszweigForArrayConstraintsFromSetRelevantFuerWirtschaftszweig(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungRelevantFuerWirtschaftszweigItem) {
            // validation for constraint: itemType
            if (!$leistungRelevantFuerWirtschaftszweigItem instanceof \StructType\Wirtschaftszweig_Spezifizierbar) {
                $invalidValues[] = is_object($leistungRelevantFuerWirtschaftszweigItem) ? get_class($leistungRelevantFuerWirtschaftszweigItem) : sprintf('%s(%s)', gettype($leistungRelevantFuerWirtschaftszweigItem), var_export($leistungRelevantFuerWirtschaftszweigItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relevantFuerWirtschaftszweig property can only contain items of type \StructType\Wirtschaftszweig_Spezifizierbar, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relevantFuerWirtschaftszweig value
     * @throws \InvalidArgumentException
     * @param \StructType\Wirtschaftszweig_Spezifizierbar[] $relevantFuerWirtschaftszweig
     * @return \StructType\Leistung
     */
    public function setRelevantFuerWirtschaftszweig(array $relevantFuerWirtschaftszweig = array())
    {
        // validation for constraint: array
        if ('' !== ($relevantFuerWirtschaftszweigArrayErrorMessage = self::validateRelevantFuerWirtschaftszweigForArrayConstraintsFromSetRelevantFuerWirtschaftszweig($relevantFuerWirtschaftszweig))) {
            throw new \InvalidArgumentException($relevantFuerWirtschaftszweigArrayErrorMessage, __LINE__);
        }
        $this->relevantFuerWirtschaftszweig = $relevantFuerWirtschaftszweig;
        return $this;
    }
    /**
     * Add item to relevantFuerWirtschaftszweig value
     * @throws \InvalidArgumentException
     * @param \StructType\Wirtschaftszweig_Spezifizierbar $item
     * @return \StructType\Leistung
     */
    public function addToRelevantFuerWirtschaftszweig(\StructType\Wirtschaftszweig_Spezifizierbar $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Wirtschaftszweig_Spezifizierbar) {
            throw new \InvalidArgumentException(sprintf('The relevantFuerWirtschaftszweig property can only contain items of type \StructType\Wirtschaftszweig_Spezifizierbar, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relevantFuerWirtschaftszweig[] = $item;
        return $this;
    }
    /**
     * Get relevantFuerRechtsform value
     * @return \StructType\Code_Rechtsform[]|null
     */
    public function getRelevantFuerRechtsform()
    {
        return $this->relevantFuerRechtsform;
    }
    /**
     * This method is responsible for validating the values passed to the setRelevantFuerRechtsform method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelevantFuerRechtsform method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelevantFuerRechtsformForArrayConstraintsFromSetRelevantFuerRechtsform(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungRelevantFuerRechtsformItem) {
            // validation for constraint: itemType
            if (!$leistungRelevantFuerRechtsformItem instanceof \StructType\Code_Rechtsform) {
                $invalidValues[] = is_object($leistungRelevantFuerRechtsformItem) ? get_class($leistungRelevantFuerRechtsformItem) : sprintf('%s(%s)', gettype($leistungRelevantFuerRechtsformItem), var_export($leistungRelevantFuerRechtsformItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relevantFuerRechtsform property can only contain items of type \StructType\Code_Rechtsform, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relevantFuerRechtsform value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Rechtsform[] $relevantFuerRechtsform
     * @return \StructType\Leistung
     */
    public function setRelevantFuerRechtsform(array $relevantFuerRechtsform = array())
    {
        // validation for constraint: array
        if ('' !== ($relevantFuerRechtsformArrayErrorMessage = self::validateRelevantFuerRechtsformForArrayConstraintsFromSetRelevantFuerRechtsform($relevantFuerRechtsform))) {
            throw new \InvalidArgumentException($relevantFuerRechtsformArrayErrorMessage, __LINE__);
        }
        $this->relevantFuerRechtsform = $relevantFuerRechtsform;
        return $this;
    }
    /**
     * Add item to relevantFuerRechtsform value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Rechtsform $item
     * @return \StructType\Leistung
     */
    public function addToRelevantFuerRechtsform(\StructType\Code_Rechtsform $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Code_Rechtsform) {
            throw new \InvalidArgumentException(sprintf('The relevantFuerRechtsform property can only contain items of type \StructType\Code_Rechtsform, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relevantFuerRechtsform[] = $item;
        return $this;
    }
    /**
     * Get relevantFuerStaatsangehoerigkeit value
     * @return \StructType\Code_StaatsangehoerigkeitDestatis[]|null
     */
    public function getRelevantFuerStaatsangehoerigkeit()
    {
        return $this->relevantFuerStaatsangehoerigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setRelevantFuerStaatsangehoerigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelevantFuerStaatsangehoerigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelevantFuerStaatsangehoerigkeitForArrayConstraintsFromSetRelevantFuerStaatsangehoerigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungRelevantFuerStaatsangehoerigkeitItem) {
            // validation for constraint: itemType
            if (!$leistungRelevantFuerStaatsangehoerigkeitItem instanceof \StructType\Code_StaatsangehoerigkeitDestatis) {
                $invalidValues[] = is_object($leistungRelevantFuerStaatsangehoerigkeitItem) ? get_class($leistungRelevantFuerStaatsangehoerigkeitItem) : sprintf('%s(%s)', gettype($leistungRelevantFuerStaatsangehoerigkeitItem), var_export($leistungRelevantFuerStaatsangehoerigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The relevantFuerStaatsangehoerigkeit property can only contain items of type \StructType\Code_StaatsangehoerigkeitDestatis, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set relevantFuerStaatsangehoerigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_StaatsangehoerigkeitDestatis[] $relevantFuerStaatsangehoerigkeit
     * @return \StructType\Leistung
     */
    public function setRelevantFuerStaatsangehoerigkeit(array $relevantFuerStaatsangehoerigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($relevantFuerStaatsangehoerigkeitArrayErrorMessage = self::validateRelevantFuerStaatsangehoerigkeitForArrayConstraintsFromSetRelevantFuerStaatsangehoerigkeit($relevantFuerStaatsangehoerigkeit))) {
            throw new \InvalidArgumentException($relevantFuerStaatsangehoerigkeitArrayErrorMessage, __LINE__);
        }
        $this->relevantFuerStaatsangehoerigkeit = $relevantFuerStaatsangehoerigkeit;
        return $this;
    }
    /**
     * Add item to relevantFuerStaatsangehoerigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Code_StaatsangehoerigkeitDestatis $item
     * @return \StructType\Leistung
     */
    public function addToRelevantFuerStaatsangehoerigkeit(\StructType\Code_StaatsangehoerigkeitDestatis $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Code_StaatsangehoerigkeitDestatis) {
            throw new \InvalidArgumentException(sprintf('The relevantFuerStaatsangehoerigkeit property can only contain items of type \StructType\Code_StaatsangehoerigkeitDestatis, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->relevantFuerStaatsangehoerigkeit[] = $item;
        return $this;
    }
    /**
     * Get versionsinformation value
     * @return \StructType\Versionsinformation|null
     */
    public function getVersionsinformation()
    {
        return $this->versionsinformation;
    }
    /**
     * Set versionsinformation value
     * @param \StructType\Versionsinformation $versionsinformation
     * @return \StructType\Leistung
     */
    public function setVersionsinformation(\StructType\Versionsinformation $versionsinformation = null)
    {
        $this->versionsinformation = $versionsinformation;
        return $this;
    }
    /**
     * Get sprachversion value
     * @return \StructType\Sprachversion[]|null
     */
    public function getSprachversion()
    {
        return $this->sprachversion;
    }
    /**
     * This method is responsible for validating the values passed to the setSprachversion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSprachversion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSprachversionForArrayConstraintsFromSetSprachversion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungSprachversionItem) {
            // validation for constraint: itemType
            if (!$leistungSprachversionItem instanceof \StructType\Sprachversion) {
                $invalidValues[] = is_object($leistungSprachversionItem) ? get_class($leistungSprachversionItem) : sprintf('%s(%s)', gettype($leistungSprachversionItem), var_export($leistungSprachversionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sprachversion property can only contain items of type \StructType\Sprachversion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sprachversion value
     * @throws \InvalidArgumentException
     * @param \StructType\Sprachversion[] $sprachversion
     * @return \StructType\Leistung
     */
    public function setSprachversion(array $sprachversion = array())
    {
        // validation for constraint: array
        if ('' !== ($sprachversionArrayErrorMessage = self::validateSprachversionForArrayConstraintsFromSetSprachversion($sprachversion))) {
            throw new \InvalidArgumentException($sprachversionArrayErrorMessage, __LINE__);
        }
        $this->sprachversion = $sprachversion;
        return $this;
    }
    /**
     * Add item to sprachversion value
     * @throws \InvalidArgumentException
     * @param \StructType\Sprachversion $item
     * @return \StructType\Leistung
     */
    public function addToSprachversion(\StructType\Sprachversion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Sprachversion) {
            throw new \InvalidArgumentException(sprintf('The sprachversion property can only contain items of type \StructType\Sprachversion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sprachversion[] = $item;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $leistungGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$leistungGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($leistungGueltigkeitItem) ? get_class($leistungGueltigkeitItem) : sprintf('%s(%s)', gettype($leistungGueltigkeitItem), var_export($leistungGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\Leistung
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Leistung
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
}
