<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LI_Source_Type StructType
 * @subpackage Structs
 */
class LI_Source_Type extends AbstractStructBase
{
    /**
     * The description
     * @var \StructType\CharacterString_PropertyType
     */
    public $description;
    /**
     * The scaleDenominator
     * @var \StructType\MD_RepresentativeFraction_PropertyType
     */
    public $scaleDenominator;
    /**
     * The sourceReferenceSystem
     * @var \StructType\MD_ReferenceSystem_PropertyType
     */
    public $sourceReferenceSystem;
    /**
     * The sourceCitation
     * @var \StructType\CI_Citation_PropertyType
     */
    public $sourceCitation;
    /**
     * The sourceExtent
     * @var \StructType\EX_Extent_PropertyType
     */
    public $sourceExtent;
    /**
     * The sourceStep
     * @var \StructType\LI_ProcessStep_PropertyType
     */
    public $sourceStep;
    /**
     * Constructor method for LI_Source_Type
     * @uses LI_Source_Type::setDescription()
     * @uses LI_Source_Type::setScaleDenominator()
     * @uses LI_Source_Type::setSourceReferenceSystem()
     * @uses LI_Source_Type::setSourceCitation()
     * @uses LI_Source_Type::setSourceExtent()
     * @uses LI_Source_Type::setSourceStep()
     * @param \StructType\CharacterString_PropertyType $description
     * @param \StructType\MD_RepresentativeFraction_PropertyType $scaleDenominator
     * @param \StructType\MD_ReferenceSystem_PropertyType $sourceReferenceSystem
     * @param \StructType\CI_Citation_PropertyType $sourceCitation
     * @param \StructType\EX_Extent_PropertyType $sourceExtent
     * @param \StructType\LI_ProcessStep_PropertyType $sourceStep
     */
    public function __construct(\StructType\CharacterString_PropertyType $description = null, \StructType\MD_RepresentativeFraction_PropertyType $scaleDenominator = null, \StructType\MD_ReferenceSystem_PropertyType $sourceReferenceSystem = null, \StructType\CI_Citation_PropertyType $sourceCitation = null, \StructType\EX_Extent_PropertyType $sourceExtent = null, \StructType\LI_ProcessStep_PropertyType $sourceStep = null)
    {
        $this
            ->setDescription($description)
            ->setScaleDenominator($scaleDenominator)
            ->setSourceReferenceSystem($sourceReferenceSystem)
            ->setSourceCitation($sourceCitation)
            ->setSourceExtent($sourceExtent)
            ->setSourceStep($sourceStep);
    }
    /**
     * Get description value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param \StructType\CharacterString_PropertyType $description
     * @return \StructType\LI_Source_Type
     */
    public function setDescription(\StructType\CharacterString_PropertyType $description = null)
    {
        $this->description = $description;
        return $this;
    }
    /**
     * Get scaleDenominator value
     * @return \StructType\MD_RepresentativeFraction_PropertyType|null
     */
    public function getScaleDenominator()
    {
        return $this->scaleDenominator;
    }
    /**
     * Set scaleDenominator value
     * @param \StructType\MD_RepresentativeFraction_PropertyType $scaleDenominator
     * @return \StructType\LI_Source_Type
     */
    public function setScaleDenominator(\StructType\MD_RepresentativeFraction_PropertyType $scaleDenominator = null)
    {
        $this->scaleDenominator = $scaleDenominator;
        return $this;
    }
    /**
     * Get sourceReferenceSystem value
     * @return \StructType\MD_ReferenceSystem_PropertyType|null
     */
    public function getSourceReferenceSystem()
    {
        return $this->sourceReferenceSystem;
    }
    /**
     * Set sourceReferenceSystem value
     * @param \StructType\MD_ReferenceSystem_PropertyType $sourceReferenceSystem
     * @return \StructType\LI_Source_Type
     */
    public function setSourceReferenceSystem(\StructType\MD_ReferenceSystem_PropertyType $sourceReferenceSystem = null)
    {
        $this->sourceReferenceSystem = $sourceReferenceSystem;
        return $this;
    }
    /**
     * Get sourceCitation value
     * @return \StructType\CI_Citation_PropertyType|null
     */
    public function getSourceCitation()
    {
        return $this->sourceCitation;
    }
    /**
     * Set sourceCitation value
     * @param \StructType\CI_Citation_PropertyType $sourceCitation
     * @return \StructType\LI_Source_Type
     */
    public function setSourceCitation(\StructType\CI_Citation_PropertyType $sourceCitation = null)
    {
        $this->sourceCitation = $sourceCitation;
        return $this;
    }
    /**
     * Get sourceExtent value
     * @return \StructType\EX_Extent_PropertyType|null
     */
    public function getSourceExtent()
    {
        return $this->sourceExtent;
    }
    /**
     * Set sourceExtent value
     * @param \StructType\EX_Extent_PropertyType $sourceExtent
     * @return \StructType\LI_Source_Type
     */
    public function setSourceExtent(\StructType\EX_Extent_PropertyType $sourceExtent = null)
    {
        $this->sourceExtent = $sourceExtent;
        return $this;
    }
    /**
     * Get sourceStep value
     * @return \StructType\LI_ProcessStep_PropertyType|null
     */
    public function getSourceStep()
    {
        return $this->sourceStep;
    }
    /**
     * Set sourceStep value
     * @param \StructType\LI_ProcessStep_PropertyType $sourceStep
     * @return \StructType\LI_Source_Type
     */
    public function setSourceStep(\StructType\LI_ProcessStep_PropertyType $sourceStep = null)
    {
        $this->sourceStep = $sourceStep;
        return $this;
    }
}
