<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LI_Lineage_Type StructType
 * @subpackage Structs
 */
class LI_Lineage_Type extends AbstractStructBase
{
    /**
     * The statement
     * @var \StructType\CharacterString_PropertyType
     */
    public $statement;
    /**
     * The processStep
     * @var \StructType\LI_ProcessStep_PropertyType
     */
    public $processStep;
    /**
     * The source
     * @var \StructType\LI_Source_PropertyType
     */
    public $source;
    /**
     * Constructor method for LI_Lineage_Type
     * @uses LI_Lineage_Type::setStatement()
     * @uses LI_Lineage_Type::setProcessStep()
     * @uses LI_Lineage_Type::setSource()
     * @param \StructType\CharacterString_PropertyType $statement
     * @param \StructType\LI_ProcessStep_PropertyType $processStep
     * @param \StructType\LI_Source_PropertyType $source
     */
    public function __construct(\StructType\CharacterString_PropertyType $statement = null, \StructType\LI_ProcessStep_PropertyType $processStep = null, \StructType\LI_Source_PropertyType $source = null)
    {
        $this
            ->setStatement($statement)
            ->setProcessStep($processStep)
            ->setSource($source);
    }
    /**
     * Get statement value
     * @return \StructType\CharacterString_PropertyType|null
     */
    public function getStatement()
    {
        return $this->statement;
    }
    /**
     * Set statement value
     * @param \StructType\CharacterString_PropertyType $statement
     * @return \StructType\LI_Lineage_Type
     */
    public function setStatement(\StructType\CharacterString_PropertyType $statement = null)
    {
        $this->statement = $statement;
        return $this;
    }
    /**
     * Get processStep value
     * @return \StructType\LI_ProcessStep_PropertyType|null
     */
    public function getProcessStep()
    {
        return $this->processStep;
    }
    /**
     * Set processStep value
     * @param \StructType\LI_ProcessStep_PropertyType $processStep
     * @return \StructType\LI_Lineage_Type
     */
    public function setProcessStep(\StructType\LI_ProcessStep_PropertyType $processStep = null)
    {
        $this->processStep = $processStep;
        return $this;
    }
    /**
     * Get source value
     * @return \StructType\LI_Source_PropertyType|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param \StructType\LI_Source_PropertyType $source
     * @return \StructType\LI_Lineage_Type
     */
    public function setSource(\StructType\LI_Source_PropertyType $source = null)
    {
        $this->source = $source;
        return $this;
    }
}
