<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Kostenmodul StructType
 * Meta information extracted from the WSDL
 * - documentation: Modul zur Abbildung von Kosten, Gebühren von Leistungen.
 * @subpackage Structs
 */
class Kostenmodul extends Leistungsmodul
{
    /**
     * The kosten
     * Meta information extracted from the WSDL
     * - documentation: Strukturiert erfasste Kosten zur Leistung
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Kosten[]
     */
    public $kosten;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Allgemeine (textuelle) Beschreibung des Kostenmoduls. Es soll angestrebt werden, die konkreten Kosten unter "kosten" als strukturierte Daten anzugeben.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist hier
     * gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibung;
    /**
     * The weiterfuehrenderLink
     * Meta information extracted from the WSDL
     * - documentation: Angabe von weiterführenden Links.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HyperlinkErweitert[]
     */
    public $weiterfuehrenderLink;
    /**
     * Constructor method for Kostenmodul
     * @uses Kostenmodul::setKosten()
     * @uses Kostenmodul::setBeschreibung()
     * @uses Kostenmodul::setWeiterfuehrenderLink()
     * @param \StructType\Kosten[] $kosten
     * @param \StructType\String_Localized[] $beschreibung
     * @param \StructType\HyperlinkErweitert[] $weiterfuehrenderLink
     */
    public function __construct(array $kosten = array(), array $beschreibung = array(), array $weiterfuehrenderLink = array())
    {
        $this
            ->setKosten($kosten)
            ->setBeschreibung($beschreibung)
            ->setWeiterfuehrenderLink($weiterfuehrenderLink);
    }
    /**
     * Get kosten value
     * @return \StructType\Kosten[]|null
     */
    public function getKosten()
    {
        return $this->kosten;
    }
    /**
     * This method is responsible for validating the values passed to the setKosten method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKosten method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKostenForArrayConstraintsFromSetKosten(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kostenmodulKostenItem) {
            // validation for constraint: itemType
            if (!$kostenmodulKostenItem instanceof \StructType\Kosten) {
                $invalidValues[] = is_object($kostenmodulKostenItem) ? get_class($kostenmodulKostenItem) : sprintf('%s(%s)', gettype($kostenmodulKostenItem), var_export($kostenmodulKostenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kosten property can only contain items of type \StructType\Kosten, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kosten value
     * @throws \InvalidArgumentException
     * @param \StructType\Kosten[] $kosten
     * @return \StructType\Kostenmodul
     */
    public function setKosten(array $kosten = array())
    {
        // validation for constraint: array
        if ('' !== ($kostenArrayErrorMessage = self::validateKostenForArrayConstraintsFromSetKosten($kosten))) {
            throw new \InvalidArgumentException($kostenArrayErrorMessage, __LINE__);
        }
        $this->kosten = $kosten;
        return $this;
    }
    /**
     * Add item to kosten value
     * @throws \InvalidArgumentException
     * @param \StructType\Kosten $item
     * @return \StructType\Kostenmodul
     */
    public function addToKosten(\StructType\Kosten $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Kosten) {
            throw new \InvalidArgumentException(sprintf('The kosten property can only contain items of type \StructType\Kosten, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kosten[] = $item;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kostenmodulBeschreibungItem) {
            // validation for constraint: itemType
            if (!$kostenmodulBeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($kostenmodulBeschreibungItem) ? get_class($kostenmodulBeschreibungItem) : sprintf('%s(%s)', gettype($kostenmodulBeschreibungItem), var_export($kostenmodulBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibung
     * @return \StructType\Kostenmodul
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Kostenmodul
     */
    public function addToBeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
    /**
     * Get weiterfuehrenderLink value
     * @return \StructType\HyperlinkErweitert[]|null
     */
    public function getWeiterfuehrenderLink()
    {
        return $this->weiterfuehrenderLink;
    }
    /**
     * This method is responsible for validating the values passed to the setWeiterfuehrenderLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeiterfuehrenderLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeiterfuehrenderLinkForArrayConstraintsFromSetWeiterfuehrenderLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kostenmodulWeiterfuehrenderLinkItem) {
            // validation for constraint: itemType
            if (!$kostenmodulWeiterfuehrenderLinkItem instanceof \StructType\HyperlinkErweitert) {
                $invalidValues[] = is_object($kostenmodulWeiterfuehrenderLinkItem) ? get_class($kostenmodulWeiterfuehrenderLinkItem) : sprintf('%s(%s)', gettype($kostenmodulWeiterfuehrenderLinkItem), var_export($kostenmodulWeiterfuehrenderLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weiterfuehrenderLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weiterfuehrenderLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert[] $weiterfuehrenderLink
     * @return \StructType\Kostenmodul
     */
    public function setWeiterfuehrenderLink(array $weiterfuehrenderLink = array())
    {
        // validation for constraint: array
        if ('' !== ($weiterfuehrenderLinkArrayErrorMessage = self::validateWeiterfuehrenderLinkForArrayConstraintsFromSetWeiterfuehrenderLink($weiterfuehrenderLink))) {
            throw new \InvalidArgumentException($weiterfuehrenderLinkArrayErrorMessage, __LINE__);
        }
        $this->weiterfuehrenderLink = $weiterfuehrenderLink;
        return $this;
    }
    /**
     * Add item to weiterfuehrenderLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert $item
     * @return \StructType\Kostenmodul
     */
    public function addToWeiterfuehrenderLink(\StructType\HyperlinkErweitert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HyperlinkErweitert) {
            throw new \InvalidArgumentException(sprintf('The weiterfuehrenderLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weiterfuehrenderLink[] = $item;
        return $this;
    }
}
