<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Kostenauswahl StructType
 * Meta information extracted from the WSDL
 * - documentation: Auswahl des Kostentyps.
 * @subpackage Structs
 */
class Kostenauswahl extends AbstractStructBase
{
    /**
     * The kostenFix
     * Meta information extracted from the WSDL
     * - documentation: Fixe Kosten, d.h. ein bestimmter Wert.
     * - choice: kostenFix | kostenFrei | kostenVariabel
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\KostenFix
     */
    public $kostenFix;
    /**
     * The kostenFrei
     * Meta information extracted from the WSDL
     * - documentation: Kostenfreiheit, d.h. es fallen keine Kosten an.
     * - choice: kostenFix | kostenFrei | kostenVariabel
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\KostenFrei
     */
    public $kostenFrei;
    /**
     * The kostenVariabel
     * Meta information extracted from the WSDL
     * - documentation: Variable Kosten, also Angabe von/bis Intervallen.
     * - choice: kostenFix | kostenFrei | kostenVariabel
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\KostenVariabel
     */
    public $kostenVariabel;
    /**
     * Constructor method for Kostenauswahl
     * @uses Kostenauswahl::setKostenFix()
     * @uses Kostenauswahl::setKostenFrei()
     * @uses Kostenauswahl::setKostenVariabel()
     * @param \StructType\KostenFix $kostenFix
     * @param \StructType\KostenFrei $kostenFrei
     * @param \StructType\KostenVariabel $kostenVariabel
     */
    public function __construct(\StructType\KostenFix $kostenFix = null, \StructType\KostenFrei $kostenFrei = null, \StructType\KostenVariabel $kostenVariabel = null)
    {
        $this
            ->setKostenFix($kostenFix)
            ->setKostenFrei($kostenFrei)
            ->setKostenVariabel($kostenVariabel);
    }
    /**
     * Get kostenFix value
     * @return \StructType\KostenFix|null
     */
    public function getKostenFix()
    {
        return isset($this->kostenFix) ? $this->kostenFix : null;
    }
    /**
     * This method is responsible for validating the value passed to the setKostenFix method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKostenFix method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateKostenFixForChoiceConstraintsFromSetKostenFix($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'kostenFrei',
            'kostenVariabel',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property kostenFix can\'t be set as the property %s is already set. Only one property must be set among these properties: kostenFix, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set kostenFix value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\KostenFix $kostenFix
     * @return \StructType\Kostenauswahl
     */
    public function setKostenFix(\StructType\KostenFix $kostenFix = null)
    {
        // validation for constraint: choice(kostenFix, kostenFrei, kostenVariabel)
        if ('' !== ($kostenFixChoiceErrorMessage = self::validateKostenFixForChoiceConstraintsFromSetKostenFix($kostenFix))) {
            throw new \InvalidArgumentException($kostenFixChoiceErrorMessage, __LINE__);
        }
        if (is_null($kostenFix) || (is_array($kostenFix) && empty($kostenFix))) {
            unset($this->kostenFix);
        } else {
            $this->kostenFix = $kostenFix;
        }
        return $this;
    }
    /**
     * Get kostenFrei value
     * @return \StructType\KostenFrei|null
     */
    public function getKostenFrei()
    {
        return isset($this->kostenFrei) ? $this->kostenFrei : null;
    }
    /**
     * This method is responsible for validating the value passed to the setKostenFrei method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKostenFrei method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateKostenFreiForChoiceConstraintsFromSetKostenFrei($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'kostenFix',
            'kostenVariabel',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property kostenFrei can\'t be set as the property %s is already set. Only one property must be set among these properties: kostenFrei, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set kostenFrei value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\KostenFrei $kostenFrei
     * @return \StructType\Kostenauswahl
     */
    public function setKostenFrei(\StructType\KostenFrei $kostenFrei = null)
    {
        // validation for constraint: choice(kostenFix, kostenFrei, kostenVariabel)
        if ('' !== ($kostenFreiChoiceErrorMessage = self::validateKostenFreiForChoiceConstraintsFromSetKostenFrei($kostenFrei))) {
            throw new \InvalidArgumentException($kostenFreiChoiceErrorMessage, __LINE__);
        }
        if (is_null($kostenFrei) || (is_array($kostenFrei) && empty($kostenFrei))) {
            unset($this->kostenFrei);
        } else {
            $this->kostenFrei = $kostenFrei;
        }
        return $this;
    }
    /**
     * Get kostenVariabel value
     * @return \StructType\KostenVariabel|null
     */
    public function getKostenVariabel()
    {
        return isset($this->kostenVariabel) ? $this->kostenVariabel : null;
    }
    /**
     * This method is responsible for validating the value passed to the setKostenVariabel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKostenVariabel method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateKostenVariabelForChoiceConstraintsFromSetKostenVariabel($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'kostenFix',
            'kostenFrei',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property kostenVariabel can\'t be set as the property %s is already set. Only one property must be set among these properties: kostenVariabel, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set kostenVariabel value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\KostenVariabel $kostenVariabel
     * @return \StructType\Kostenauswahl
     */
    public function setKostenVariabel(\StructType\KostenVariabel $kostenVariabel = null)
    {
        // validation for constraint: choice(kostenFix, kostenFrei, kostenVariabel)
        if ('' !== ($kostenVariabelChoiceErrorMessage = self::validateKostenVariabelForChoiceConstraintsFromSetKostenVariabel($kostenVariabel))) {
            throw new \InvalidArgumentException($kostenVariabelChoiceErrorMessage, __LINE__);
        }
        if (is_null($kostenVariabel) || (is_array($kostenVariabel) && empty($kostenVariabel))) {
            unset($this->kostenVariabel);
        } else {
            $this->kostenVariabel = $kostenVariabel;
        }
        return $this;
    }
}
