<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KostenTyp_Erweiterbar StructType
 * Meta information extracted from the WSDL
 * - documentation: Der Typ bestimmt die Art der Kosten näher. Es soll die in XZuFi hinterlegte Codeliste verwendet werden. Ist ein Typ nicht vorhanden, kann ein eigener Code verwendet werden.
 * @subpackage Structs
 */
class KostenTyp_Erweiterbar extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - documentation: Code des Kostentyps.
     * - choice: code | nichtGelisteterWert
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\Code_Kostentyp
     */
    public $code;
    /**
     * The nichtGelisteterWert
     * Meta information extracted from the WSDL
     * - documentation: Eigener Code, wenn nicht in Codeliste vorhanden.
     * - choice: code | nichtGelisteterWert
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $nichtGelisteterWert;
    /**
     * Constructor method for KostenTyp_Erweiterbar
     * @uses KostenTyp_Erweiterbar::setCode()
     * @uses KostenTyp_Erweiterbar::setNichtGelisteterWert()
     * @param \StructType\Code_Kostentyp $code
     * @param string $nichtGelisteterWert
     */
    public function __construct(\StructType\Code_Kostentyp $code = null, $nichtGelisteterWert = null)
    {
        $this
            ->setCode($code)
            ->setNichtGelisteterWert($nichtGelisteterWert);
    }
    /**
     * Get code value
     * @return \StructType\Code_Kostentyp|null
     */
    public function getCode()
    {
        return isset($this->code) ? $this->code : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCode method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCodeForChoiceConstraintsFromSetCode($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'nichtGelisteterWert',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property code can\'t be set as the property %s is already set. Only one property must be set among these properties: code, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set code value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Code_Kostentyp $code
     * @return \StructType\KostenTyp_Erweiterbar
     */
    public function setCode(\StructType\Code_Kostentyp $code = null)
    {
        // validation for constraint: choice(code, nichtGelisteterWert)
        if ('' !== ($codeChoiceErrorMessage = self::validateCodeForChoiceConstraintsFromSetCode($code))) {
            throw new \InvalidArgumentException($codeChoiceErrorMessage, __LINE__);
        }
        if (is_null($code) || (is_array($code) && empty($code))) {
            unset($this->code);
        } else {
            $this->code = $code;
        }
        return $this;
    }
    /**
     * Get nichtGelisteterWert value
     * @return string|null
     */
    public function getNichtGelisteterWert()
    {
        return isset($this->nichtGelisteterWert) ? $this->nichtGelisteterWert : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNichtGelisteterWert method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNichtGelisteterWert method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNichtGelisteterWertForChoiceConstraintsFromSetNichtGelisteterWert($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'code',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property nichtGelisteterWert can\'t be set as the property %s is already set. Only one property must be set among these properties: nichtGelisteterWert, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set nichtGelisteterWert value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $nichtGelisteterWert
     * @return \StructType\KostenTyp_Erweiterbar
     */
    public function setNichtGelisteterWert($nichtGelisteterWert = null)
    {
        // validation for constraint: string
        if (!is_null($nichtGelisteterWert) && !is_string($nichtGelisteterWert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nichtGelisteterWert, true), gettype($nichtGelisteterWert)), __LINE__);
        }
        // validation for constraint: choice(code, nichtGelisteterWert)
        if ('' !== ($nichtGelisteterWertChoiceErrorMessage = self::validateNichtGelisteterWertForChoiceConstraintsFromSetNichtGelisteterWert($nichtGelisteterWert))) {
            throw new \InvalidArgumentException($nichtGelisteterWertChoiceErrorMessage, __LINE__);
        }
        if (is_null($nichtGelisteterWert) || (is_array($nichtGelisteterWert) && empty($nichtGelisteterWert))) {
            unset($this->nichtGelisteterWert);
        } else {
            $this->nichtGelisteterWert = $nichtGelisteterWert;
        }
        return $this;
    }
}
