<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Kontaktperson StructType
 * Meta information extracted from the WSDL
 * - documentation: Kontaktperson ist eine natürliche Person, welche eine Aufgabe im Kontext einer Organisationseinheit durchführt. Im Allgemeinen auch ein Mitarbeiter.
 * @subpackage Structs
 */
class Kontaktperson extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - documentation: Primäre ID. Hier wird der in XZuFi übergreifend genutzte Datentyp Identifikatior verwendet.
     * @var \StructType\Identifikator
     */
    public $id;
    /**
     * The idSekundaer
     * Meta information extracted from the WSDL
     * - documentation: Sekundäre IDs.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Identifikator[]
     */
    public $idSekundaer;
    /**
     * The anrede
     * Meta information extracted from the WSDL
     * - documentation: Anreder der Person, z.B. "Frau".
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $anrede;
    /**
     * The titel
     * Meta information extracted from the WSDL
     * - documentation: Titel der Person, z.B. "Dr."
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $titel;
    /**
     * The vorname
     * Meta information extracted from the WSDL
     * - documentation: Vorname der Person.
     * - minOccurs: 0
     * @var string
     */
    public $vorname;
    /**
     * The familienname
     * Meta information extracted from the WSDL
     * - documentation: Familien- bzw. Nachname der Person.
     * - minOccurs: 0
     * @var string
     */
    public $familienname;
    /**
     * The position
     * Meta information extracted from the WSDL
     * - documentation: Angaben zur Position/Funktion der Person.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $position;
    /**
     * The sprechzeiten
     * Meta information extracted from the WSDL
     * - documentation: Angaben zu Sprechzeiten der Person.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $sprechzeiten;
    /**
     * The raum
     * Meta information extracted from the WSDL
     * - documentation: Angaben zum Raum der Person.
     * - minOccurs: 0
     * @var string
     */
    public $raum;
    /**
     * The anschrift
     * Meta information extracted from the WSDL
     * - documentation: Die Angabe ist in der Regel nicht erforderlich. Hier sollen nur von der Organisationseinheit, welcher die Kontaktperson zugeordnet ist, abweichende oder spezielle Anschriften angegeben werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Anschrift[]
     */
    public $anschrift;
    /**
     * The erreichbarkeit
     * Meta information extracted from the WSDL
     * - documentation: Angabe von Erreichbarkeitskanälen der Kontaktperson. Dies ist z.B. die persönliche E-Mail oder die Telefonnummer mit konkreter Durchwahl. Allgemeine Kanäle der übergeordneten Organisationseinheit sollen nicht wiederholt angegeben
     * werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Erreichbarkeit[]
     */
    public $erreichbarkeit;
    /**
     * The internetadresse
     * Meta information extracted from the WSDL
     * - documentation: Angabe einer speziellen Internetadresse, welche weitere Informationen zur Kontaktperson bereitstellt. Die offizielle Internetadresse der übergeordneten Organisationseinheit soll hier nicht wiederholt angegeben werden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HyperlinkErweitert[]
     */
    public $internetadresse;
    /**
     * The zustaendigkeit
     * Meta information extracted from the WSDL
     * - documentation: Zuständigkeitsangaben zur Kontaktpersonen dürfen immer nur eine Untermenge der Zuständigkeiten der Organisationseinheit sein. Sie dienen zur Einschränkung und/oder Präzisierung der Zuständigkeit des einzelnen Mitarbeiters. Zum
     * Beispiel wenn dieser nur für bestimmte Leistungen oder Familiennamen zuständig ist.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ZustaendigkeitPerson[]
     */
    public $zustaendigkeit;
    /**
     * The herausgeber
     * Meta information extracted from the WSDL
     * - documentation: Optionale Angabe des Herausgebers der Daten.
     * - minOccurs: 0
     * @var \StructType\Herausgeber
     */
    public $herausgeber;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen das Objekt gültig ist. Zeiträume können nacheinander liegen oder sich überschneiden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * Constructor method for Kontaktperson
     * @uses Kontaktperson::setId()
     * @uses Kontaktperson::setIdSekundaer()
     * @uses Kontaktperson::setAnrede()
     * @uses Kontaktperson::setTitel()
     * @uses Kontaktperson::setVorname()
     * @uses Kontaktperson::setFamilienname()
     * @uses Kontaktperson::setPosition()
     * @uses Kontaktperson::setSprechzeiten()
     * @uses Kontaktperson::setRaum()
     * @uses Kontaktperson::setAnschrift()
     * @uses Kontaktperson::setErreichbarkeit()
     * @uses Kontaktperson::setInternetadresse()
     * @uses Kontaktperson::setZustaendigkeit()
     * @uses Kontaktperson::setHerausgeber()
     * @uses Kontaktperson::setGueltigkeit()
     * @param \StructType\Identifikator $id
     * @param \StructType\Identifikator[] $idSekundaer
     * @param \StructType\String_Localized[] $anrede
     * @param \StructType\String_Localized[] $titel
     * @param string $vorname
     * @param string $familienname
     * @param \StructType\String_Localized[] $position
     * @param \StructType\String_Localized[] $sprechzeiten
     * @param string $raum
     * @param \StructType\Anschrift[] $anschrift
     * @param \StructType\Erreichbarkeit[] $erreichbarkeit
     * @param \StructType\HyperlinkErweitert[] $internetadresse
     * @param \StructType\ZustaendigkeitPerson[] $zustaendigkeit
     * @param \StructType\Herausgeber $herausgeber
     * @param \StructType\Zeitraum[] $gueltigkeit
     */
    public function __construct(\StructType\Identifikator $id = null, array $idSekundaer = array(), array $anrede = array(), array $titel = array(), $vorname = null, $familienname = null, array $position = array(), array $sprechzeiten = array(), $raum = null, array $anschrift = array(), array $erreichbarkeit = array(), array $internetadresse = array(), array $zustaendigkeit = array(), \StructType\Herausgeber $herausgeber = null, array $gueltigkeit = array())
    {
        $this
            ->setId($id)
            ->setIdSekundaer($idSekundaer)
            ->setAnrede($anrede)
            ->setTitel($titel)
            ->setVorname($vorname)
            ->setFamilienname($familienname)
            ->setPosition($position)
            ->setSprechzeiten($sprechzeiten)
            ->setRaum($raum)
            ->setAnschrift($anschrift)
            ->setErreichbarkeit($erreichbarkeit)
            ->setInternetadresse($internetadresse)
            ->setZustaendigkeit($zustaendigkeit)
            ->setHerausgeber($herausgeber)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get id value
     * @return \StructType\Identifikator|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param \StructType\Identifikator $id
     * @return \StructType\Kontaktperson
     */
    public function setId(\StructType\Identifikator $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get idSekundaer value
     * @return \StructType\Identifikator[]|null
     */
    public function getIdSekundaer()
    {
        return $this->idSekundaer;
    }
    /**
     * This method is responsible for validating the values passed to the setIdSekundaer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdSekundaer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdSekundaerForArrayConstraintsFromSetIdSekundaer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kontaktpersonIdSekundaerItem) {
            // validation for constraint: itemType
            if (!$kontaktpersonIdSekundaerItem instanceof \StructType\Identifikator) {
                $invalidValues[] = is_object($kontaktpersonIdSekundaerItem) ? get_class($kontaktpersonIdSekundaerItem) : sprintf('%s(%s)', gettype($kontaktpersonIdSekundaerItem), var_export($kontaktpersonIdSekundaerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator[] $idSekundaer
     * @return \StructType\Kontaktperson
     */
    public function setIdSekundaer(array $idSekundaer = array())
    {
        // validation for constraint: array
        if ('' !== ($idSekundaerArrayErrorMessage = self::validateIdSekundaerForArrayConstraintsFromSetIdSekundaer($idSekundaer))) {
            throw new \InvalidArgumentException($idSekundaerArrayErrorMessage, __LINE__);
        }
        $this->idSekundaer = $idSekundaer;
        return $this;
    }
    /**
     * Add item to idSekundaer value
     * @throws \InvalidArgumentException
     * @param \StructType\Identifikator $item
     * @return \StructType\Kontaktperson
     */
    public function addToIdSekundaer(\StructType\Identifikator $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Identifikator) {
            throw new \InvalidArgumentException(sprintf('The idSekundaer property can only contain items of type \StructType\Identifikator, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->idSekundaer[] = $item;
        return $this;
    }
    /**
     * Get anrede value
     * @return \StructType\String_Localized[]|null
     */
    public function getAnrede()
    {
        return $this->anrede;
    }
    /**
     * This method is responsible for validating the values passed to the setAnrede method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnrede method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnredeForArrayConstraintsFromSetAnrede(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kontaktpersonAnredeItem) {
            // validation for constraint: itemType
            if (!$kontaktpersonAnredeItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($kontaktpersonAnredeItem) ? get_class($kontaktpersonAnredeItem) : sprintf('%s(%s)', gettype($kontaktpersonAnredeItem), var_export($kontaktpersonAnredeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The anrede property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set anrede value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $anrede
     * @return \StructType\Kontaktperson
     */
    public function setAnrede(array $anrede = array())
    {
        // validation for constraint: array
        if ('' !== ($anredeArrayErrorMessage = self::validateAnredeForArrayConstraintsFromSetAnrede($anrede))) {
            throw new \InvalidArgumentException($anredeArrayErrorMessage, __LINE__);
        }
        $this->anrede = $anrede;
        return $this;
    }
    /**
     * Add item to anrede value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Kontaktperson
     */
    public function addToAnrede(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The anrede property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->anrede[] = $item;
        return $this;
    }
    /**
     * Get titel value
     * @return \StructType\String_Localized[]|null
     */
    public function getTitel()
    {
        return $this->titel;
    }
    /**
     * This method is responsible for validating the values passed to the setTitel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTitel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTitelForArrayConstraintsFromSetTitel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kontaktpersonTitelItem) {
            // validation for constraint: itemType
            if (!$kontaktpersonTitelItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($kontaktpersonTitelItem) ? get_class($kontaktpersonTitelItem) : sprintf('%s(%s)', gettype($kontaktpersonTitelItem), var_export($kontaktpersonTitelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The titel property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set titel value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $titel
     * @return \StructType\Kontaktperson
     */
    public function setTitel(array $titel = array())
    {
        // validation for constraint: array
        if ('' !== ($titelArrayErrorMessage = self::validateTitelForArrayConstraintsFromSetTitel($titel))) {
            throw new \InvalidArgumentException($titelArrayErrorMessage, __LINE__);
        }
        $this->titel = $titel;
        return $this;
    }
    /**
     * Add item to titel value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Kontaktperson
     */
    public function addToTitel(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The titel property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->titel[] = $item;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \StructType\Kontaktperson
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get familienname value
     * @return string|null
     */
    public function getFamilienname()
    {
        return $this->familienname;
    }
    /**
     * Set familienname value
     * @param string $familienname
     * @return \StructType\Kontaktperson
     */
    public function setFamilienname($familienname = null)
    {
        // validation for constraint: string
        if (!is_null($familienname) && !is_string($familienname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($familienname, true), gettype($familienname)), __LINE__);
        }
        $this->familienname = $familienname;
        return $this;
    }
    /**
     * Get position value
     * @return \StructType\String_Localized[]|null
     */
    public function getPosition()
    {
        return $this->position;
    }
    /**
     * This method is responsible for validating the values passed to the setPosition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPosition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePositionForArrayConstraintsFromSetPosition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kontaktpersonPositionItem) {
            // validation for constraint: itemType
            if (!$kontaktpersonPositionItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($kontaktpersonPositionItem) ? get_class($kontaktpersonPositionItem) : sprintf('%s(%s)', gettype($kontaktpersonPositionItem), var_export($kontaktpersonPositionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The position property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set position value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $position
     * @return \StructType\Kontaktperson
     */
    public function setPosition(array $position = array())
    {
        // validation for constraint: array
        if ('' !== ($positionArrayErrorMessage = self::validatePositionForArrayConstraintsFromSetPosition($position))) {
            throw new \InvalidArgumentException($positionArrayErrorMessage, __LINE__);
        }
        $this->position = $position;
        return $this;
    }
    /**
     * Add item to position value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Kontaktperson
     */
    public function addToPosition(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The position property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->position[] = $item;
        return $this;
    }
    /**
     * Get sprechzeiten value
     * @return \StructType\String_Localized[]|null
     */
    public function getSprechzeiten()
    {
        return $this->sprechzeiten;
    }
    /**
     * This method is responsible for validating the values passed to the setSprechzeiten method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSprechzeiten method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSprechzeitenForArrayConstraintsFromSetSprechzeiten(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kontaktpersonSprechzeitenItem) {
            // validation for constraint: itemType
            if (!$kontaktpersonSprechzeitenItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($kontaktpersonSprechzeitenItem) ? get_class($kontaktpersonSprechzeitenItem) : sprintf('%s(%s)', gettype($kontaktpersonSprechzeitenItem), var_export($kontaktpersonSprechzeitenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sprechzeiten property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sprechzeiten value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $sprechzeiten
     * @return \StructType\Kontaktperson
     */
    public function setSprechzeiten(array $sprechzeiten = array())
    {
        // validation for constraint: array
        if ('' !== ($sprechzeitenArrayErrorMessage = self::validateSprechzeitenForArrayConstraintsFromSetSprechzeiten($sprechzeiten))) {
            throw new \InvalidArgumentException($sprechzeitenArrayErrorMessage, __LINE__);
        }
        $this->sprechzeiten = $sprechzeiten;
        return $this;
    }
    /**
     * Add item to sprechzeiten value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Kontaktperson
     */
    public function addToSprechzeiten(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The sprechzeiten property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sprechzeiten[] = $item;
        return $this;
    }
    /**
     * Get raum value
     * @return string|null
     */
    public function getRaum()
    {
        return $this->raum;
    }
    /**
     * Set raum value
     * @param string $raum
     * @return \StructType\Kontaktperson
     */
    public function setRaum($raum = null)
    {
        // validation for constraint: string
        if (!is_null($raum) && !is_string($raum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($raum, true), gettype($raum)), __LINE__);
        }
        $this->raum = $raum;
        return $this;
    }
    /**
     * Get anschrift value
     * @return \StructType\Anschrift[]|null
     */
    public function getAnschrift()
    {
        return $this->anschrift;
    }
    /**
     * This method is responsible for validating the values passed to the setAnschrift method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnschrift method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAnschriftForArrayConstraintsFromSetAnschrift(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kontaktpersonAnschriftItem) {
            // validation for constraint: itemType
            if (!$kontaktpersonAnschriftItem instanceof \StructType\Anschrift) {
                $invalidValues[] = is_object($kontaktpersonAnschriftItem) ? get_class($kontaktpersonAnschriftItem) : sprintf('%s(%s)', gettype($kontaktpersonAnschriftItem), var_export($kontaktpersonAnschriftItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The anschrift property can only contain items of type \StructType\Anschrift, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set anschrift value
     * @throws \InvalidArgumentException
     * @param \StructType\Anschrift[] $anschrift
     * @return \StructType\Kontaktperson
     */
    public function setAnschrift(array $anschrift = array())
    {
        // validation for constraint: array
        if ('' !== ($anschriftArrayErrorMessage = self::validateAnschriftForArrayConstraintsFromSetAnschrift($anschrift))) {
            throw new \InvalidArgumentException($anschriftArrayErrorMessage, __LINE__);
        }
        $this->anschrift = $anschrift;
        return $this;
    }
    /**
     * Add item to anschrift value
     * @throws \InvalidArgumentException
     * @param \StructType\Anschrift $item
     * @return \StructType\Kontaktperson
     */
    public function addToAnschrift(\StructType\Anschrift $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Anschrift) {
            throw new \InvalidArgumentException(sprintf('The anschrift property can only contain items of type \StructType\Anschrift, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->anschrift[] = $item;
        return $this;
    }
    /**
     * Get erreichbarkeit value
     * @return \StructType\Erreichbarkeit[]|null
     */
    public function getErreichbarkeit()
    {
        return $this->erreichbarkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setErreichbarkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setErreichbarkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErreichbarkeitForArrayConstraintsFromSetErreichbarkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kontaktpersonErreichbarkeitItem) {
            // validation for constraint: itemType
            if (!$kontaktpersonErreichbarkeitItem instanceof \StructType\Erreichbarkeit) {
                $invalidValues[] = is_object($kontaktpersonErreichbarkeitItem) ? get_class($kontaktpersonErreichbarkeitItem) : sprintf('%s(%s)', gettype($kontaktpersonErreichbarkeitItem), var_export($kontaktpersonErreichbarkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The erreichbarkeit property can only contain items of type \StructType\Erreichbarkeit, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set erreichbarkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Erreichbarkeit[] $erreichbarkeit
     * @return \StructType\Kontaktperson
     */
    public function setErreichbarkeit(array $erreichbarkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($erreichbarkeitArrayErrorMessage = self::validateErreichbarkeitForArrayConstraintsFromSetErreichbarkeit($erreichbarkeit))) {
            throw new \InvalidArgumentException($erreichbarkeitArrayErrorMessage, __LINE__);
        }
        $this->erreichbarkeit = $erreichbarkeit;
        return $this;
    }
    /**
     * Add item to erreichbarkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Erreichbarkeit $item
     * @return \StructType\Kontaktperson
     */
    public function addToErreichbarkeit(\StructType\Erreichbarkeit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Erreichbarkeit) {
            throw new \InvalidArgumentException(sprintf('The erreichbarkeit property can only contain items of type \StructType\Erreichbarkeit, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->erreichbarkeit[] = $item;
        return $this;
    }
    /**
     * Get internetadresse value
     * @return \StructType\HyperlinkErweitert[]|null
     */
    public function getInternetadresse()
    {
        return $this->internetadresse;
    }
    /**
     * This method is responsible for validating the values passed to the setInternetadresse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInternetadresse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInternetadresseForArrayConstraintsFromSetInternetadresse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kontaktpersonInternetadresseItem) {
            // validation for constraint: itemType
            if (!$kontaktpersonInternetadresseItem instanceof \StructType\HyperlinkErweitert) {
                $invalidValues[] = is_object($kontaktpersonInternetadresseItem) ? get_class($kontaktpersonInternetadresseItem) : sprintf('%s(%s)', gettype($kontaktpersonInternetadresseItem), var_export($kontaktpersonInternetadresseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The internetadresse property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set internetadresse value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert[] $internetadresse
     * @return \StructType\Kontaktperson
     */
    public function setInternetadresse(array $internetadresse = array())
    {
        // validation for constraint: array
        if ('' !== ($internetadresseArrayErrorMessage = self::validateInternetadresseForArrayConstraintsFromSetInternetadresse($internetadresse))) {
            throw new \InvalidArgumentException($internetadresseArrayErrorMessage, __LINE__);
        }
        $this->internetadresse = $internetadresse;
        return $this;
    }
    /**
     * Add item to internetadresse value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert $item
     * @return \StructType\Kontaktperson
     */
    public function addToInternetadresse(\StructType\HyperlinkErweitert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HyperlinkErweitert) {
            throw new \InvalidArgumentException(sprintf('The internetadresse property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->internetadresse[] = $item;
        return $this;
    }
    /**
     * Get zustaendigkeit value
     * @return \StructType\ZustaendigkeitPerson[]|null
     */
    public function getZustaendigkeit()
    {
        return $this->zustaendigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setZustaendigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZustaendigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZustaendigkeitForArrayConstraintsFromSetZustaendigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kontaktpersonZustaendigkeitItem) {
            // validation for constraint: itemType
            if (!$kontaktpersonZustaendigkeitItem instanceof \StructType\ZustaendigkeitPerson) {
                $invalidValues[] = is_object($kontaktpersonZustaendigkeitItem) ? get_class($kontaktpersonZustaendigkeitItem) : sprintf('%s(%s)', gettype($kontaktpersonZustaendigkeitItem), var_export($kontaktpersonZustaendigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zustaendigkeit property can only contain items of type \StructType\ZustaendigkeitPerson, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zustaendigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\ZustaendigkeitPerson[] $zustaendigkeit
     * @return \StructType\Kontaktperson
     */
    public function setZustaendigkeit(array $zustaendigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($zustaendigkeitArrayErrorMessage = self::validateZustaendigkeitForArrayConstraintsFromSetZustaendigkeit($zustaendigkeit))) {
            throw new \InvalidArgumentException($zustaendigkeitArrayErrorMessage, __LINE__);
        }
        $this->zustaendigkeit = $zustaendigkeit;
        return $this;
    }
    /**
     * Add item to zustaendigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\ZustaendigkeitPerson $item
     * @return \StructType\Kontaktperson
     */
    public function addToZustaendigkeit(\StructType\ZustaendigkeitPerson $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ZustaendigkeitPerson) {
            throw new \InvalidArgumentException(sprintf('The zustaendigkeit property can only contain items of type \StructType\ZustaendigkeitPerson, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zustaendigkeit[] = $item;
        return $this;
    }
    /**
     * Get herausgeber value
     * @return \StructType\Herausgeber|null
     */
    public function getHerausgeber()
    {
        return $this->herausgeber;
    }
    /**
     * Set herausgeber value
     * @param \StructType\Herausgeber $herausgeber
     * @return \StructType\Kontaktperson
     */
    public function setHerausgeber(\StructType\Herausgeber $herausgeber = null)
    {
        $this->herausgeber = $herausgeber;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kontaktpersonGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$kontaktpersonGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($kontaktpersonGueltigkeitItem) ? get_class($kontaktpersonGueltigkeitItem) : sprintf('%s(%s)', gettype($kontaktpersonGueltigkeitItem), var_export($kontaktpersonGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\Kontaktperson
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Kontaktperson
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
}
