<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Kommunikationssystem StructType
 * Meta information extracted from the WSDL
 * - documentation: Datentyp für Angaben zu Kommunikationskanälen für maschinelle Erreichbarkeit. Zum Beispiel EGVP oder DVDV.
 * @subpackage Structs
 */
class Kommunikationssystem extends AbstractStructBase
{
    /**
     * The kanal
     * Meta information extracted from the WSDL
     * - documentation: Der "kanal" gibt an, über welchen Kommunikationskanal eine Erreichbarkeit besteht. Die referenzierte Codeliste "Erreichbarkeit" aus dem XRepository bietet hier auch den Kanal "09 - Web". Dieser soll in XZuFi hier nicht genutzt
     * werden, sondern dafür Organisationseinheit.internetadresse.
     * @var \StructType\Code_KommunikationssystemTyp
     */
    public $kanal;
    /**
     * The kennung
     * Meta information extracted from the WSDL
     * - documentation: Die "kennung" beinhaltet die konkreten Angaben zur Erreichbarkeit über einen Kommunikationskanal, d.h. die Telefonnummer, Faxnummer, E-Mail-Adresse oder dergleichen. Die Kennung soll strukturiert erfasst werden.
     * @var string
     */
    public $kennung;
    /**
     * The kennungzusatz
     * Meta information extracted from the WSDL
     * - documentation: Optionaler Zusatz zur Kennung. Hier sollen keine Bemerkungen zur Erreichbarkeit o.ä. eingetragen werden. Es handelt sich um einen optionalen Zusatz der eigentlichen Kennung.
     * - minOccurs: 0
     * @var string
     */
    public $kennungzusatz;
    /**
     * The gueltigkeit
     * Meta information extracted from the WSDL
     * - documentation: Gueltigkeit definiert die Zeiträume in denen das Objekt gültig ist. Zeiträume können nacheinander liegen oder sich überschneiden.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Zeitraum[]
     */
    public $gueltigkeit;
    /**
     * Constructor method for Kommunikationssystem
     * @uses Kommunikationssystem::setKanal()
     * @uses Kommunikationssystem::setKennung()
     * @uses Kommunikationssystem::setKennungzusatz()
     * @uses Kommunikationssystem::setGueltigkeit()
     * @param \StructType\Code_KommunikationssystemTyp $kanal
     * @param string $kennung
     * @param string $kennungzusatz
     * @param \StructType\Zeitraum[] $gueltigkeit
     */
    public function __construct(\StructType\Code_KommunikationssystemTyp $kanal = null, $kennung = null, $kennungzusatz = null, array $gueltigkeit = array())
    {
        $this
            ->setKanal($kanal)
            ->setKennung($kennung)
            ->setKennungzusatz($kennungzusatz)
            ->setGueltigkeit($gueltigkeit);
    }
    /**
     * Get kanal value
     * @return \StructType\Code_KommunikationssystemTyp|null
     */
    public function getKanal()
    {
        return $this->kanal;
    }
    /**
     * Set kanal value
     * @param \StructType\Code_KommunikationssystemTyp $kanal
     * @return \StructType\Kommunikationssystem
     */
    public function setKanal(\StructType\Code_KommunikationssystemTyp $kanal = null)
    {
        $this->kanal = $kanal;
        return $this;
    }
    /**
     * Get kennung value
     * @return string|null
     */
    public function getKennung()
    {
        return $this->kennung;
    }
    /**
     * Set kennung value
     * @param string $kennung
     * @return \StructType\Kommunikationssystem
     */
    public function setKennung($kennung = null)
    {
        // validation for constraint: string
        if (!is_null($kennung) && !is_string($kennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kennung, true), gettype($kennung)), __LINE__);
        }
        $this->kennung = $kennung;
        return $this;
    }
    /**
     * Get kennungzusatz value
     * @return string|null
     */
    public function getKennungzusatz()
    {
        return $this->kennungzusatz;
    }
    /**
     * Set kennungzusatz value
     * @param string $kennungzusatz
     * @return \StructType\Kommunikationssystem
     */
    public function setKennungzusatz($kennungzusatz = null)
    {
        // validation for constraint: string
        if (!is_null($kennungzusatz) && !is_string($kennungzusatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kennungzusatz, true), gettype($kennungzusatz)), __LINE__);
        }
        $this->kennungzusatz = $kennungzusatz;
        return $this;
    }
    /**
     * Get gueltigkeit value
     * @return \StructType\Zeitraum[]|null
     */
    public function getGueltigkeit()
    {
        return $this->gueltigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setGueltigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGueltigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGueltigkeitForArrayConstraintsFromSetGueltigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kommunikationssystemGueltigkeitItem) {
            // validation for constraint: itemType
            if (!$kommunikationssystemGueltigkeitItem instanceof \StructType\Zeitraum) {
                $invalidValues[] = is_object($kommunikationssystemGueltigkeitItem) ? get_class($kommunikationssystemGueltigkeitItem) : sprintf('%s(%s)', gettype($kommunikationssystemGueltigkeitItem), var_export($kommunikationssystemGueltigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum[] $gueltigkeit
     * @return \StructType\Kommunikationssystem
     */
    public function setGueltigkeit(array $gueltigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($gueltigkeitArrayErrorMessage = self::validateGueltigkeitForArrayConstraintsFromSetGueltigkeit($gueltigkeit))) {
            throw new \InvalidArgumentException($gueltigkeitArrayErrorMessage, __LINE__);
        }
        $this->gueltigkeit = $gueltigkeit;
        return $this;
    }
    /**
     * Add item to gueltigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Zeitraum $item
     * @return \StructType\Kommunikationssystem
     */
    public function addToGueltigkeit(\StructType\Zeitraum $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Zeitraum) {
            throw new \InvalidArgumentException(sprintf('The gueltigkeit property can only contain items of type \StructType\Zeitraum, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->gueltigkeit[] = $item;
        return $this;
    }
}
