<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KnotType StructType
 * @subpackage Structs
 */
class KnotType extends AbstractStructBase
{
    /**
     * The value
     * @var float
     */
    public $value;
    /**
     * The multiplicity
     * @var int
     */
    public $multiplicity;
    /**
     * The weight
     * @var float
     */
    public $weight;
    /**
     * Constructor method for KnotType
     * @uses KnotType::setValue()
     * @uses KnotType::setMultiplicity()
     * @uses KnotType::setWeight()
     * @param float $value
     * @param int $multiplicity
     * @param float $weight
     */
    public function __construct($value = null, $multiplicity = null, $weight = null)
    {
        $this
            ->setValue($value)
            ->setMultiplicity($multiplicity)
            ->setWeight($weight);
    }
    /**
     * Get value value
     * @return float|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \StructType\KnotType
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Get multiplicity value
     * @return int|null
     */
    public function getMultiplicity()
    {
        return $this->multiplicity;
    }
    /**
     * Set multiplicity value
     * @param int $multiplicity
     * @return \StructType\KnotType
     */
    public function setMultiplicity($multiplicity = null)
    {
        // validation for constraint: int
        if (!is_null($multiplicity) && !(is_int($multiplicity) || ctype_digit($multiplicity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($multiplicity, true), gettype($multiplicity)), __LINE__);
        }
        $this->multiplicity = $multiplicity;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \StructType\KnotType
     */
    public function setWeight($weight = null)
    {
        // validation for constraint: float
        if (!is_null($weight) && !(is_float($weight) || is_numeric($weight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight, true), gettype($weight)), __LINE__);
        }
        $this->weight = $weight;
        return $this;
    }
}
