<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Identifikator StructType
 * Meta information extracted from the WSDL
 * - documentation: Typ zur Abbildung von Identifikatoren. Zeichenkette zur eindeutigen Unterscheidung einer Instanz eines Objekts innerhalb eines Identifikationsschemas von allen anderen Objekten im selben Schema mit Zusatzinformationen.
 * @subpackage Structs
 */
class Identifikator extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The schemeAgencyID
     * Meta information extracted from the WSDL
     * - documentation: ID der Stelle, welche das Identifikationsschema verwaltet.
     * - use: optional
     * @var string
     */
    public $schemeAgencyID;
    /**
     * The schemeAgencyName
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung der Stelle, welche das Identifikationsschema verwaltet.
     * - use: optional
     * @var string
     */
    public $schemeAgencyName;
    /**
     * The schemeDataURI
     * Meta information extracted from the WSDL
     * - documentation: URI, welche definiert, wo sich die Daten des Identifikationsschemas befinden.
     * - use: optional
     * @var string
     */
    public $schemeDataURI;
    /**
     * The schemeID
     * Meta information extracted from the WSDL
     * - documentation: ID des Identifikationsschemas.
     * - use: optional
     * @var string
     */
    public $schemeID;
    /**
     * The schemeName
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung des Identifikationsschemas.
     * - use: optional
     * @var string
     */
    public $schemeName;
    /**
     * The schemeURI
     * Meta information extracted from the WSDL
     * - documentation: URI, welche definiert, wo sich das Identifikationsschema befindet.
     * - use: optional
     * @var string
     */
    public $schemeURI;
    /**
     * The schemeVersionID
     * Meta information extracted from the WSDL
     * - documentation: Version des Identifikationsschemas.
     * - use: optional
     * @var string
     */
    public $schemeVersionID;
    /**
     * Constructor method for Identifikator
     * @uses Identifikator::set_()
     * @uses Identifikator::setSchemeAgencyID()
     * @uses Identifikator::setSchemeAgencyName()
     * @uses Identifikator::setSchemeDataURI()
     * @uses Identifikator::setSchemeID()
     * @uses Identifikator::setSchemeName()
     * @uses Identifikator::setSchemeURI()
     * @uses Identifikator::setSchemeVersionID()
     * @param string $_
     * @param string $schemeAgencyID
     * @param string $schemeAgencyName
     * @param string $schemeDataURI
     * @param string $schemeID
     * @param string $schemeName
     * @param string $schemeURI
     * @param string $schemeVersionID
     */
    public function __construct($_ = null, $schemeAgencyID = null, $schemeAgencyName = null, $schemeDataURI = null, $schemeID = null, $schemeName = null, $schemeURI = null, $schemeVersionID = null)
    {
        $this
            ->set_($_)
            ->setSchemeAgencyID($schemeAgencyID)
            ->setSchemeAgencyName($schemeAgencyName)
            ->setSchemeDataURI($schemeDataURI)
            ->setSchemeID($schemeID)
            ->setSchemeName($schemeName)
            ->setSchemeURI($schemeURI)
            ->setSchemeVersionID($schemeVersionID);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\Identifikator
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get schemeAgencyID value
     * @return string|null
     */
    public function getSchemeAgencyID()
    {
        return $this->schemeAgencyID;
    }
    /**
     * Set schemeAgencyID value
     * @param string $schemeAgencyID
     * @return \StructType\Identifikator
     */
    public function setSchemeAgencyID($schemeAgencyID = null)
    {
        // validation for constraint: string
        if (!is_null($schemeAgencyID) && !is_string($schemeAgencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeAgencyID, true), gettype($schemeAgencyID)), __LINE__);
        }
        $this->schemeAgencyID = $schemeAgencyID;
        return $this;
    }
    /**
     * Get schemeAgencyName value
     * @return string|null
     */
    public function getSchemeAgencyName()
    {
        return $this->schemeAgencyName;
    }
    /**
     * Set schemeAgencyName value
     * @param string $schemeAgencyName
     * @return \StructType\Identifikator
     */
    public function setSchemeAgencyName($schemeAgencyName = null)
    {
        // validation for constraint: string
        if (!is_null($schemeAgencyName) && !is_string($schemeAgencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeAgencyName, true), gettype($schemeAgencyName)), __LINE__);
        }
        $this->schemeAgencyName = $schemeAgencyName;
        return $this;
    }
    /**
     * Get schemeDataURI value
     * @return string|null
     */
    public function getSchemeDataURI()
    {
        return $this->schemeDataURI;
    }
    /**
     * Set schemeDataURI value
     * @param string $schemeDataURI
     * @return \StructType\Identifikator
     */
    public function setSchemeDataURI($schemeDataURI = null)
    {
        // validation for constraint: string
        if (!is_null($schemeDataURI) && !is_string($schemeDataURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeDataURI, true), gettype($schemeDataURI)), __LINE__);
        }
        $this->schemeDataURI = $schemeDataURI;
        return $this;
    }
    /**
     * Get schemeID value
     * @return string|null
     */
    public function getSchemeID()
    {
        return $this->schemeID;
    }
    /**
     * Set schemeID value
     * @param string $schemeID
     * @return \StructType\Identifikator
     */
    public function setSchemeID($schemeID = null)
    {
        // validation for constraint: string
        if (!is_null($schemeID) && !is_string($schemeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeID, true), gettype($schemeID)), __LINE__);
        }
        $this->schemeID = $schemeID;
        return $this;
    }
    /**
     * Get schemeName value
     * @return string|null
     */
    public function getSchemeName()
    {
        return $this->schemeName;
    }
    /**
     * Set schemeName value
     * @param string $schemeName
     * @return \StructType\Identifikator
     */
    public function setSchemeName($schemeName = null)
    {
        // validation for constraint: string
        if (!is_null($schemeName) && !is_string($schemeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeName, true), gettype($schemeName)), __LINE__);
        }
        $this->schemeName = $schemeName;
        return $this;
    }
    /**
     * Get schemeURI value
     * @return string|null
     */
    public function getSchemeURI()
    {
        return $this->schemeURI;
    }
    /**
     * Set schemeURI value
     * @param string $schemeURI
     * @return \StructType\Identifikator
     */
    public function setSchemeURI($schemeURI = null)
    {
        // validation for constraint: string
        if (!is_null($schemeURI) && !is_string($schemeURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeURI, true), gettype($schemeURI)), __LINE__);
        }
        $this->schemeURI = $schemeURI;
        return $this;
    }
    /**
     * Get schemeVersionID value
     * @return string|null
     */
    public function getSchemeVersionID()
    {
        return $this->schemeVersionID;
    }
    /**
     * Set schemeVersionID value
     * @param string $schemeVersionID
     * @return \StructType\Identifikator
     */
    public function setSchemeVersionID($schemeVersionID = null)
    {
        // validation for constraint: string
        if (!is_null($schemeVersionID) && !is_string($schemeVersionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeVersionID, true), gettype($schemeVersionID)), __LINE__);
        }
        $this->schemeVersionID = $schemeVersionID;
        return $this;
    }
}
