<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HyperlinkErweitert StructType
 * Meta information extracted from the WSDL
 * - documentation: Datentyp zur Abbildung von Links mit Titel, Beschreibung, Darstellungsposition und Sprache.
 * @subpackage Structs
 */
class HyperlinkErweitert extends AbstractStructBase
{
    /**
     * The uri
     * Meta information extracted from the WSDL
     * - documentation: URI des Links
     * @var string
     */
    public $uri;
    /**
     * The titel
     * Meta information extracted from the WSDL
     * - documentation: Titel der URI
     * - minOccurs: 0
     * @var string
     */
    public $titel;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Beschreibung der URI, z.B. kurze Hinweise zur Zielseite
     * - minOccurs: 0
     * @var string
     */
    public $beschreibung;
    /**
     * The positionDarstellung
     * Meta information extracted from the WSDL
     * - documentation: Position in der gesamten Darstellung der Links.
     * - minOccurs: 0
     * @var int
     */
    public $positionDarstellung;
    /**
     * The languageCode
     * Meta information extracted from the WSDL
     * - documentation: Code der Sprache des Texts. Abgebildet mit W3C-Datentyp xs:language (http://www.w3.org/TR/xmlschema-2/#language)
     * - use: optional
     * @var string
     */
    public $languageCode;
    /**
     * Constructor method for HyperlinkErweitert
     * @uses HyperlinkErweitert::setUri()
     * @uses HyperlinkErweitert::setTitel()
     * @uses HyperlinkErweitert::setBeschreibung()
     * @uses HyperlinkErweitert::setPositionDarstellung()
     * @uses HyperlinkErweitert::setLanguageCode()
     * @param string $uri
     * @param string $titel
     * @param string $beschreibung
     * @param int $positionDarstellung
     * @param string $languageCode
     */
    public function __construct($uri = null, $titel = null, $beschreibung = null, $positionDarstellung = null, $languageCode = null)
    {
        $this
            ->setUri($uri)
            ->setTitel($titel)
            ->setBeschreibung($beschreibung)
            ->setPositionDarstellung($positionDarstellung)
            ->setLanguageCode($languageCode);
    }
    /**
     * Get uri value
     * @return string|null
     */
    public function getUri()
    {
        return $this->uri;
    }
    /**
     * Set uri value
     * @param string $uri
     * @return \StructType\HyperlinkErweitert
     */
    public function setUri($uri = null)
    {
        // validation for constraint: string
        if (!is_null($uri) && !is_string($uri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uri, true), gettype($uri)), __LINE__);
        }
        $this->uri = $uri;
        return $this;
    }
    /**
     * Get titel value
     * @return string|null
     */
    public function getTitel()
    {
        return $this->titel;
    }
    /**
     * Set titel value
     * @param string $titel
     * @return \StructType\HyperlinkErweitert
     */
    public function setTitel($titel = null)
    {
        // validation for constraint: string
        if (!is_null($titel) && !is_string($titel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titel, true), gettype($titel)), __LINE__);
        }
        $this->titel = $titel;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return string|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * Set beschreibung value
     * @param string $beschreibung
     * @return \StructType\HyperlinkErweitert
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Get positionDarstellung value
     * @return int|null
     */
    public function getPositionDarstellung()
    {
        return $this->positionDarstellung;
    }
    /**
     * Set positionDarstellung value
     * @param int $positionDarstellung
     * @return \StructType\HyperlinkErweitert
     */
    public function setPositionDarstellung($positionDarstellung = null)
    {
        // validation for constraint: int
        if (!is_null($positionDarstellung) && !(is_int($positionDarstellung) || ctype_digit($positionDarstellung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($positionDarstellung, true), gettype($positionDarstellung)), __LINE__);
        }
        $this->positionDarstellung = $positionDarstellung;
        return $this;
    }
    /**
     * Get languageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }
    /**
     * Set languageCode value
     * @param string $languageCode
     * @return \StructType\HyperlinkErweitert
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        $this->languageCode = $languageCode;
        return $this;
    }
}
