<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GridType StructType
 * @subpackage Structs
 */
class GridType extends AbstractStructBase
{
    /**
     * The limits
     * @var \StructType\GridLimitsType
     */
    public $limits;
    /**
     * The axisLabels
     * @var list
     */
    public $axisLabels;
    /**
     * The axisName
     * @var string
     */
    public $axisName;
    /**
     * The dimension
     * @var int
     */
    public $dimension;
    /**
     * Constructor method for GridType
     * @uses GridType::setLimits()
     * @uses GridType::setAxisLabels()
     * @uses GridType::setAxisName()
     * @uses GridType::setDimension()
     * @param \StructType\GridLimitsType $limits
     * @param list $axisLabels
     * @param string $axisName
     * @param int $dimension
     */
    public function __construct(\StructType\GridLimitsType $limits = null, list $axisLabels = null, $axisName = null, $dimension = null)
    {
        $this
            ->setLimits($limits)
            ->setAxisLabels($axisLabels)
            ->setAxisName($axisName)
            ->setDimension($dimension);
    }
    /**
     * Get limits value
     * @return \StructType\GridLimitsType|null
     */
    public function getLimits()
    {
        return $this->limits;
    }
    /**
     * Set limits value
     * @param \StructType\GridLimitsType $limits
     * @return \StructType\GridType
     */
    public function setLimits(\StructType\GridLimitsType $limits = null)
    {
        $this->limits = $limits;
        return $this;
    }
    /**
     * Get axisLabels value
     * @return list|null
     */
    public function getAxisLabels()
    {
        return $this->axisLabels;
    }
    /**
     * Set axisLabels value
     * @param list $axisLabels
     * @return \StructType\GridType
     */
    public function setAxisLabels(list $axisLabels = null)
    {
        $this->axisLabels = $axisLabels;
        return $this;
    }
    /**
     * Get axisName value
     * @return string|null
     */
    public function getAxisName()
    {
        return $this->axisName;
    }
    /**
     * Set axisName value
     * @param string $axisName
     * @return \StructType\GridType
     */
    public function setAxisName($axisName = null)
    {
        // validation for constraint: string
        if (!is_null($axisName) && !is_string($axisName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axisName, true), gettype($axisName)), __LINE__);
        }
        $this->axisName = $axisName;
        return $this;
    }
    /**
     * Get dimension value
     * @return int|null
     */
    public function getDimension()
    {
        return $this->dimension;
    }
    /**
     * Set dimension value
     * @param int $dimension
     * @return \StructType\GridType
     */
    public function setDimension($dimension = null)
    {
        // validation for constraint: int
        if (!is_null($dimension) && !(is_int($dimension) || ctype_digit($dimension))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dimension, true), gettype($dimension)), __LINE__);
        }
        $this->dimension = $dimension;
        return $this;
    }
}
