<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeometricComplexType StructType
 * @subpackage Structs
 */
class GeometricComplexType extends AbstractStructBase
{
    /**
     * The element
     * @var \StructType\GeometricPrimitivePropertyType
     */
    public $element;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for GeometricComplexType
     * @uses GeometricComplexType::setElement()
     * @uses GeometricComplexType::setAggregationType()
     * @param \StructType\GeometricPrimitivePropertyType $element
     * @param string $aggregationType
     */
    public function __construct(\StructType\GeometricPrimitivePropertyType $element = null, $aggregationType = null)
    {
        $this
            ->setElement($element)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get element value
     * @return \StructType\GeometricPrimitivePropertyType|null
     */
    public function getElement()
    {
        return $this->element;
    }
    /**
     * Set element value
     * @param \StructType\GeometricPrimitivePropertyType $element
     * @return \StructType\GeometricComplexType
     */
    public function setElement(\StructType\GeometricPrimitivePropertyType $element = null)
    {
        $this->element = $element;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\GeometricComplexType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
