<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EngineeringCRSType StructType
 * @subpackage Structs
 */
class EngineeringCRSType extends AbstractStructBase
{
    /**
     * The affineCS
     * @var \StructType\AffineCSPropertyType
     */
    public $affineCS;
    /**
     * The cartesianCS
     * @var \StructType\CartesianCSPropertyType
     */
    public $cartesianCS;
    /**
     * The cylindricalCS
     * @var \StructType\CylindricalCSPropertyType
     */
    public $cylindricalCS;
    /**
     * The linearCS
     * @var \StructType\LinearCSPropertyType
     */
    public $linearCS;
    /**
     * The polarCS
     * @var \StructType\PolarCSPropertyType
     */
    public $polarCS;
    /**
     * The sphericalCS
     * @var \StructType\SphericalCSPropertyType
     */
    public $sphericalCS;
    /**
     * The userDefinedCS
     * @var \StructType\UserDefinedCSPropertyType
     */
    public $userDefinedCS;
    /**
     * The coordinateSystem
     * @var \StructType\CoordinateSystemPropertyType
     */
    public $coordinateSystem;
    /**
     * The engineeringDatum
     * @var \StructType\EngineeringDatumPropertyType
     */
    public $engineeringDatum;
    /**
     * Constructor method for EngineeringCRSType
     * @uses EngineeringCRSType::setAffineCS()
     * @uses EngineeringCRSType::setCartesianCS()
     * @uses EngineeringCRSType::setCylindricalCS()
     * @uses EngineeringCRSType::setLinearCS()
     * @uses EngineeringCRSType::setPolarCS()
     * @uses EngineeringCRSType::setSphericalCS()
     * @uses EngineeringCRSType::setUserDefinedCS()
     * @uses EngineeringCRSType::setCoordinateSystem()
     * @uses EngineeringCRSType::setEngineeringDatum()
     * @param \StructType\AffineCSPropertyType $affineCS
     * @param \StructType\CartesianCSPropertyType $cartesianCS
     * @param \StructType\CylindricalCSPropertyType $cylindricalCS
     * @param \StructType\LinearCSPropertyType $linearCS
     * @param \StructType\PolarCSPropertyType $polarCS
     * @param \StructType\SphericalCSPropertyType $sphericalCS
     * @param \StructType\UserDefinedCSPropertyType $userDefinedCS
     * @param \StructType\CoordinateSystemPropertyType $coordinateSystem
     * @param \StructType\EngineeringDatumPropertyType $engineeringDatum
     */
    public function __construct(\StructType\AffineCSPropertyType $affineCS = null, \StructType\CartesianCSPropertyType $cartesianCS = null, \StructType\CylindricalCSPropertyType $cylindricalCS = null, \StructType\LinearCSPropertyType $linearCS = null, \StructType\PolarCSPropertyType $polarCS = null, \StructType\SphericalCSPropertyType $sphericalCS = null, \StructType\UserDefinedCSPropertyType $userDefinedCS = null, \StructType\CoordinateSystemPropertyType $coordinateSystem = null, \StructType\EngineeringDatumPropertyType $engineeringDatum = null)
    {
        $this
            ->setAffineCS($affineCS)
            ->setCartesianCS($cartesianCS)
            ->setCylindricalCS($cylindricalCS)
            ->setLinearCS($linearCS)
            ->setPolarCS($polarCS)
            ->setSphericalCS($sphericalCS)
            ->setUserDefinedCS($userDefinedCS)
            ->setCoordinateSystem($coordinateSystem)
            ->setEngineeringDatum($engineeringDatum);
    }
    /**
     * Get affineCS value
     * @return \StructType\AffineCSPropertyType|null
     */
    public function getAffineCS()
    {
        return $this->affineCS;
    }
    /**
     * Set affineCS value
     * @param \StructType\AffineCSPropertyType $affineCS
     * @return \StructType\EngineeringCRSType
     */
    public function setAffineCS(\StructType\AffineCSPropertyType $affineCS = null)
    {
        $this->affineCS = $affineCS;
        return $this;
    }
    /**
     * Get cartesianCS value
     * @return \StructType\CartesianCSPropertyType|null
     */
    public function getCartesianCS()
    {
        return $this->cartesianCS;
    }
    /**
     * Set cartesianCS value
     * @param \StructType\CartesianCSPropertyType $cartesianCS
     * @return \StructType\EngineeringCRSType
     */
    public function setCartesianCS(\StructType\CartesianCSPropertyType $cartesianCS = null)
    {
        $this->cartesianCS = $cartesianCS;
        return $this;
    }
    /**
     * Get cylindricalCS value
     * @return \StructType\CylindricalCSPropertyType|null
     */
    public function getCylindricalCS()
    {
        return $this->cylindricalCS;
    }
    /**
     * Set cylindricalCS value
     * @param \StructType\CylindricalCSPropertyType $cylindricalCS
     * @return \StructType\EngineeringCRSType
     */
    public function setCylindricalCS(\StructType\CylindricalCSPropertyType $cylindricalCS = null)
    {
        $this->cylindricalCS = $cylindricalCS;
        return $this;
    }
    /**
     * Get linearCS value
     * @return \StructType\LinearCSPropertyType|null
     */
    public function getLinearCS()
    {
        return $this->linearCS;
    }
    /**
     * Set linearCS value
     * @param \StructType\LinearCSPropertyType $linearCS
     * @return \StructType\EngineeringCRSType
     */
    public function setLinearCS(\StructType\LinearCSPropertyType $linearCS = null)
    {
        $this->linearCS = $linearCS;
        return $this;
    }
    /**
     * Get polarCS value
     * @return \StructType\PolarCSPropertyType|null
     */
    public function getPolarCS()
    {
        return $this->polarCS;
    }
    /**
     * Set polarCS value
     * @param \StructType\PolarCSPropertyType $polarCS
     * @return \StructType\EngineeringCRSType
     */
    public function setPolarCS(\StructType\PolarCSPropertyType $polarCS = null)
    {
        $this->polarCS = $polarCS;
        return $this;
    }
    /**
     * Get sphericalCS value
     * @return \StructType\SphericalCSPropertyType|null
     */
    public function getSphericalCS()
    {
        return $this->sphericalCS;
    }
    /**
     * Set sphericalCS value
     * @param \StructType\SphericalCSPropertyType $sphericalCS
     * @return \StructType\EngineeringCRSType
     */
    public function setSphericalCS(\StructType\SphericalCSPropertyType $sphericalCS = null)
    {
        $this->sphericalCS = $sphericalCS;
        return $this;
    }
    /**
     * Get userDefinedCS value
     * @return \StructType\UserDefinedCSPropertyType|null
     */
    public function getUserDefinedCS()
    {
        return $this->userDefinedCS;
    }
    /**
     * Set userDefinedCS value
     * @param \StructType\UserDefinedCSPropertyType $userDefinedCS
     * @return \StructType\EngineeringCRSType
     */
    public function setUserDefinedCS(\StructType\UserDefinedCSPropertyType $userDefinedCS = null)
    {
        $this->userDefinedCS = $userDefinedCS;
        return $this;
    }
    /**
     * Get coordinateSystem value
     * @return \StructType\CoordinateSystemPropertyType|null
     */
    public function getCoordinateSystem()
    {
        return $this->coordinateSystem;
    }
    /**
     * Set coordinateSystem value
     * @param \StructType\CoordinateSystemPropertyType $coordinateSystem
     * @return \StructType\EngineeringCRSType
     */
    public function setCoordinateSystem(\StructType\CoordinateSystemPropertyType $coordinateSystem = null)
    {
        $this->coordinateSystem = $coordinateSystem;
        return $this;
    }
    /**
     * Get engineeringDatum value
     * @return \StructType\EngineeringDatumPropertyType|null
     */
    public function getEngineeringDatum()
    {
        return $this->engineeringDatum;
    }
    /**
     * Set engineeringDatum value
     * @param \StructType\EngineeringDatumPropertyType $engineeringDatum
     * @return \StructType\EngineeringCRSType
     */
    public function setEngineeringDatum(\StructType\EngineeringDatumPropertyType $engineeringDatum = null)
    {
        $this->engineeringDatum = $engineeringDatum;
        return $this;
    }
}
