<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EdgeType StructType
 * @subpackage Structs
 */
class EdgeType extends AbstractStructBase
{
    /**
     * The container
     * @var \StructType\TopoSolidPropertyType
     */
    public $container;
    /**
     * The directedNode
     * @var \StructType\DirectedNodePropertyType
     */
    public $directedNode;
    /**
     * The directedFace
     * @var \StructType\DirectedFacePropertyType
     */
    public $directedFace;
    /**
     * The curveProperty
     * @var \StructType\CurvePropertyType
     */
    public $curveProperty;
    /**
     * The aggregationType
     * @var string
     */
    public $aggregationType;
    /**
     * Constructor method for EdgeType
     * @uses EdgeType::setContainer()
     * @uses EdgeType::setDirectedNode()
     * @uses EdgeType::setDirectedFace()
     * @uses EdgeType::setCurveProperty()
     * @uses EdgeType::setAggregationType()
     * @param \StructType\TopoSolidPropertyType $container
     * @param \StructType\DirectedNodePropertyType $directedNode
     * @param \StructType\DirectedFacePropertyType $directedFace
     * @param \StructType\CurvePropertyType $curveProperty
     * @param string $aggregationType
     */
    public function __construct(\StructType\TopoSolidPropertyType $container = null, \StructType\DirectedNodePropertyType $directedNode = null, \StructType\DirectedFacePropertyType $directedFace = null, \StructType\CurvePropertyType $curveProperty = null, $aggregationType = null)
    {
        $this
            ->setContainer($container)
            ->setDirectedNode($directedNode)
            ->setDirectedFace($directedFace)
            ->setCurveProperty($curveProperty)
            ->setAggregationType($aggregationType);
    }
    /**
     * Get container value
     * @return \StructType\TopoSolidPropertyType|null
     */
    public function getContainer()
    {
        return $this->container;
    }
    /**
     * Set container value
     * @param \StructType\TopoSolidPropertyType $container
     * @return \StructType\EdgeType
     */
    public function setContainer(\StructType\TopoSolidPropertyType $container = null)
    {
        $this->container = $container;
        return $this;
    }
    /**
     * Get directedNode value
     * @return \StructType\DirectedNodePropertyType|null
     */
    public function getDirectedNode()
    {
        return $this->directedNode;
    }
    /**
     * Set directedNode value
     * @param \StructType\DirectedNodePropertyType $directedNode
     * @return \StructType\EdgeType
     */
    public function setDirectedNode(\StructType\DirectedNodePropertyType $directedNode = null)
    {
        $this->directedNode = $directedNode;
        return $this;
    }
    /**
     * Get directedFace value
     * @return \StructType\DirectedFacePropertyType|null
     */
    public function getDirectedFace()
    {
        return $this->directedFace;
    }
    /**
     * Set directedFace value
     * @param \StructType\DirectedFacePropertyType $directedFace
     * @return \StructType\EdgeType
     */
    public function setDirectedFace(\StructType\DirectedFacePropertyType $directedFace = null)
    {
        $this->directedFace = $directedFace;
        return $this;
    }
    /**
     * Get curveProperty value
     * @return \StructType\CurvePropertyType|null
     */
    public function getCurveProperty()
    {
        return $this->curveProperty;
    }
    /**
     * Set curveProperty value
     * @param \StructType\CurvePropertyType $curveProperty
     * @return \StructType\EdgeType
     */
    public function setCurveProperty(\StructType\CurvePropertyType $curveProperty = null)
    {
        $this->curveProperty = $curveProperty;
        return $this;
    }
    /**
     * Get aggregationType value
     * @return string|null
     */
    public function getAggregationType()
    {
        return $this->aggregationType;
    }
    /**
     * Set aggregationType value
     * @param string $aggregationType
     * @return \StructType\EdgeType
     */
    public function setAggregationType($aggregationType = null)
    {
        // validation for constraint: string
        if (!is_null($aggregationType) && !is_string($aggregationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregationType, true), gettype($aggregationType)), __LINE__);
        }
        $this->aggregationType = $aggregationType;
        return $this;
    }
}
