<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DynamicFeatureType StructType
 * @subpackage Structs
 */
class DynamicFeatureType extends AbstractStructBase
{
    /**
     * The validTime
     * @var \StructType\TimePrimitivePropertyType
     */
    public $validTime;
    /**
     * The history
     * @var \StructType\HistoryPropertyType
     */
    public $history;
    /**
     * The dataSource
     * @var \StructType\StringOrRefType
     */
    public $dataSource;
    /**
     * The dataSourceReference
     * @var \StructType\ReferenceType
     */
    public $dataSourceReference;
    /**
     * Constructor method for DynamicFeatureType
     * @uses DynamicFeatureType::setValidTime()
     * @uses DynamicFeatureType::setHistory()
     * @uses DynamicFeatureType::setDataSource()
     * @uses DynamicFeatureType::setDataSourceReference()
     * @param \StructType\TimePrimitivePropertyType $validTime
     * @param \StructType\HistoryPropertyType $history
     * @param \StructType\StringOrRefType $dataSource
     * @param \StructType\ReferenceType $dataSourceReference
     */
    public function __construct(\StructType\TimePrimitivePropertyType $validTime = null, \StructType\HistoryPropertyType $history = null, \StructType\StringOrRefType $dataSource = null, \StructType\ReferenceType $dataSourceReference = null)
    {
        $this
            ->setValidTime($validTime)
            ->setHistory($history)
            ->setDataSource($dataSource)
            ->setDataSourceReference($dataSourceReference);
    }
    /**
     * Get validTime value
     * @return \StructType\TimePrimitivePropertyType|null
     */
    public function getValidTime()
    {
        return $this->validTime;
    }
    /**
     * Set validTime value
     * @param \StructType\TimePrimitivePropertyType $validTime
     * @return \StructType\DynamicFeatureType
     */
    public function setValidTime(\StructType\TimePrimitivePropertyType $validTime = null)
    {
        $this->validTime = $validTime;
        return $this;
    }
    /**
     * Get history value
     * @return \StructType\HistoryPropertyType|null
     */
    public function getHistory()
    {
        return $this->history;
    }
    /**
     * Set history value
     * @param \StructType\HistoryPropertyType $history
     * @return \StructType\DynamicFeatureType
     */
    public function setHistory(\StructType\HistoryPropertyType $history = null)
    {
        $this->history = $history;
        return $this;
    }
    /**
     * Get dataSource value
     * @return \StructType\StringOrRefType|null
     */
    public function getDataSource()
    {
        return $this->dataSource;
    }
    /**
     * Set dataSource value
     * @param \StructType\StringOrRefType $dataSource
     * @return \StructType\DynamicFeatureType
     */
    public function setDataSource(\StructType\StringOrRefType $dataSource = null)
    {
        $this->dataSource = $dataSource;
        return $this;
    }
    /**
     * Get dataSourceReference value
     * @return \StructType\ReferenceType|null
     */
    public function getDataSourceReference()
    {
        return $this->dataSourceReference;
    }
    /**
     * Set dataSourceReference value
     * @param \StructType\ReferenceType $dataSourceReference
     * @return \StructType\DynamicFeatureType
     */
    public function setDataSourceReference(\StructType\ReferenceType $dataSourceReference = null)
    {
        $this->dataSourceReference = $dataSourceReference;
        return $this;
    }
}
