<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dokumentmodul StructType
 * Meta information extracted from the WSDL
 * - documentation: Modul zur Abbildung von beizubringenden und hervorgehenden Dokumenten einer Leistung.
 * @subpackage Structs
 */
class Dokumentmodul extends Leistungsmodul
{
    /**
     * The dokumentEingehend
     * Meta information extracted from the WSDL
     * - documentation: Beizubringende Dokumente
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Dokument[]
     */
    public $dokumentEingehend;
    /**
     * The dokumentAusgehend
     * Meta information extracted from the WSDL
     * - documentation: Hervorgehende Dokumente
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Dokument[]
     */
    public $dokumentAusgehend;
    /**
     * The beschreibung
     * Meta information extracted from the WSDL
     * - documentation: Allgemeine (textuelle) Beschreibung des Dokumentenmoduls. Es soll angestrebt werden, die konkreten Dokumente unter "dokument" als strukturierte Daten anzugeben.Die Verwendung bestimmter HTML-Auszeichnungen (siehe Spezifikation) ist
     * hier gestattet.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\String_Localized[]
     */
    public $beschreibung;
    /**
     * The weiterfuehrenderLink
     * Meta information extracted from the WSDL
     * - documentation: Links zu weiterführenden Informationen zu den Dokumenten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HyperlinkErweitert[]
     */
    public $weiterfuehrenderLink;
    /**
     * Constructor method for Dokumentmodul
     * @uses Dokumentmodul::setDokumentEingehend()
     * @uses Dokumentmodul::setDokumentAusgehend()
     * @uses Dokumentmodul::setBeschreibung()
     * @uses Dokumentmodul::setWeiterfuehrenderLink()
     * @param \StructType\Dokument[] $dokumentEingehend
     * @param \StructType\Dokument[] $dokumentAusgehend
     * @param \StructType\String_Localized[] $beschreibung
     * @param \StructType\HyperlinkErweitert[] $weiterfuehrenderLink
     */
    public function __construct(array $dokumentEingehend = array(), array $dokumentAusgehend = array(), array $beschreibung = array(), array $weiterfuehrenderLink = array())
    {
        $this
            ->setDokumentEingehend($dokumentEingehend)
            ->setDokumentAusgehend($dokumentAusgehend)
            ->setBeschreibung($beschreibung)
            ->setWeiterfuehrenderLink($weiterfuehrenderLink);
    }
    /**
     * Get dokumentEingehend value
     * @return \StructType\Dokument[]|null
     */
    public function getDokumentEingehend()
    {
        return $this->dokumentEingehend;
    }
    /**
     * This method is responsible for validating the values passed to the setDokumentEingehend method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDokumentEingehend method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDokumentEingehendForArrayConstraintsFromSetDokumentEingehend(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dokumentmodulDokumentEingehendItem) {
            // validation for constraint: itemType
            if (!$dokumentmodulDokumentEingehendItem instanceof \StructType\Dokument) {
                $invalidValues[] = is_object($dokumentmodulDokumentEingehendItem) ? get_class($dokumentmodulDokumentEingehendItem) : sprintf('%s(%s)', gettype($dokumentmodulDokumentEingehendItem), var_export($dokumentmodulDokumentEingehendItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dokumentEingehend property can only contain items of type \StructType\Dokument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dokumentEingehend value
     * @throws \InvalidArgumentException
     * @param \StructType\Dokument[] $dokumentEingehend
     * @return \StructType\Dokumentmodul
     */
    public function setDokumentEingehend(array $dokumentEingehend = array())
    {
        // validation for constraint: array
        if ('' !== ($dokumentEingehendArrayErrorMessage = self::validateDokumentEingehendForArrayConstraintsFromSetDokumentEingehend($dokumentEingehend))) {
            throw new \InvalidArgumentException($dokumentEingehendArrayErrorMessage, __LINE__);
        }
        $this->dokumentEingehend = $dokumentEingehend;
        return $this;
    }
    /**
     * Add item to dokumentEingehend value
     * @throws \InvalidArgumentException
     * @param \StructType\Dokument $item
     * @return \StructType\Dokumentmodul
     */
    public function addToDokumentEingehend(\StructType\Dokument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Dokument) {
            throw new \InvalidArgumentException(sprintf('The dokumentEingehend property can only contain items of type \StructType\Dokument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dokumentEingehend[] = $item;
        return $this;
    }
    /**
     * Get dokumentAusgehend value
     * @return \StructType\Dokument[]|null
     */
    public function getDokumentAusgehend()
    {
        return $this->dokumentAusgehend;
    }
    /**
     * This method is responsible for validating the values passed to the setDokumentAusgehend method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDokumentAusgehend method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDokumentAusgehendForArrayConstraintsFromSetDokumentAusgehend(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dokumentmodulDokumentAusgehendItem) {
            // validation for constraint: itemType
            if (!$dokumentmodulDokumentAusgehendItem instanceof \StructType\Dokument) {
                $invalidValues[] = is_object($dokumentmodulDokumentAusgehendItem) ? get_class($dokumentmodulDokumentAusgehendItem) : sprintf('%s(%s)', gettype($dokumentmodulDokumentAusgehendItem), var_export($dokumentmodulDokumentAusgehendItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dokumentAusgehend property can only contain items of type \StructType\Dokument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dokumentAusgehend value
     * @throws \InvalidArgumentException
     * @param \StructType\Dokument[] $dokumentAusgehend
     * @return \StructType\Dokumentmodul
     */
    public function setDokumentAusgehend(array $dokumentAusgehend = array())
    {
        // validation for constraint: array
        if ('' !== ($dokumentAusgehendArrayErrorMessage = self::validateDokumentAusgehendForArrayConstraintsFromSetDokumentAusgehend($dokumentAusgehend))) {
            throw new \InvalidArgumentException($dokumentAusgehendArrayErrorMessage, __LINE__);
        }
        $this->dokumentAusgehend = $dokumentAusgehend;
        return $this;
    }
    /**
     * Add item to dokumentAusgehend value
     * @throws \InvalidArgumentException
     * @param \StructType\Dokument $item
     * @return \StructType\Dokumentmodul
     */
    public function addToDokumentAusgehend(\StructType\Dokument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Dokument) {
            throw new \InvalidArgumentException(sprintf('The dokumentAusgehend property can only contain items of type \StructType\Dokument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dokumentAusgehend[] = $item;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return \StructType\String_Localized[]|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * This method is responsible for validating the values passed to the setBeschreibung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBeschreibung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBeschreibungForArrayConstraintsFromSetBeschreibung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dokumentmodulBeschreibungItem) {
            // validation for constraint: itemType
            if (!$dokumentmodulBeschreibungItem instanceof \StructType\String_Localized) {
                $invalidValues[] = is_object($dokumentmodulBeschreibungItem) ? get_class($dokumentmodulBeschreibungItem) : sprintf('%s(%s)', gettype($dokumentmodulBeschreibungItem), var_export($dokumentmodulBeschreibungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized[] $beschreibung
     * @return \StructType\Dokumentmodul
     */
    public function setBeschreibung(array $beschreibung = array())
    {
        // validation for constraint: array
        if ('' !== ($beschreibungArrayErrorMessage = self::validateBeschreibungForArrayConstraintsFromSetBeschreibung($beschreibung))) {
            throw new \InvalidArgumentException($beschreibungArrayErrorMessage, __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Add item to beschreibung value
     * @throws \InvalidArgumentException
     * @param \StructType\String_Localized $item
     * @return \StructType\Dokumentmodul
     */
    public function addToBeschreibung(\StructType\String_Localized $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\String_Localized) {
            throw new \InvalidArgumentException(sprintf('The beschreibung property can only contain items of type \StructType\String_Localized, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->beschreibung[] = $item;
        return $this;
    }
    /**
     * Get weiterfuehrenderLink value
     * @return \StructType\HyperlinkErweitert[]|null
     */
    public function getWeiterfuehrenderLink()
    {
        return $this->weiterfuehrenderLink;
    }
    /**
     * This method is responsible for validating the values passed to the setWeiterfuehrenderLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeiterfuehrenderLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeiterfuehrenderLinkForArrayConstraintsFromSetWeiterfuehrenderLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dokumentmodulWeiterfuehrenderLinkItem) {
            // validation for constraint: itemType
            if (!$dokumentmodulWeiterfuehrenderLinkItem instanceof \StructType\HyperlinkErweitert) {
                $invalidValues[] = is_object($dokumentmodulWeiterfuehrenderLinkItem) ? get_class($dokumentmodulWeiterfuehrenderLinkItem) : sprintf('%s(%s)', gettype($dokumentmodulWeiterfuehrenderLinkItem), var_export($dokumentmodulWeiterfuehrenderLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weiterfuehrenderLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weiterfuehrenderLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert[] $weiterfuehrenderLink
     * @return \StructType\Dokumentmodul
     */
    public function setWeiterfuehrenderLink(array $weiterfuehrenderLink = array())
    {
        // validation for constraint: array
        if ('' !== ($weiterfuehrenderLinkArrayErrorMessage = self::validateWeiterfuehrenderLinkForArrayConstraintsFromSetWeiterfuehrenderLink($weiterfuehrenderLink))) {
            throw new \InvalidArgumentException($weiterfuehrenderLinkArrayErrorMessage, __LINE__);
        }
        $this->weiterfuehrenderLink = $weiterfuehrenderLink;
        return $this;
    }
    /**
     * Add item to weiterfuehrenderLink value
     * @throws \InvalidArgumentException
     * @param \StructType\HyperlinkErweitert $item
     * @return \StructType\Dokumentmodul
     */
    public function addToWeiterfuehrenderLink(\StructType\HyperlinkErweitert $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HyperlinkErweitert) {
            throw new \InvalidArgumentException(sprintf('The weiterfuehrenderLink property can only contain items of type \StructType\HyperlinkErweitert, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weiterfuehrenderLink[] = $item;
        return $this;
    }
}
