<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DerivationUnitTermType StructType
 * @subpackage Structs
 */
class DerivationUnitTermType extends AbstractStructBase
{
    /**
     * The exponent
     * @var int
     */
    public $exponent;
    /**
     * Constructor method for DerivationUnitTermType
     * @uses DerivationUnitTermType::setExponent()
     * @param int $exponent
     */
    public function __construct($exponent = null)
    {
        $this
            ->setExponent($exponent);
    }
    /**
     * Get exponent value
     * @return int|null
     */
    public function getExponent()
    {
        return $this->exponent;
    }
    /**
     * Set exponent value
     * @param int $exponent
     * @return \StructType\DerivationUnitTermType
     */
    public function setExponent($exponent = null)
    {
        // validation for constraint: int
        if (!is_null($exponent) && !(is_int($exponent) || ctype_digit($exponent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exponent, true), gettype($exponent)), __LINE__);
        }
        $this->exponent = $exponent;
        return $this;
    }
}
