<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Decimal_PropertyType StructType
 * @subpackage Structs
 */
class Decimal_PropertyType extends AbstractStructBase
{
    /**
     * The Decimal
     * @var float
     */
    public $Decimal;
    /**
     * The nilReason
     * @var string
     */
    public $nilReason;
    /**
     * Constructor method for Decimal_PropertyType
     * @uses Decimal_PropertyType::setDecimal()
     * @uses Decimal_PropertyType::setNilReason()
     * @param float $decimal
     * @param string $nilReason
     */
    public function __construct($decimal = null, $nilReason = null)
    {
        $this
            ->setDecimal($decimal)
            ->setNilReason($nilReason);
    }
    /**
     * Get Decimal value
     * @return float|null
     */
    public function getDecimal()
    {
        return $this->Decimal;
    }
    /**
     * Set Decimal value
     * @param float $decimal
     * @return \StructType\Decimal_PropertyType
     */
    public function setDecimal($decimal = null)
    {
        // validation for constraint: float
        if (!is_null($decimal) && !(is_float($decimal) || is_numeric($decimal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($decimal, true), gettype($decimal)), __LINE__);
        }
        $this->Decimal = $decimal;
        return $this;
    }
    /**
     * Get nilReason value
     * @return string|null
     */
    public function getNilReason()
    {
        return $this->nilReason;
    }
    /**
     * Set nilReason value
     * @param string $nilReason
     * @return \StructType\Decimal_PropertyType
     */
    public function setNilReason($nilReason = null)
    {
        // validation for constraint: string
        if (!is_null($nilReason) && !is_string($nilReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nilReason, true), gettype($nilReason)), __LINE__);
        }
        $this->nilReason = $nilReason;
        return $this;
    }
}
